/* $Id: visual.c,v 1.15 1999/04/12 21:59:33 marcus Exp $
******************************************************************************

   Tltarget.

   Copyright (C) 1998 Andrew Apted    [andrew@ggi-project.org]

   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************************
*/

#include <stdlib.h>
#include <string.h>

#include <ggi/internal/ggi-dl.h>

#include "libtele.h"
#include <ggi/display/tele.h>


int GGIdlinit(ggi_visual *vis,const char *args,void *argptr)
{
	TeleHook *th;

	int err;

	
	/* initialize */
	
	LIBGGI_FD(vis)=-1;

	LIBGGI_PRIVATE(vis) = th = _ggi_malloc(sizeof(TeleHook));

	th->client = _ggi_malloc(sizeof(TeleClient));
	th->connected = 0;
	th->mode_up = 0;
	th->wait_event = NULL;

	vis->gc = _ggi_malloc(sizeof(ggi_gc));


	/* set up function pointers */

	vis->opdisplay->getmode=GGI_tele_getmode;
	vis->opdisplay->setmode=GGI_tele_setmode;
	vis->opdisplay->checkmode=GGI_tele_checkmode;
	vis->opdisplay->flush=GGI_tele_flush;


	/* connect to the server */

	fprintf(stderr, "Connecting to the TeleServer...\n");

	if (args) {
		err = tclient_open(th->client, args);
	} else {
		err = tclient_open(th->client, "inet:127.0.0.1:27780");
	}

	if (err < 0) {
		free(vis->gc);
		free(th->client);
		free(th);
		return -1;
	}
	
	th->connected = 1;

	fprintf(stderr, "... connection established.\n");

	
	/* set up GII */

	GGIDPRINT_MISC("gii starting\n");

	/* first allocate a new gii_input descriptor */

	if ((th->input = _giiInputAlloc()) == NULL) {
		GGIDPRINT_MISC("giiInputAlloc failure.\n");
		return GGI_DL_ERROR;
	}
	GGIDPRINT_MISC("gii input=%p\n", th->input);

	/* now fill in the blanks */

	th->input->priv = th;

	th->input->targetcan = emAll; 
	th->input->GIIseteventmask(th->input, th->input->targetcan);

	th->input->maxfd = 0;	/* this is polled */
	th->input->flags |= GII_FLAGS_HASPOLLED;

	/* We only need the "poll" function.  For all others, the
	 * defaults are fine.
	 */
	th->input->GIIeventpoll = GII_tele_poll;

	/* now join the new event source in */
	vis->input = giiJoinInputs(vis->input, th->input);
	
	return GGI_DL_OPDISPLAY;
}

int GGIdlcleanup(ggi_visual *vis)
{
	TeleHook *th = TELE_PRIV(vis);

	if (th->mode_up) {
		GGI_tele_resetmode(vis);
	}

	if (vis->input) {
		giiClose(vis->input);
		vis->input = NULL;
	}
	
	if (th->connected) {
		tclient_close(th->client);
		th->connected = 0;
	}

	free(vis->gc);
	free(th->client);
	free(th);

	return 0;
}

int GGI_tele_flush(ggi_visual *vis, int x, int y, int w, int h, int tryflag)
{
	TeleHook *th = TELE_PRIV(vis);
	TeleEvent ev;

	int err;

	if (! th->mode_up) {
		return -1;
	}

	tclient_new_event(th->client, &ev, TELE_CMD_FLUSH, 0, 0);

	err = tclient_write(th->client, &ev);

	if (err == TELE_ERROR_SHUTDOWN) {
		TELE_HANDLE_SHUTDOWN;
	}

	return err;
}

#include <ggi/internal/ggidlinit.h>
