/*
   Header definitions for format converters for the HERMES library
   Copyright (c) 1998 Christian Nentwich (c.nentwich@cs.ucl.ac.uk)
   This source code is licensed under the GNU LGPL
  
   Please refer to the file COPYING contained in the distribution for
   licensing conditions
*/

#ifndef __HERMES_INTERNAL_CONVERT__
#define __HERMES_INTERNAL_CONVERT__

#include "H_Types.h"
#include "H_Format.h"
#include "Utility.h"
#include "HermConf.h"


/* Flag to mark generic converters (as opposed to specialised) */

#define HERMES_CONVERT_GENERIC 65536



/* Pointer to specialised (one-scanline-only) conversion function */

typedef void (*HermesConverterPtr)(char8 *source,char8 *dest,
				   unsigned int count,unsigned int inc_source);



/* Structure for conversion loop routines, don't be scared, size does NOT
   matter in this case :) */

typedef struct {
  char8 *s_pixels;
  int s_width,s_height;
  int s_add;                        /* Offset to next line from end of line */

  char8 *d_pixels;
  int d_width,d_height;
  int d_add;                        

  HermesConverterPtr func;

  int32 *lookup;                    /* Palette lookup table ptr, for 8 bit */

  int s_pitch;                      /* Source and destination pitch, */
  int d_pitch;                      /* only used by C routines */

  HermesGenericInfo info;           /* Only used by generic converters */
  int32 mask_r,mask_g,mask_b;       /* Only used by generic converters */
} HermesConverterInterface;



/* Pointer to loop function (C, assembler main loop, generic routines) */

typedef void STACKCALL (*HermesConverterLoopPtr)(HermesConverterInterface*);



typedef struct {

  HermesFormat source,dest;                /* Source and destination format */
  int32* lookup;                           /* Pointer to lookup table (8bit) */

  unsigned long flags;                     /* Defined in H_Conv.h, DITHER,etc*/

  HermesConverterLoopPtr loopnormal;       /* Loop routine for normal conv. */
  HermesConverterLoopPtr loopstretch;
  HermesConverterPtr normal;               /* One-scanline routine */
  HermesConverterPtr stretch;

  HermesConverterLoopPtr dither;           /* Dithering routines always */
  HermesConverterLoopPtr ditherstretch;    /* convert the whole buffer */

} HermesConverter;




extern HermesConverter **standardConverters[];
extern HermesConverter *equalConverters[];

extern int numConverters[];


#endif


