/********************************************************************************
*                                                                               *
*                           Device Context Tester                               *
*                                                                               *
*********************************************************************************
* Copyright (C) 1999 by Jeroen van der Zijp.   All Rights Reserved.             *
*********************************************************************************
* $Id: dctest.cpp,v 1.2 1999/09/14 19:24:07 jeroen Exp $                       *
********************************************************************************/
#include "fx.h"
#include <string.h>
#include "dippy.h"


/* Generated by reswrap from file double_dash.gif */
const unsigned char double_dash[]={
  0x47,0x49,0x46,0x38,0x37,0x61,0x20,0x00,0x04,0x00,0xf0,0x00,0x00,0x00,0x00,0xff,
  0x00,0xff,0xff,0x2c,0x00,0x00,0x00,0x00,0x20,0x00,0x04,0x00,0x00,0x02,0x17,0x84,
  0x83,0x06,0x18,0xca,0x9e,0x4e,0x84,0x4d,0xd6,0x35,0x9f,0x55,0xbb,0xe3,0xab,0x7d,
  0x9c,0xe8,0x85,0x66,0x54,0x00,0x00,0x3b
  };

/* Generated by reswrap from file onoff_dash.gif */
const unsigned char onoff_dash[]={
  0x47,0x49,0x46,0x38,0x37,0x61,0x20,0x00,0x04,0x00,0xf0,0x00,0x00,0x00,0x00,0xff,
  0xb2,0xc0,0xdc,0x2c,0x00,0x00,0x00,0x00,0x20,0x00,0x04,0x00,0x00,0x02,0x17,0x84,
  0x83,0x06,0x18,0xca,0x9e,0x4e,0x84,0x4d,0xd6,0x35,0x9f,0x55,0xbb,0xe3,0xab,0x7d,
  0x9c,0xe8,0x85,0x66,0x54,0x00,0x00,0x3b
  };

/* Generated by reswrap from file solid_line.gif */
const unsigned char solid_line[]={
  0x47,0x49,0x46,0x38,0x37,0x61,0x20,0x00,0x04,0x00,0xf0,0x00,0x00,0x00,0x00,0xff,
  0x00,0x00,0x00,0x2c,0x00,0x00,0x00,0x00,0x20,0x00,0x04,0x00,0x00,0x02,0x0a,0x84,
  0x8f,0xa9,0xcb,0xed,0x0f,0xa3,0x9c,0xac,0x00,0x00,0x3b
  };

/* Generated by reswrap from file capbutt.gif */
const unsigned char capbutt[]={
  0x47,0x49,0x46,0x38,0x37,0x61,0x20,0x00,0x0c,0x00,0xf1,0x00,0x00,0xb2,0xc0,0xdc,
  0x00,0x00,0x00,0x00,0x00,0xff,0x00,0x00,0x00,0x2c,0x00,0x00,0x00,0x00,0x20,0x00,
  0x0c,0x00,0x00,0x02,0x27,0x84,0x8f,0xa9,0x17,0xb1,0x0f,0x55,0x8b,0x14,0xce,0x27,
  0xb2,0xde,0xbc,0xdf,0xd5,0x85,0xe2,0xa7,0x88,0xe6,0x46,0x26,0xe7,0x9a,0x22,0xeb,
  0xd9,0x1e,0xaf,0x19,0x57,0x54,0x6d,0x5b,0x4e,0xce,0xb7,0x05,0x00,0x3b
  };

/* Generated by reswrap from file capnotlast.gif */
const unsigned char capnotlast[]={
  0x47,0x49,0x46,0x38,0x37,0x61,0x20,0x00,0x0c,0x00,0xf1,0x00,0x00,0xb2,0xc0,0xdc,
  0x00,0x00,0x00,0x00,0x00,0xff,0x00,0x00,0x00,0x2c,0x00,0x00,0x00,0x00,0x20,0x00,
  0x0c,0x00,0x00,0x02,0x2b,0x84,0x8f,0xa9,0x17,0xb1,0x0f,0x55,0x8b,0x14,0xce,0x27,
  0xb2,0xde,0x7c,0x9b,0xbb,0x74,0x62,0xf7,0x39,0xd8,0x88,0x0a,0x25,0x94,0xa2,0xeb,
  0xd9,0x92,0x00,0xa8,0xc4,0xe2,0x5b,0xe5,0x8c,0xa9,0xeb,0x74,0x4f,0xf9,0x01,0x0a,
  0x00,0x3b
  };

/* Generated by reswrap from file capproj.gif */
const unsigned char capproj[]={
  0x47,0x49,0x46,0x38,0x37,0x61,0x20,0x00,0x0c,0x00,0xf1,0x00,0x00,0xb2,0xc0,0xdc,
  0x00,0x00,0x00,0x00,0x00,0xff,0x00,0x00,0x00,0x2c,0x00,0x00,0x00,0x00,0x20,0x00,
  0x0c,0x00,0x00,0x02,0x2c,0x84,0x8f,0xa9,0x17,0xb1,0x0f,0x55,0x8b,0x14,0xce,0x27,
  0xb2,0xde,0xbc,0x37,0xad,0x74,0xe2,0xf8,0x65,0xe1,0x88,0x6a,0xa5,0x70,0xa6,0xe8,
  0xda,0xba,0x22,0x9c,0xc8,0x6f,0x00,0x56,0x3a,0x70,0xed,0x7b,0xef,0xab,0x00,0x0d,
  0x05,0x00,0x3b
  };

/* Generated by reswrap from file capround.gif */
const unsigned char capround[]={
  0x47,0x49,0x46,0x38,0x37,0x61,0x20,0x00,0x0c,0x00,0xf1,0x00,0x00,0xb2,0xc0,0xdc,
  0x00,0x00,0x00,0x00,0x00,0xff,0x00,0x00,0x00,0x2c,0x00,0x00,0x00,0x00,0x20,0x00,
  0x0c,0x00,0x00,0x02,0x2c,0x84,0x8f,0xa9,0x17,0xb1,0x0f,0x55,0x8b,0x14,0xce,0x27,
  0xb2,0xde,0xbc,0x37,0x81,0x75,0xa2,0xf8,0x81,0xca,0x88,0x6e,0xa5,0x89,0xa4,0xee,
  0x7a,0xba,0x68,0xb9,0xc8,0x73,0xc0,0x56,0x3a,0x70,0xed,0x7b,0xef,0xab,0x00,0x0d,
  0x05,0x00,0x3b
  };
  
/* Generated by reswrap from file jbevel.gif */
const unsigned char jbevel[]={
  0x47,0x49,0x46,0x38,0x37,0x61,0x20,0x00,0x10,0x00,0xf0,0x00,0x00,0xb2,0xc0,0xdc,
  0x00,0x00,0xff,0x2c,0x00,0x00,0x00,0x00,0x20,0x00,0x10,0x00,0x00,0x02,0x30,0x84,
  0x8f,0xa9,0xcb,0xed,0xff,0x82,0x94,0xb0,0x82,0x89,0xad,0xc3,0x5c,0x2f,0x0e,0x7a,
  0x08,0x48,0x8a,0x57,0x67,0x84,0x9a,0x7a,0xb0,0x11,0x9a,0xb8,0x8c,0x3c,0xc2,0x9f,
  0x7d,0x67,0xf9,0x54,0xd1,0x74,0xf3,0xe3,0x79,0x84,0x33,0xd3,0x45,0x51,0x00,0x00,
  0x3b
  };

/* Generated by reswrap from file jmiter.gif */
const unsigned char jmiter[]={
  0x47,0x49,0x46,0x38,0x37,0x61,0x20,0x00,0x10,0x00,0xf0,0x00,0x00,0xb2,0xc0,0xdc,
  0x00,0x00,0xff,0x2c,0x00,0x00,0x00,0x00,0x20,0x00,0x10,0x00,0x00,0x02,0x33,0x84,
  0x8f,0x19,0xc9,0xed,0x18,0xe2,0x9b,0x2f,0x5a,0x8a,0x8f,0xdd,0x99,0xee,0xdf,0x39,
  0xdf,0x18,0x2a,0x23,0x59,0x02,0xa8,0x0a,0x86,0xab,0xf1,0x4e,0x31,0xdc,0xca,0x35,
  0x33,0x43,0x77,0x93,0xb3,0x1c,0x36,0xeb,0xf1,0x76,0xb4,0x45,0xe9,0x52,0x49,0xc1,
  0x18,0x05,0x00,0x3b
  };

/* Generated by reswrap from file jround.gif */
const unsigned char jround[]={
  0x47,0x49,0x46,0x38,0x37,0x61,0x20,0x00,0x10,0x00,0xf0,0x00,0x00,0xb2,0xc0,0xdc,
  0x00,0x00,0xff,0x2c,0x00,0x00,0x00,0x00,0x20,0x00,0x10,0x00,0x00,0x02,0x32,0x84,
  0x8f,0xa9,0xcb,0xed,0x0f,0x83,0x84,0xd4,0xc8,0x3b,0x6b,0xc3,0x5c,0x2f,0x0e,0x7a,
  0x08,0x48,0x8a,0x40,0x68,0x75,0x1a,0x7a,0xb0,0x8f,0xdb,0xaa,0x0e,0x3c,0xca,0x9f,
  0x7d,0x63,0x0c,0x9d,0x5f,0x0a,0xbf,0xc3,0xa5,0x02,0x22,0xdf,0xc6,0x74,0x52,0x14,
  0x00,0x00,0x3b
  };

/*******************************************************************************/

// Device context demo application
// When complete, this demo should show off aspects of the FXDC API, such as:
// -> points
// -> lines (with various line styles, end caps and join styles)
// -> rectangles (filled and unfilled)
// -> arcs (filled and unfilled)
// -> polygons (filled and unfilled)
// -> fill patterns and built-in stipple patterns
// -> various blitting modes
// -> drawing images, icons and bitmaps
// -> clipping
// -> and so much more...

class DCTestWindow : public FXMainWindow {
  FXDECLARE(DCTestWindow)
private:
  DCTestWindow(){}
  DCTestWindow(const DCTestWindow&);
  DCTestWindow& operator=(const DCTestWindow&);

protected:
  
  // Drawing parameters
  FXFunction         function;        // BLIT function
  FXLineStyle	     lineStyle;       // Line style
  FXCapStyle	     capStyle;        // Cap style
  FXJoinStyle	     joinStyle;       // Join style
  FXFillStyle        fillStyle;       // Filling style
  FXFillRule         fillRule;        // Polygon fill rule
  FXColor            forecolor;       // Foreground color
  FXColor            backcolor;       // Background color
  FXColor            erasecolor;      // Canvas erased color
  FXStipplePattern   stipple;         // Stipple pattern
  FXImage	    *birdImage;       // Test image
  FXBitmap          *testBitmap;      // Test bitmap
  FXImage           *tileTest;        // Tiled image
  FXFont            *testFont;        // Test font
    
  // Widgets
  FXCanvas*	     linesCanvas;
  FXCanvas*	     shapesCanvas;
  FXSpinner*	     lineWidthSpinner;
  FXColorWell*	     backWell;
  FXColorWell*	     foreWell;
  FXColorWell*	     eraseWell;
  
public:
  
  // Draw page
  void drawPage(FXDC& dc,FXint w,FXint h);

public:
  long onPaintLines(FXObject*,FXSelector,void*);
  long onPaintShapes(FXObject*,FXSelector,void*);
  long onPaintImages(FXObject*,FXSelector,void*);
  long onLineWidth(FXObject*,FXSelector,void*);
  long onCmdFunction(FXObject*,FXSelector,void*);
  long onUpdFunction(FXObject*,FXSelector,void*);
  long onCmdLineStyle(FXObject*,FXSelector,void*);
  long onUpdLineStyle(FXObject*,FXSelector,void*);
  long onCmdCapStyle(FXObject*,FXSelector,void*);
  long onUpdCapStyle(FXObject*,FXSelector,void*);
  long onCmdJoinStyle(FXObject*,FXSelector,void*);
  long onUpdJoinStyle(FXObject*,FXSelector,void*);
  long onCmdEraseColor(FXObject*,FXSelector,void*);
  long onUpdEraseColor(FXObject*,FXSelector,void*);
  long onCmdForeColor(FXObject*,FXSelector,void*);
  long onUpdForeColor(FXObject*,FXSelector,void*);
  long onCmdBackColor(FXObject*,FXSelector,void*);
  long onUpdBackColor(FXObject*,FXSelector,void*);
  long onCmdFont(FXObject*,FXSelector,void*);
  long onCmdStipple(FXObject*,FXSelector,void*);
  long onCmdFillStyle(FXObject*,FXSelector,void*);
  long onUpdFillStyle(FXObject*,FXSelector,void*);
  long onCmdPrint(FXObject*,FXSelector,void*);
public:
  enum{
    ID_LINES=FXMainWindow::ID_LAST,
    ID_SHAPES,
    ID_IMAGES,
    ID_LINE_WIDTH,
    ID_CLR,
    ID_SRC_AND_DST,
    ID_SRC_AND_NOT_DST,
    ID_SRC,
    ID_NOT_SRC_AND_DST,
    ID_DST,
    ID_SRC_XOR_DST,
    ID_SRC_OR_DST,
    ID_NOT_SRC_AND_NOT_DST,
    ID_NOT_SRC_XOR_DST,
    ID_NOT_DST,
    ID_SRC_OR_NOT_DST,
    ID_NOT_SRC,
    ID_NOT_SRC_OR_DST,
    ID_NOT_SRC_OR_NOT_DST,
    ID_SET,
    ID_LINE_SOLID,
    ID_LINE_ONOFF_DASH,
    ID_LINE_DOUBLE_DASH,
    ID_CAP_NOT_LAST,
    ID_CAP_BUTT,
    ID_CAP_ROUND,
    ID_CAP_PROJECTING,
    ID_JOIN_MITER,
    ID_JOIN_ROUND,
    ID_JOIN_BEVEL,
    ID_ERASE_COLOR,
    ID_FORE_COLOR,
    ID_BACK_COLOR,
    ID_FONT,
    ID_STIPPLE_0,
    ID_STIPPLE_NONE=ID_STIPPLE_0,
    ID_STIPPLE_BLACK=ID_STIPPLE_0,
    ID_STIPPLE_1,
    ID_STIPPLE_2,
    ID_STIPPLE_3,
    ID_STIPPLE_4,
    ID_STIPPLE_5,
    ID_STIPPLE_6,
    ID_STIPPLE_7,
    ID_STIPPLE_8,
    ID_STIPPLE_GRAY=ID_STIPPLE_8,
    ID_STIPPLE_9,
    ID_STIPPLE_10,
    ID_STIPPLE_11,
    ID_STIPPLE_12,
    ID_STIPPLE_13,
    ID_STIPPLE_14,
    ID_STIPPLE_15,
    ID_STIPPLE_16,
    ID_STIPPLE_WHITE=ID_STIPPLE_16,
    ID_STIPPLE_HORZ,      
    ID_STIPPLE_VERT,      
    ID_STIPPLE_CROSS,     
    ID_STIPPLE_DIAG,      
    ID_STIPPLE_REVDIAG,   
    ID_STIPPLE_CROSSDIAG, 
    ID_FILL_SOLID,
    ID_FILL_TILED,
    ID_FILL_STIPPLED,
    ID_FILL_OPAQUESTIPPLED,
    ID_PRINT,
    ID_LAST
    };
public:
  DCTestWindow(FXApp *app);
  void create();
  };


/*******************************************************************************/
  
// Message map
FXDEFMAP(DCTestWindow) DCTestWindowMap[]={
  FXMAPFUNC(SEL_PAINT,    DCTestWindow::ID_LINES,                                           DCTestWindow::onPaintLines),
  FXMAPFUNC(SEL_PAINT,    DCTestWindow::ID_SHAPES,                                          DCTestWindow::onPaintShapes),
  FXMAPFUNC(SEL_PAINT,    DCTestWindow::ID_IMAGES,                                          DCTestWindow::onPaintImages),
  FXMAPFUNC(SEL_COMMAND,  DCTestWindow::ID_FONT,                                            DCTestWindow::onCmdFont),
  FXMAPFUNC(SEL_COMMAND,  DCTestWindow::ID_PRINT,                                           DCTestWindow::onCmdPrint),
  FXMAPFUNC(SEL_COMMAND,  DCTestWindow::ID_ERASE_COLOR,                                     DCTestWindow::onCmdEraseColor),
  FXMAPFUNC(SEL_CHANGED,  DCTestWindow::ID_ERASE_COLOR,                                     DCTestWindow::onCmdEraseColor),
  FXMAPFUNC(SEL_UPDATE,   DCTestWindow::ID_ERASE_COLOR,                                     DCTestWindow::onUpdEraseColor),
  FXMAPFUNC(SEL_COMMAND,  DCTestWindow::ID_FORE_COLOR,                                      DCTestWindow::onCmdForeColor),
  FXMAPFUNC(SEL_CHANGED,  DCTestWindow::ID_FORE_COLOR,                                      DCTestWindow::onCmdForeColor),
  FXMAPFUNC(SEL_UPDATE,   DCTestWindow::ID_FORE_COLOR,                                      DCTestWindow::onUpdForeColor),
  FXMAPFUNC(SEL_COMMAND,  DCTestWindow::ID_BACK_COLOR,                                      DCTestWindow::onCmdBackColor),
  FXMAPFUNC(SEL_CHANGED,  DCTestWindow::ID_BACK_COLOR,                                      DCTestWindow::onCmdBackColor),
  FXMAPFUNC(SEL_UPDATE,   DCTestWindow::ID_BACK_COLOR,                                      DCTestWindow::onUpdBackColor),
  FXMAPFUNC(SEL_COMMAND,  DCTestWindow::ID_LINE_WIDTH,                                      DCTestWindow::onLineWidth),
  FXMAPFUNCS(SEL_COMMAND, DCTestWindow::ID_CLR,          DCTestWindow::ID_SET,              DCTestWindow::onCmdFunction),
  FXMAPFUNCS(SEL_UPDATE,  DCTestWindow::ID_CLR,          DCTestWindow::ID_SET,              DCTestWindow::onUpdFunction),
  FXMAPFUNCS(SEL_COMMAND, DCTestWindow::ID_LINE_SOLID,   DCTestWindow::ID_LINE_DOUBLE_DASH, DCTestWindow::onCmdLineStyle),
  FXMAPFUNCS(SEL_UPDATE,  DCTestWindow::ID_LINE_SOLID,   DCTestWindow::ID_LINE_DOUBLE_DASH, DCTestWindow::onUpdLineStyle),
  FXMAPFUNCS(SEL_COMMAND, DCTestWindow::ID_CAP_NOT_LAST, DCTestWindow::ID_CAP_PROJECTING,   DCTestWindow::onCmdCapStyle),
  FXMAPFUNCS(SEL_UPDATE,  DCTestWindow::ID_CAP_NOT_LAST, DCTestWindow::ID_CAP_PROJECTING,   DCTestWindow::onUpdCapStyle),
  FXMAPFUNCS(SEL_COMMAND, DCTestWindow::ID_JOIN_MITER,   DCTestWindow::ID_JOIN_BEVEL,       DCTestWindow::onCmdJoinStyle),
  FXMAPFUNCS(SEL_UPDATE,  DCTestWindow::ID_JOIN_MITER,   DCTestWindow::ID_JOIN_BEVEL,       DCTestWindow::onUpdJoinStyle),
  FXMAPFUNCS(SEL_COMMAND, DCTestWindow::ID_STIPPLE_0,    DCTestWindow::ID_STIPPLE_CROSSDIAG,DCTestWindow::onCmdStipple),
  FXMAPFUNCS(SEL_COMMAND, DCTestWindow::ID_FILL_SOLID,DCTestWindow::ID_FILL_OPAQUESTIPPLED, DCTestWindow::onCmdFillStyle),
  FXMAPFUNCS(SEL_UPDATE,  DCTestWindow::ID_FILL_SOLID,DCTestWindow::ID_FILL_OPAQUESTIPPLED, DCTestWindow::onUpdFillStyle),
  };

  
// Object implementation
FXIMPLEMENT(DCTestWindow,FXMainWindow,DCTestWindowMap,ARRAYNUMBER(DCTestWindowMap))
 
  
/*******************************************************************************/

  
// Make some windows
DCTestWindow::DCTestWindow(FXApp *app):FXMainWindow(app,"Device Context Test",NULL,NULL,DECOR_ALL,0,0,850,700){

  FXuint opts=FRAME_SUNKEN|FRAME_THICK|LAYOUT_FILL_X|LAYOUT_FILL_Y;

  // Preferred line attributes
  lineStyle=LINE_SOLID;
  capStyle=CAP_BUTT;
  joinStyle=JOIN_MITER;

  // Tooltip
  FXTooltip *tooltip=new FXTooltip(getApp());
  
  // Menubar
  FXMenuBar *menubar=new FXMenuBar(this,LAYOUT_SIDE_TOP|LAYOUT_FILL_X);
  
  // Separator
  new FXHorizontalSeparator(this,LAYOUT_SIDE_TOP|LAYOUT_FILL_X|SEPARATOR_GROOVE);

  // Contents
  FXHorizontalFrame *contents=new FXHorizontalFrame(this,LAYOUT_SIDE_TOP|FRAME_NONE|LAYOUT_FILL_X|LAYOUT_FILL_Y|PACK_UNIFORM_WIDTH);
  
  // Controls on right
  FXVerticalFrame *controls=new FXVerticalFrame(contents,LAYOUT_RIGHT|LAYOUT_FILL_Y);
  
  // Block for blit modes
  new FXLabel(controls,"BLIT Function:",NULL,LAYOUT_LEFT);
  FXMatrix *blitgrid=new FXMatrix(controls,4,FRAME_RIDGE|MATRIX_BY_COLUMNS|LAYOUT_FILL_X|PACK_UNIFORM_WIDTH, 0,0,0,0, 2,2,2,2, 0,0);
  
  // One button for each mode
  new FXButton(blitgrid,"Clear\tBLT_CLR",NULL,this,ID_CLR,BUTTON_TOOLBAR|FRAME_RAISED|LAYOUT_FILL_X|LAYOUT_FILL_Y|LAYOUT_FILL_COLUMN);
  new FXButton(blitgrid,"And\tBLT_SRC_AND_DST",NULL,this,ID_SRC_AND_DST,BUTTON_TOOLBAR|FRAME_RAISED|LAYOUT_FILL_X|LAYOUT_FILL_Y|LAYOUT_FILL_COLUMN);
  new FXButton(blitgrid,"AndRev\tBLT_SRC_AND_NOT_DST",NULL,this,ID_SRC_AND_NOT_DST,BUTTON_TOOLBAR|FRAME_RAISED|LAYOUT_FILL_X|LAYOUT_FILL_Y|LAYOUT_FILL_COLUMN);
  new FXButton(blitgrid,"Copy\tBLT_SRC",NULL,this,ID_SRC,BUTTON_TOOLBAR|FRAME_RAISED|LAYOUT_FILL_X|LAYOUT_FILL_Y|LAYOUT_FILL_COLUMN);
  
  new FXButton(blitgrid,"AndInv\tBLT_NOT_SRC_AND_DST",NULL,this,ID_NOT_SRC_AND_DST,BUTTON_TOOLBAR|FRAME_RAISED|LAYOUT_FILL_X|LAYOUT_FILL_Y|LAYOUT_FILL_COLUMN);
  new FXButton(blitgrid,"NoOp\tBLT_DST",NULL,this,ID_DST,BUTTON_TOOLBAR|FRAME_RAISED|LAYOUT_FILL_X|LAYOUT_FILL_Y|LAYOUT_FILL_COLUMN);
  new FXButton(blitgrid,"Xor\tBLT_SRC_XOR_DST",NULL,this,ID_SRC_XOR_DST,BUTTON_TOOLBAR|FRAME_RAISED|LAYOUT_FILL_X|LAYOUT_FILL_Y|LAYOUT_FILL_COLUMN);
  new FXButton(blitgrid,"Or\tBLT_SRC_OR_DST",NULL,this,ID_SRC_OR_DST,BUTTON_TOOLBAR|FRAME_RAISED|LAYOUT_FILL_X|LAYOUT_FILL_Y|LAYOUT_FILL_COLUMN);
  
  new FXButton(blitgrid,"Nor\tBLT_NOT_SRC_AND_NOT_DST",NULL,this,ID_NOT_SRC_AND_NOT_DST,BUTTON_TOOLBAR|FRAME_RAISED|LAYOUT_FILL_X|LAYOUT_FILL_Y|LAYOUT_FILL_COLUMN);
  new FXButton(blitgrid,"Equiv\tBLT_NOT_SRC_XOR_DST",NULL,this,ID_NOT_SRC_XOR_DST,BUTTON_TOOLBAR|FRAME_RAISED|LAYOUT_FILL_X|LAYOUT_FILL_Y|LAYOUT_FILL_COLUMN);
  new FXButton(blitgrid,"Invert\tBLT_NOT_DST",NULL,this,ID_NOT_DST,BUTTON_TOOLBAR|FRAME_RAISED|LAYOUT_FILL_X|LAYOUT_FILL_Y|LAYOUT_FILL_COLUMN);
  new FXButton(blitgrid,"OrRev\tBLT_SRC_OR_NOT_DST",NULL,this,ID_SRC_OR_NOT_DST,BUTTON_TOOLBAR|FRAME_RAISED|LAYOUT_FILL_X|LAYOUT_FILL_Y|LAYOUT_FILL_COLUMN);
  
  new FXButton(blitgrid,"CopyInv\tBLT_NOT_SRC",NULL,this,ID_NOT_SRC,BUTTON_TOOLBAR|FRAME_RAISED|LAYOUT_FILL_X|LAYOUT_FILL_Y|LAYOUT_FILL_COLUMN);
  new FXButton(blitgrid,"OrInv\tBLT_NOT_SRC_OR_DST",NULL,this,ID_NOT_SRC_OR_DST,BUTTON_TOOLBAR|FRAME_RAISED|LAYOUT_FILL_X|LAYOUT_FILL_Y|LAYOUT_FILL_COLUMN);
  new FXButton(blitgrid,"Nand\tBLT_NOT_SRC_OR_NOT_DST",NULL,this,ID_NOT_SRC_OR_NOT_DST,BUTTON_TOOLBAR|FRAME_RAISED|LAYOUT_FILL_X|LAYOUT_FILL_Y|LAYOUT_FILL_COLUMN);
  new FXButton(blitgrid,"Set\tBLT_SET",NULL,this,ID_SET,BUTTON_TOOLBAR|FRAME_RAISED|LAYOUT_FILL_X|LAYOUT_FILL_Y|LAYOUT_FILL_COLUMN);
  
  // Line Dash Style
  new FXLabel(controls,"Line Style:",NULL,LAYOUT_LEFT);
  FXMatrix *linestyle=new FXMatrix(controls,3,FRAME_RIDGE|MATRIX_BY_COLUMNS|LAYOUT_FILL_X, 0,0,0,0, 2,2,2,2, 0,0);
  new FXButton(linestyle,"\tLINE_SOLID",new FXGIFIcon(getApp(),solid_line,0,IMAGE_OPAQUE),this,ID_LINE_SOLID,BUTTON_TOOLBAR|JUSTIFY_CENTER_X|FRAME_RAISED|LAYOUT_FILL_X|LAYOUT_FILL_Y|LAYOUT_FILL_COLUMN);
  new FXButton(linestyle,"\tLINE_ONOFF_DASH",new FXGIFIcon(getApp(),onoff_dash,FXRGB(0xb2,0xc0,0xdc),IMAGE_ALPHACOLOR),this,ID_LINE_ONOFF_DASH,BUTTON_TOOLBAR|JUSTIFY_CENTER_X|FRAME_RAISED|LAYOUT_FILL_X|LAYOUT_FILL_Y|LAYOUT_FILL_COLUMN);
  new FXButton(linestyle,"\tLINE_DOUBLE_DASH",new FXGIFIcon(getApp(),double_dash,0,IMAGE_OPAQUE),this,ID_LINE_DOUBLE_DASH,BUTTON_TOOLBAR|JUSTIFY_CENTER_X|FRAME_RAISED|LAYOUT_FILL_X|LAYOUT_FILL_Y|LAYOUT_FILL_COLUMN);
  
  // Line Cap Style
  new FXLabel(controls,"Cap Style:",NULL,LAYOUT_LEFT);
  FXMatrix *capstyle=new FXMatrix(controls,4,FRAME_RIDGE|MATRIX_BY_COLUMNS|LAYOUT_FILL_X, 0,0,0,0, 2,2,2,2, 0,0);
  new FXButton(capstyle,"\tCAP_NOT_LAST",new FXGIFIcon(getApp(),capnotlast),this,ID_CAP_NOT_LAST,BUTTON_TOOLBAR|JUSTIFY_CENTER_X|FRAME_RAISED|LAYOUT_FILL_X|LAYOUT_FILL_Y|LAYOUT_FILL_COLUMN);
  new FXButton(capstyle,"\tCAP_BUTT",new FXGIFIcon(getApp(),capbutt),this,ID_CAP_BUTT,BUTTON_TOOLBAR|JUSTIFY_CENTER_X|FRAME_RAISED|LAYOUT_FILL_X|LAYOUT_FILL_Y|LAYOUT_FILL_COLUMN);
  new FXButton(capstyle,"\tCAP_ROUND",new FXGIFIcon(getApp(),capround),this,ID_CAP_ROUND,BUTTON_TOOLBAR|JUSTIFY_CENTER_X|FRAME_RAISED|LAYOUT_FILL_X|LAYOUT_FILL_Y|LAYOUT_FILL_COLUMN);
  new FXButton(capstyle,"\tCAP_PROJECTING",new FXGIFIcon(getApp(),capproj),this,ID_CAP_PROJECTING,BUTTON_TOOLBAR|JUSTIFY_CENTER_X|FRAME_RAISED|LAYOUT_FILL_X|LAYOUT_FILL_Y|LAYOUT_FILL_COLUMN);
  
  // Line Join Style
  new FXLabel(controls,"Join Style:",NULL,LAYOUT_LEFT);
  FXMatrix *joinstyle=new FXMatrix(controls,3,FRAME_RIDGE|MATRIX_BY_COLUMNS|LAYOUT_FILL_X, 0,0,0,0, 2,2,2,2, 0,0);
  new FXButton(joinstyle,"\tJOIN_MITER",new FXGIFIcon(getApp(),jmiter),this,ID_JOIN_MITER,BUTTON_TOOLBAR|JUSTIFY_CENTER_X|FRAME_RAISED|LAYOUT_FILL_X|LAYOUT_FILL_Y|LAYOUT_FILL_COLUMN);
  new FXButton(joinstyle,"\tJOIN_ROUND",new FXGIFIcon(getApp(),jround),this,ID_JOIN_ROUND,BUTTON_TOOLBAR|JUSTIFY_CENTER_X|FRAME_RAISED|LAYOUT_FILL_X|LAYOUT_FILL_Y|LAYOUT_FILL_COLUMN);
  new FXButton(joinstyle,"\tJOIN_BEVEL",new FXGIFIcon(getApp(),jbevel),this,ID_JOIN_BEVEL,BUTTON_TOOLBAR|JUSTIFY_CENTER_X|FRAME_RAISED|LAYOUT_FILL_X|LAYOUT_FILL_Y|LAYOUT_FILL_COLUMN);
  
  // Colors
  new FXLabel(controls,"Colors:",NULL,LAYOUT_LEFT);
  FXMatrix *pairs=new FXMatrix(controls,2,FRAME_RIDGE|MATRIX_BY_COLUMNS|LAYOUT_FILL_X, 0,0,0,0, 2,2,2,2, 5,5);
  
  // Back Color
  new FXLabel(pairs, "Back Color:");
  backWell=new FXColorWell(pairs,FXRGB(0,0,255),this,ID_BACK_COLOR,FRAME_SUNKEN|FRAME_THICK|ICON_AFTER_TEXT|LAYOUT_FILL_X|LAYOUT_FILL_COLUMN);

  // Fore Color
  new FXLabel(pairs, "Fore Color:");
  foreWell=new FXColorWell(pairs,FXRGB(255,0,0),this,ID_FORE_COLOR,FRAME_SUNKEN|FRAME_THICK|ICON_AFTER_TEXT|LAYOUT_FILL_X|LAYOUT_FILL_COLUMN);

  // Erase Color
  new FXLabel(pairs, "Erase Color:");
  eraseWell=new FXColorWell(pairs,FXRGB(255,255,255),this,ID_ERASE_COLOR,FRAME_SUNKEN|FRAME_THICK|ICON_AFTER_TEXT|LAYOUT_FILL_X|LAYOUT_FILL_COLUMN);

  // Line weight
  FXMatrix *linew=new FXMatrix(controls,2,FRAME_RIDGE|MATRIX_BY_COLUMNS|LAYOUT_FILL_X, 0,0,0,0, 2,2,2,2, 0,0);
  new FXLabel(linew, "Line Width:");
  lineWidthSpinner=new FXSpinner(linew,4,this,ID_LINE_WIDTH,SPIN_NORMAL|FRAME_SUNKEN|FRAME_THICK|LAYOUT_FILL_X|LAYOUT_FILL_COLUMN);
  lineWidthSpinner->setMinMax(1,255);
  lineWidthSpinner->setValue(1);
  
  // Stipple
  FXMatrix *stip=new FXMatrix(controls,2,FRAME_RIDGE|MATRIX_BY_COLUMNS|LAYOUT_FILL_X, 0,0,0,0, 2,2,2,2, 0,0);
  new FXLabel(stip, "Stipples:");
  FXPopup *pop=new FXPopup(this);
  new FXOption(pop,"NONE\tSTIPPLE_NONE",NULL,this,ID_STIPPLE_NONE,JUSTIFY_HZ_APART|ICON_AFTER_TEXT);
  new FXOption(pop,"BLACK\tSTIPPLE_BLACK",NULL,this,ID_STIPPLE_BLACK,JUSTIFY_HZ_APART|ICON_AFTER_TEXT);
  new FXOption(pop,"GRAY\tSTIPPLE_GRAY",NULL,this,ID_STIPPLE_GRAY,JUSTIFY_HZ_APART|ICON_AFTER_TEXT);
  new FXOption(pop,"WHITE\tSTIPPLE_WHITE",NULL,this,ID_STIPPLE_WHITE,JUSTIFY_HZ_APART|ICON_AFTER_TEXT);
  new FXOption(pop,"0\tSTIPPLE_0",NULL,this,ID_STIPPLE_0,JUSTIFY_HZ_APART|ICON_AFTER_TEXT);
  new FXOption(pop,"1\tSTIPPLE_1",NULL,this,ID_STIPPLE_1,JUSTIFY_HZ_APART|ICON_AFTER_TEXT);
  new FXOption(pop,"2\tSTIPPLE_2",NULL,this,ID_STIPPLE_2,JUSTIFY_HZ_APART|ICON_AFTER_TEXT);
  new FXOption(pop,"3\tSTIPPLE_3",NULL,this,ID_STIPPLE_3,JUSTIFY_HZ_APART|ICON_AFTER_TEXT);
  new FXOption(pop,"4\tSTIPPLE_4",NULL,this,ID_STIPPLE_4,JUSTIFY_HZ_APART|ICON_AFTER_TEXT);
  new FXOption(pop,"5\tSTIPPLE_5",NULL,this,ID_STIPPLE_5,JUSTIFY_HZ_APART|ICON_AFTER_TEXT);
  new FXOption(pop,"6\tSTIPPLE_6",NULL,this,ID_STIPPLE_6,JUSTIFY_HZ_APART|ICON_AFTER_TEXT);
  new FXOption(pop,"7\tSTIPPLE_7",NULL,this,ID_STIPPLE_7,JUSTIFY_HZ_APART|ICON_AFTER_TEXT);
  new FXOption(pop,"8\tSTIPPLE_8",NULL,this,ID_STIPPLE_8,JUSTIFY_HZ_APART|ICON_AFTER_TEXT);
  new FXOption(pop,"9\tSTIPPLE_9",NULL,this,ID_STIPPLE_9,JUSTIFY_HZ_APART|ICON_AFTER_TEXT);
  new FXOption(pop,"10\tSTIPPLE_10",NULL,this,ID_STIPPLE_10,JUSTIFY_HZ_APART|ICON_AFTER_TEXT);
  new FXOption(pop,"11\tSTIPPLE_11",NULL,this,ID_STIPPLE_11,JUSTIFY_HZ_APART|ICON_AFTER_TEXT);
  new FXOption(pop,"12\tSTIPPLE_12",NULL,this,ID_STIPPLE_12,JUSTIFY_HZ_APART|ICON_AFTER_TEXT);
  new FXOption(pop,"13\tSTIPPLE_13",NULL,this,ID_STIPPLE_13,JUSTIFY_HZ_APART|ICON_AFTER_TEXT);
  new FXOption(pop,"14\tSTIPPLE_14",NULL,this,ID_STIPPLE_14,JUSTIFY_HZ_APART|ICON_AFTER_TEXT);
  new FXOption(pop,"15\tSTIPPLE_15",NULL,this,ID_STIPPLE_15,JUSTIFY_HZ_APART|ICON_AFTER_TEXT);
  new FXOption(pop,"16\tSTIPPLE_16",NULL,this,ID_STIPPLE_16,JUSTIFY_HZ_APART|ICON_AFTER_TEXT);
  new FXOption(pop,"HORZ\tSTIPPLE_HORZ",NULL,this,ID_STIPPLE_HORZ,JUSTIFY_HZ_APART|ICON_AFTER_TEXT);
  new FXOption(pop,"VERT\tSTIPPLE_VERT",NULL,this,ID_STIPPLE_VERT,JUSTIFY_HZ_APART|ICON_AFTER_TEXT);
  new FXOption(pop,"CROSS\tSTIPPLE_CROSS",NULL,this,ID_STIPPLE_CROSS,JUSTIFY_HZ_APART|ICON_AFTER_TEXT);
  new FXOption(pop,"DIAG\tSTIPPLE_DIAG",NULL,this,ID_STIPPLE_DIAG,JUSTIFY_HZ_APART|ICON_AFTER_TEXT);
  new FXOption(pop,"REVDIAG\tSTIPPLE_REVDIAG",NULL,this,ID_STIPPLE_REVDIAG,JUSTIFY_HZ_APART|ICON_AFTER_TEXT);
  new FXOption(pop,"CROSSDIAG\tSTIPPLE_CROSSDIAG",NULL,this,ID_STIPPLE_CROSSDIAG,JUSTIFY_HZ_APART|ICON_AFTER_TEXT);
  new FXOptionMenu(stip,pop,LAYOUT_TOP|FRAME_RAISED|FRAME_THICK|JUSTIFY_HZ_APART|ICON_AFTER_TEXT);
  
  // Fill Style
  new FXLabel(controls,"Fill Style:",NULL,LAYOUT_LEFT);
  FXMatrix *fillstyle=new FXMatrix(controls,2,FRAME_RIDGE|MATRIX_BY_COLUMNS|LAYOUT_FILL_X, 0,0,0,0, 2,2,2,2, 0,0);
  new FXButton(fillstyle,"FILL_SOLID",NULL,this,ID_FILL_SOLID,BUTTON_TOOLBAR|JUSTIFY_CENTER_X|FRAME_RAISED|LAYOUT_FILL_X|LAYOUT_FILL_Y|LAYOUT_FILL_COLUMN);
  new FXButton(fillstyle,"FILL_TILED",NULL,this,ID_FILL_TILED,BUTTON_TOOLBAR|JUSTIFY_CENTER_X|FRAME_RAISED|LAYOUT_FILL_X|LAYOUT_FILL_Y|LAYOUT_FILL_COLUMN);
  new FXButton(fillstyle,"FILL_STIPPLED",NULL,this,ID_FILL_STIPPLED,BUTTON_TOOLBAR|JUSTIFY_CENTER_X|FRAME_RAISED|LAYOUT_FILL_X|LAYOUT_FILL_Y|LAYOUT_FILL_COLUMN);
  new FXButton(fillstyle,"FILL_OPAQUESTIPPLED",NULL,this,ID_FILL_OPAQUESTIPPLED,BUTTON_TOOLBAR|JUSTIFY_CENTER_X|FRAME_RAISED|LAYOUT_FILL_X|LAYOUT_FILL_Y|LAYOUT_FILL_COLUMN);
  
  // Font
  FXHorizontalFrame *fonts=new FXHorizontalFrame(controls,FRAME_RIDGE|LAYOUT_FILL_X|PACK_UNIFORM_WIDTH, 0,0,0,0, 2,2,2,2, 0,0);
  new FXButton(fonts,"Font Dialog...\tChange the text font",NULL,this,ID_FONT,BUTTON_TOOLBAR|JUSTIFY_CENTER_X|FRAME_RAISED|LAYOUT_FILL_X|LAYOUT_FILL_Y);
  
  // Printing
  FXHorizontalFrame *printer=new FXHorizontalFrame(controls,FRAME_RIDGE|LAYOUT_FILL_X|PACK_UNIFORM_WIDTH, 0,0,0,0, 2,2,2,2, 0,0);
  new FXButton(printer,"Print Dialog...\tPrint it out",NULL,this,ID_PRINT,BUTTON_TOOLBAR|JUSTIFY_CENTER_X|FRAME_RAISED|LAYOUT_FILL_X|LAYOUT_FILL_Y);
  
  // Quit
  FXHorizontalFrame *quitter=new FXHorizontalFrame(controls,FRAME_RIDGE|LAYOUT_FILL_X|PACK_UNIFORM_WIDTH, 0,0,0,0, 2,2,2,2, 0,0);
  new FXButton(quitter,"Bye Bye!\tHasta la vista, baby!",NULL,getApp(),FXApp::ID_QUIT,BUTTON_TOOLBAR|JUSTIFY_CENTER_X|FRAME_RAISED|LAYOUT_FILL_X|LAYOUT_FILL_Y);
  
  
  // Switcher
  FXTabBook *tabbook=new FXTabBook(contents,NULL,0,LAYOUT_FILL_X|LAYOUT_FILL_Y|LAYOUT_RIGHT);
  
  // First page shows various line styles
  FXTabItem *linesTab=new FXTabItem(tabbook,"&Lines",NULL);
  FXPacker *linesPage=new FXPacker(tabbook,FRAME_THICK|FRAME_RAISED);
  

  FXHorizontalFrame* frame=new FXHorizontalFrame(linesPage,FRAME_SUNKEN|FRAME_THICK|LAYOUT_FILL_X|LAYOUT_FILL_Y,0,0,0,0, 0,0,0,0);
  linesCanvas=new FXCanvas(frame,this,ID_LINES,LAYOUT_FILL_X|LAYOUT_FILL_Y);
    
  // Second page shows different shapes
  FXTabItem *shapesTab=new FXTabItem(tabbook,"&Shapes",NULL);
  FXPacker *shapesPage=new FXPacker(tabbook,FRAME_THICK|FRAME_RAISED);
  frame=new FXHorizontalFrame(shapesPage,FRAME_SUNKEN|FRAME_THICK|LAYOUT_FILL_X|LAYOUT_FILL_Y,0,0,0,0, 0,0,0,0);
  shapesCanvas=new FXCanvas(frame,this,ID_SHAPES,LAYOUT_FILL_X|LAYOUT_FILL_Y);
  
  // Third page shows images
  FXTabItem *imagesTab=new FXTabItem(tabbook,"&Images",NULL);
  FXPacker *imagesPage=new FXPacker(tabbook,FRAME_THICK|FRAME_RAISED);
  frame=new FXHorizontalFrame(imagesPage,FRAME_SUNKEN|FRAME_THICK|LAYOUT_FILL_X|LAYOUT_FILL_Y,0,0,0,0, 0,0,0,0);
  FXCanvas *imagesCanvas=new FXCanvas(frame,this,ID_IMAGES,LAYOUT_FILL_X|LAYOUT_FILL_Y);
  birdImage=new FXGIFImage(getApp(),dippy);

  // File Menu
  FXMenuPane *filemenu=new FXMenuPane(this);
  new FXMenuCommand(filemenu,"&Print...\tCtl-P",NULL,this,ID_PRINT);
  new FXMenuCommand(filemenu,"&Font...\tCtl-F",NULL,this,ID_FONT);
  new FXMenuCommand(filemenu,"&Quit\tCtl-Q",NULL,getApp(),FXApp::ID_QUIT);
  new FXMenuTitle(menubar,"&File",NULL,filemenu);
  
  function=BLT_SRC;
  lineStyle=LINE_SOLID;
  capStyle=CAP_BUTT;
  joinStyle=JOIN_MITER;
  fillStyle=FILL_SOLID;
  fillRule=RULE_EVEN_ODD;
  stipple=STIPPLE_NONE;
  forecolor=FXRGB(255,0,0);
  backcolor=FXRGB(0,0,255);
  erasecolor=FXRGB(255,255,255);
  testFont=new FXFont(getApp(),"helvetica",20);
  }


// Start
void DCTestWindow::create(){
  FXMainWindow::create();
  birdImage->create();
  testFont->create();
  show();
  }


// Changed RasterOp function
long DCTestWindow::onCmdFunction(FXObject*,FXSelector sel,void*){
  function=(FXFunction)(BLT_CLR+SELID(sel)-ID_CLR);
  linesCanvas->update(0,0,linesCanvas->getWidth(),linesCanvas->getHeight());
  return 1;
  }

// Update RasterOp function
long DCTestWindow::onUpdFunction(FXObject* sender,FXSelector sel,void*){
  FXFunction ff=(FXFunction)(BLT_CLR+SELID(sel)-ID_CLR);
  if(ff==function)
    sender->handle(this,MKUINT(ID_CHECK,SEL_COMMAND),NULL);
  else
    sender->handle(this,MKUINT(ID_UNCHECK,SEL_COMMAND),NULL);
  return 1;
  }


// Changed Line Style
long DCTestWindow::onCmdLineStyle(FXObject*,FXSelector sel,void*){
  lineStyle=(FXLineStyle)(LINE_SOLID+SELID(sel)-ID_LINE_SOLID);
  linesCanvas->update(0,0,linesCanvas->getWidth(),linesCanvas->getHeight());
  return 1;
  }

// Update Line Style
long DCTestWindow::onUpdLineStyle(FXObject* sender,FXSelector sel,void*){
  FXLineStyle ff=(FXLineStyle)(LINE_SOLID+SELID(sel)-ID_LINE_SOLID);
  if(ff==lineStyle)
    sender->handle(this,MKUINT(ID_CHECK,SEL_COMMAND),NULL);
  else
    sender->handle(this,MKUINT(ID_UNCHECK,SEL_COMMAND),NULL);
  return 1;
  }


// Changed Cap Style
long DCTestWindow::onCmdCapStyle(FXObject*,FXSelector sel,void*){
  capStyle=(FXCapStyle)(CAP_NOT_LAST+SELID(sel)-ID_CAP_NOT_LAST);
  linesCanvas->update(0,0,linesCanvas->getWidth(),linesCanvas->getHeight());
  return 1;
  }

// Update Cap Style
long DCTestWindow::onUpdCapStyle(FXObject* sender,FXSelector sel,void*){
  FXCapStyle ff=(FXCapStyle)(CAP_NOT_LAST+SELID(sel)-ID_CAP_NOT_LAST);
  if(ff==capStyle)
    sender->handle(this,MKUINT(ID_CHECK,SEL_COMMAND),NULL);
  else
    sender->handle(this,MKUINT(ID_UNCHECK,SEL_COMMAND),NULL);
  return 1;
  }

// Changed Join Style
long DCTestWindow::onCmdJoinStyle(FXObject*,FXSelector sel,void*){
  joinStyle=(FXJoinStyle)(JOIN_MITER+SELID(sel)-ID_JOIN_MITER);
  linesCanvas->update(0,0,linesCanvas->getWidth(),linesCanvas->getHeight());
  return 1;
  }

// Update Join Style
long DCTestWindow::onUpdJoinStyle(FXObject* sender,FXSelector sel,void*){
  FXJoinStyle ff=(FXJoinStyle)(JOIN_MITER+SELID(sel)-ID_JOIN_MITER);
  if(ff==joinStyle)
    sender->handle(this,MKUINT(ID_CHECK,SEL_COMMAND),NULL);
  else
    sender->handle(this,MKUINT(ID_UNCHECK,SEL_COMMAND),NULL);
  return 1;
  }


// Erase Color
long DCTestWindow::onCmdEraseColor(FXObject*,FXSelector,void* ptr){
  erasecolor=(FXColor)(long)ptr;
  linesCanvas->update(0,0,linesCanvas->getWidth(),linesCanvas->getHeight());
  return 1;
  }

// Update Erase Color
long DCTestWindow::onUpdEraseColor(FXObject* sender,FXSelector,void*){
  sender->handle(this,MKUINT(ID_SETVALUE,SEL_COMMAND),(void*)erasecolor);
  return 1;
  }


// Foreground Color
long DCTestWindow::onCmdForeColor(FXObject*,FXSelector,void* ptr){
  forecolor=(FXColor)(long)ptr;
  linesCanvas->update(0,0,linesCanvas->getWidth(),linesCanvas->getHeight());
  return 1;
  }


// Update Foreground Color
long DCTestWindow::onUpdForeColor(FXObject* sender,FXSelector,void*){
  sender->handle(this,MKUINT(ID_SETVALUE,SEL_COMMAND),(void*)forecolor);
  return 1;
  }

// Back Color
long DCTestWindow::onCmdBackColor(FXObject*,FXSelector,void* ptr){
  backcolor=(FXColor)(long)ptr;
  linesCanvas->update(0,0,linesCanvas->getWidth(),linesCanvas->getHeight());
  return 1;
  }


// Update Back Color
long DCTestWindow::onUpdBackColor(FXObject* sender,FXSelector,void*){
  sender->handle(this,MKUINT(ID_SETVALUE,SEL_COMMAND),(void*)backcolor);
  return 1;
  }

// Change font
long DCTestWindow::onCmdFont(FXObject*,FXSelector,void*){
  FXFontDialog fontdlg(this,"Change Font",DECOR_BORDER|DECOR_TITLE);
  FXFontDesc fontdesc;
  testFont->getFontDesc(fontdesc);
  fontdlg.setFontSelection(fontdesc);
  if(fontdlg.execute()){
    fontdlg.getFontSelection(fontdesc);
    delete testFont;
    testFont=new FXFont(getApp(),fontdesc);
    testFont->create();
    linesCanvas->update(0,0,linesCanvas->getWidth(),linesCanvas->getHeight());
    }
  return 1;
  }


// User changes the line width
long DCTestWindow::onLineWidth(FXObject*,FXSelector,void*){
  linesCanvas->update(0,0,linesCanvas->getWidth(),linesCanvas->getHeight());
  return 1;
  }


// Change stipple
long DCTestWindow::onCmdStipple(FXObject*,FXSelector sel,void*){
  stipple=(FXStipplePattern)(STIPPLE_NONE+SELID(sel)-ID_STIPPLE_0);
  linesCanvas->update(0,0,linesCanvas->getWidth(),linesCanvas->getHeight());
  return 1;
  }


// Changed Fill Style
long DCTestWindow::onCmdFillStyle(FXObject*,FXSelector sel,void*){
  fillStyle=(FXFillStyle)(FILL_SOLID+SELID(sel)-ID_FILL_SOLID);
  linesCanvas->update(0,0,linesCanvas->getWidth(),linesCanvas->getHeight());
  return 1;
  }

// Update Fill Style
long DCTestWindow::onUpdFillStyle(FXObject* sender,FXSelector sel,void*){
  FXFillStyle ff=(FXFillStyle)(FILL_SOLID+SELID(sel)-ID_FILL_SOLID);
  if(ff==fillStyle)
    sender->handle(this,MKUINT(ID_CHECK,SEL_COMMAND),NULL);
  else
    sender->handle(this,MKUINT(ID_UNCHECK,SEL_COMMAND),NULL);
  return 1;
  }



// Repaint the lines page
long DCTestWindow::onPaintLines(FXObject *sender,FXSelector,void *ptr){
  FXCanvas *canvas=(FXCanvas*) sender;
  FXEvent *ev=(FXEvent*)ptr;
  FXDCWindow dc(canvas,ev);
  drawPage(dc,canvas->getWidth(),canvas->getHeight());
  /*
  FXint w=canvas->getWidth();
  FXint h=canvas->getHeight();
  
  dc.setForeground(erasecolor);
  dc.fillRectangle(0,0,w,h);
  
  dc.setForeground(forecolor);
  dc.setBackground(backcolor);
  
  dc.setLineStyle(lineStyle);
  dc.setLineCap(capStyle);
  dc.setLineJoin(joinStyle);
  dc.setFunction(function);
  
  dc.setStipple(stipple);
  dc.setFillStyle(fillStyle);
  dc.setLineWidth(lineWidthSpinner->getValue());

  // Here's a single line
  dc.drawLine(10,h/4,w-10,h/4);

  // Here are some connected lines (to show join styles)
  FXPoint points[6];
  points[0].x=10; points[0].y=3*h/4;
  points[1].x=points[0].x+w/6; points[1].y=h/2;
  points[2].x=points[1].x+w/6; points[2].y=points[0].y;
  points[3].x=points[2].x+w/6; points[3].y=points[1].y;
  points[4].x=points[3].x+w/6; points[4].y=points[0].y;
  points[5].x=points[4].x+w/6; points[5].y=points[1].y;
  dc.drawLines(points,6);
  
  FXString string="Font: "+testFont->getName()+"  Size: "+FXStringVal(testFont->getSize()/10);
  dc.setTextFont(testFont);
  dc.setForeground(forecolor);
  dc.setBackground(backcolor);
  dc.drawText(30,h-100,string.text(),string.length());
  dc.drawImageText(30,h-50,string.text(),string.length());

  dc.setForeground(forecolor);
  dc.setBackground(backcolor);
  dc.drawRectangle(10,10,200,100);
  dc.fillRectangle(300,10,200,100);
  
  dc.drawArc(10,120,100,100,0,64*270);
  dc.fillArc(300,120,100,100,64*45,64*90);
  */
  return 1;
  }


// Repaint the shapes page
long DCTestWindow::onPaintShapes(FXObject *sender,FXSelector,void *ptr){
  FXCanvas *canvas=(FXCanvas*)sender;
  FXEvent *ev=(FXEvent*)ptr;
  FXDCWindow dc(canvas,ev);
  dc.setForeground(eraseWell->getRGBA());
  dc.fillRectangle(0,0,canvas->getWidth(),canvas->getHeight());
  
  dc.setForeground(foreWell->getRGBA());
  dc.setBackground(backWell->getRGBA());
  dc.drawRectangle(5,5,50,50);
  dc.fillRectangle(60,5,50,50);

  dc.setForeground(foreWell->getRGBA());
  dc.setBackground(backWell->getRGBA());
  dc.drawArc(5,60,50,50,0,64*90);
  dc.fillArc(60,60,50,50,64*90,64*180);

  return 1;
  }


// Repaint the images page
long DCTestWindow::onPaintImages(FXObject *sender,FXSelector,void *ptr){
  FXCanvas *canvas=(FXCanvas*)sender;
  FXEvent *ev=(FXEvent*)ptr;
  FXDCWindow dc(canvas,ev);
  dc.setForeground(canvas->getBackColor());
  dc.fillRectangle(0,0,canvas->getWidth(),canvas->getHeight());
  dc.drawImage(birdImage,0,0);
  return 1;
  }


// This is the WYSIWYG routine, it takes a DC and renders 
// into it; it does not know if the DC is a printer or screen.
void DCTestWindow::drawPage(FXDC& dc,FXint w,FXint h){
  
  dc.setForeground(erasecolor);
  dc.fillRectangle(0,0,w,h);
  
  dc.setForeground(forecolor);
  dc.setBackground(backcolor);
  
  dc.setLineStyle(lineStyle);
  dc.setLineCap(capStyle);
  dc.setLineJoin(joinStyle);
  dc.setFunction(function);
  
  dc.setStipple(stipple);
  dc.setFillStyle(fillStyle);
  dc.setLineWidth(lineWidthSpinner->getValue());

  // Here's a single line
  dc.drawLine(20,200,w-20,200);

  // Here are some connected lines (to show join styles)
  FXPoint points[6];
  points[0].x=10; points[0].y=3*h/4;
  points[1].x=points[0].x+w/6; points[1].y=h/2;
  points[2].x=points[1].x+w/6; points[2].y=points[0].y;
  points[3].x=points[2].x+w/6; points[3].y=points[1].y;
  points[4].x=points[3].x+w/6; points[4].y=points[0].y;
  points[5].x=points[4].x+w/6; points[5].y=points[1].y;
  dc.drawLines(points,6);
  
  FXString string="Font: "+testFont->getName()+"  Size: "+FXStringVal(testFont->getSize()/10);
  dc.setTextFont(testFont);
  dc.setForeground(forecolor);
  dc.setBackground(backcolor);
  dc.drawText(30,h-100,string.text(),string.length());
  dc.drawImageText(30,h-50,string.text(),string.length());

  dc.setForeground(forecolor);
  dc.setBackground(backcolor);
  dc.drawRectangle(20,20,200,100);
  dc.fillRectangle(300,20,200,100);
  
  dc.drawArc(20,120,100,100,0,64*270);
  dc.fillArc(300,120,100,100,64*45,64*90);
  
  // Draw a pale blue dot :-)
  dc.setForeground(FXRGB(128,128,255));
  dc.drawPoint(w-20,h-20);
  }


// Print the text
long DCTestWindow::onCmdPrint(FXObject* sender,FXSelector sel,void* ptr){
  FXPrintDialog dlg(this,"Print Graphics");
  FXPrinter printer;
  if(dlg.execute()){
    dlg.getPrinter(printer);
    FXTRACE((100,"Printer = %s\n",printer.name));
    FXDCPrint pdc(getApp());
    if(!pdc.beginPrint(printer)){
      FXMessageBox::error(this,MBOX_OK,"Printer Error","Unable to print");
      return 1;
      }
    pdc.beginPage(1);
    drawPage(pdc,500,500);
    pdc.endPage();
    pdc.endPrint();
    }
  return 1;
  }

/*******************************************************************************/


// Start the whole thing
int main(int argc,char *argv[]){

  // Make application
  FXApp* application=new FXApp("DCTest","Test");
  
  // Open display
  application->init(argc,argv);
  
  // Make the main window
  new DCTestWindow(application);

  // Create app
  application->create();
  
  // Go
  application->run();

  return 0;
  }


