/********************************************************************************
*                                                                               *
*                      S w i t c h   P a n e l   C l a s s                      *
*                                                                               *
*********************************************************************************
* Copyright (C) 1997 by Jeroen van der Zijp.   All Rights Reserved.             *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Library General Public                   *
* License as published by the Free Software Foundation; either                  *
* version 2 of the License, or (at your option) any later version.              *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Library General Public License for more details.                              *
*                                                                               *
* You should have received a copy of the GNU Library General Public             *
* License along with this library; if not, write to the Free                    *
* Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
*********************************************************************************
* $Id: FXSwitcher.cpp,v 1.2 1999/10/29 07:58:39 jeroen Exp $                    *
********************************************************************************/
#include "fxdefs.h"
#include "FXStream.h"
#include "FXString.h"
#include "FXObject.h"
#include "FXDict.h"
#include "FXRegistry.h"
#include "FXAccelTable.h"
#include "FXApp.h"
#include "FXId.h"
#include "FXDC.h"
#include "FXDCWindow.h"
#include "FXDrawable.h"
#include "FXWindow.h"
#include "FXFrame.h"
#include "FXComposite.h"
#include "FXPacker.h"
#include "FXSwitcher.h"


/*
  Notes:
  - Found out stacking order changes are very expensive, so just
    hiding all but the current pane now. 
  - Also, only the current pane needs to be moved to the correct
    position; when changing active panes, only then will the pane
    be moved; this is a lot faster if there are many stacked panes!
*/

/*******************************************************************************/

// Map
FXDEFMAP(FXSwitcher) FXSwitcherMap[]={
  FXMAPFUNC(SEL_PAINT,0,FXSwitcher::onPaint),
  FXMAPFUNCS(SEL_UPDATE,FXSwitcher::ID_OPEN_FIRST,FXSwitcher::ID_OPEN_LAST,FXSwitcher::onUpdOpen),
  FXMAPFUNC(SEL_COMMAND,FXWindow::ID_SETVALUE,FXSwitcher::onCmdSetValue),
  FXMAPFUNC(SEL_COMMAND,FXWindow::ID_SETINTVALUE,FXSwitcher::onCmdSetIntValue),
  FXMAPFUNC(SEL_COMMAND,FXWindow::ID_GETINTVALUE,FXSwitcher::onCmdGetIntValue),
  FXMAPFUNCS(SEL_COMMAND,FXSwitcher::ID_OPEN_FIRST,FXSwitcher::ID_OPEN_LAST,FXSwitcher::onCmdOpen),
  };


// Object implementation
FXIMPLEMENT(FXSwitcher,FXPacker,FXSwitcherMap,ARRAYNUMBER(FXSwitcherMap))



// Make a switcher window
FXSwitcher::FXSwitcher(FXComposite *p,FXuint opts,FXint x,FXint y,FXint w,FXint h,FXint pl,FXint pr,FXint pt,FXint pb):
  FXPacker(p,opts,x,y,w,h,pl,pr,pt,pb,0,0){
  current=0;
  }


// Handle repaint 
long FXSwitcher::onPaint(FXObject*,FXSelector,void* ptr){
  FXEvent *ev=(FXEvent*)ptr;
  FXDCWindow dc(this,ev);
  dc.setForeground(backColor);
  dc.fillRectangle(ev->rect.x,ev->rect.y,ev->rect.w,ev->rect.h);
  drawFrame(dc,0,0,width,height);
  return 1;
  }


// Update value from a message
long FXSwitcher::onCmdSetValue(FXObject*,FXSelector,void* ptr){
  setCurrent((FXint)(long)ptr);
  return 1;
  }


// Update value from a message
long FXSwitcher::onCmdSetIntValue(FXObject*,FXSelector,void* ptr){
  if(ptr==NULL){ fxerror("%s::onCmdSetIntValue: NULL pointer.\n",getClassName()); }
  setCurrent(*((FXint*)ptr));
  return 1;
  }

// Obtain value from text field
long FXSwitcher::onCmdGetIntValue(FXObject*,FXSelector,void* ptr){
  if(ptr==NULL){ fxerror("%s::onCmdGetIntValue: NULL pointer.\n",getClassName()); }
  *((FXint*)ptr)=current;
  return 1;
  }


// Bring nth to the top
long FXSwitcher::onCmdOpen(FXObject*,FXSelector sel,void*){
  setCurrent(SELID(sel)-ID_OPEN_FIRST);
  return 1;
  }


// Update the nth button
long FXSwitcher::onUpdOpen(FXObject* sender,FXSelector sel,void* ptr){
  FXuint msg=((SELID(sel)-ID_OPEN_FIRST)==(FXuint)current) ? ID_CHECK : ID_UNCHECK;
  sender->handle(this,MKUINT(msg,SEL_COMMAND),ptr);
  return 1;
  }


// Get maximum child width
FXint FXSwitcher::getDefaultWidth(){
  register FXWindow* child;
  register int t,m;
  for(m=0,child=getFirst(); child; child=child->getNext()){
    if(m<(t=child->getDefaultWidth())) m=t;
    }
  return padleft+padright+(border<<1)+m;
  }


// Get maximum child height
FXint FXSwitcher::getDefaultHeight(){
  register FXWindow* child;
  register int t,m;
  for(m=0,child=getFirst(); child; child=child->getNext()){
    if(m<(t=child->getDefaultHeight())) m=t;
    }
  return padtop+padbottom+(border<<1)+m;
  }


// Recalculate layout
void FXSwitcher::layout(){
  register FXWindow *child;
  register FXint i,x,y,w,h;
  x=border+padleft;
  y=border+padtop;
  w=width-padright-padleft-(border<<1);
  h=height-padtop-padbottom-(border<<1);
  for(i=0,child=getFirst(); child; child=child->getNext(),i++){
    if(i==current){
      child->position(x,y,w,h);
      child->show(); 
      }
    else{
      child->hide();
      }
    }
  flags&=~FLAG_DIRTY;
  }


// Set current subwindow
void FXSwitcher::setCurrent(FXint panel){
  if(0<=panel && current!=panel){
    current=panel;
    recalc();
    }
  }


// Save object to stream
void FXSwitcher::save(FXStream& store) const {
  FXPacker::save(store);
  store << current;
  }


// Load object from stream
void FXSwitcher::load(FXStream& store){
  FXPacker::load(store);
  store >> current;
  }  
