/********************************************************************************
*                                                                               *
*                         M e s s a g e   B o x e s                             *
*                                                                               *
*********************************************************************************
* Copyright (C) 1997 by Jeroen van der Zijp.   All Rights Reserved.             *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Library General Public                   *
* License as published by the Free Software Foundation; either                  *
* version 2 of the License, or (at your option) any later version.              *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Library General Public License for more details.                              *
*                                                                               *
* You should have received a copy of the GNU Library General Public             *
* License along with this library; if not, write to the Free                    *
* Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
*********************************************************************************
* $Id: FXMessageBox.cpp,v 1.3 1999/11/12 07:59:17 jeroen Exp $                  *
********************************************************************************/
#include "xincs.h"
#include "fxdefs.h"
#include "FXStream.h"
#include "FXString.h"
#include "FXObject.h"
#include "FXDict.h"
#include "FXRegistry.h"
#include "FXAccelTable.h"
#include "FXApp.h"
#include "FXId.h"
#include "FXDrawable.h"
#include "FXImage.h"
#include "FXIcon.h"
#include "FXGIFIcon.h"
#include "FXWindow.h"
#include "FXFrame.h"
#include "FXSeparator.h"
#include "FXLabel.h"
#include "FXButton.h"
#include "FXComposite.h"
#include "FXPacker.h"
#include "FXHorizontalFrame.h"
#include "FXVerticalFrame.h"
#include "FXShell.h"
#include "FXTopWindow.h"
#include "FXDialogBox.h"
#include "FXMessageBox.h"


/*
  Notes:
  - Want justify modes for the message box so the label can be aligned 
    different ways.
*/

// Padding for message box buttons
#define HORZ_PAD 30
#define VERT_PAD 2

#define MBOX_BUTTON_MASK   (MBOX_OK|MBOX_OK_CANCEL|MBOX_YES_NO|MBOX_YES_NO_CANCEL|MBOX_QUIT_CANCEL|MBOX_QUIT_SAVE_CANCEL)

/*******************************************************************************/

// Map
FXDEFMAP(FXMessageBox) FXMessageBoxMap[]={
  FXMAPFUNCS(SEL_COMMAND,FXMessageBox::ID_CLICKED_YES,FXMessageBox::ID_CLICKED_SAVE,FXMessageBox::onCmdClicked),
  };



// Object implementation
FXIMPLEMENT(FXMessageBox,FXDialogBox,FXMessageBoxMap,ARRAYNUMBER(FXMessageBoxMap))

  
  
// Create message box
FXMessageBox::FXMessageBox(FXWindow* owner,const FXString& caption,const FXString& text,FXIcon* ic,FXuint opts,FXint x,FXint y):
  FXDialogBox(owner,caption,opts|DECOR_TITLE|DECOR_BORDER,x,y,0,0){
  FXuint whichbuttons=opts&MBOX_BUTTON_MASK;
  FXVerticalFrame* content=new FXVerticalFrame(this,LAYOUT_FILL_X|LAYOUT_FILL_Y);
  FXHorizontalFrame* info=new FXHorizontalFrame(content,LAYOUT_TOP|LAYOUT_LEFT|LAYOUT_FILL_X|LAYOUT_FILL_Y,0,0,0,0,10,10,10,10);
  new FXLabel(info,NULL,ic,ICON_BEFORE_TEXT|LAYOUT_TOP|LAYOUT_LEFT|LAYOUT_FILL_X|LAYOUT_FILL_Y);
  new FXLabel(info,text,NULL,JUSTIFY_LEFT|ICON_BEFORE_TEXT|LAYOUT_TOP|LAYOUT_LEFT|LAYOUT_FILL_X|LAYOUT_FILL_Y);
  new FXHorizontalSeparator(content,SEPARATOR_GROOVE|LAYOUT_TOP|LAYOUT_LEFT|LAYOUT_FILL_X);
  FXHorizontalFrame* buttons=new FXHorizontalFrame(content,LAYOUT_TOP|LAYOUT_LEFT|LAYOUT_FILL_X|PACK_UNIFORM_WIDTH,0,0,0,0,10,10,10,10);
  if(whichbuttons==MBOX_OK){
    new FXButton(buttons,"&OK",NULL,this,ID_CLICKED_OK,BUTTON_DEFAULT|FRAME_RAISED|FRAME_THICK|LAYOUT_TOP|LAYOUT_LEFT|LAYOUT_CENTER_X,0,0,0,0,HORZ_PAD,HORZ_PAD,VERT_PAD,VERT_PAD);
    }
  else if(whichbuttons==MBOX_OK_CANCEL){
    new FXButton(buttons,"&OK",NULL,this,ID_CLICKED_OK,BUTTON_DEFAULT|FRAME_RAISED|FRAME_THICK|LAYOUT_TOP|LAYOUT_LEFT|LAYOUT_CENTER_X,0,0,0,0,HORZ_PAD,HORZ_PAD,VERT_PAD,VERT_PAD);
    new FXButton(buttons,"&Cancel",NULL,this,ID_CLICKED_CANCEL,FRAME_RAISED|FRAME_THICK|LAYOUT_TOP|LAYOUT_LEFT|LAYOUT_CENTER_X,0,0,0,0,HORZ_PAD,HORZ_PAD,VERT_PAD,VERT_PAD);
    }
  else if(whichbuttons==MBOX_YES_NO){
    new FXButton(buttons,"&Yes",NULL,this,ID_CLICKED_YES,BUTTON_DEFAULT|FRAME_RAISED|FRAME_THICK|LAYOUT_TOP|LAYOUT_LEFT|LAYOUT_CENTER_X,0,0,0,0,HORZ_PAD,HORZ_PAD,VERT_PAD,VERT_PAD);
    new FXButton(buttons,"&No",NULL,this,ID_CLICKED_NO,FRAME_RAISED|FRAME_THICK|LAYOUT_TOP|LAYOUT_LEFT|LAYOUT_CENTER_X,0,0,0,0,HORZ_PAD,HORZ_PAD,VERT_PAD,VERT_PAD);
    }
  else if(whichbuttons==MBOX_YES_NO_CANCEL){
    new FXButton(buttons,"&Yes",NULL,this,ID_CLICKED_YES,BUTTON_DEFAULT|FRAME_RAISED|FRAME_THICK|LAYOUT_TOP|LAYOUT_LEFT|LAYOUT_CENTER_X,0,0,0,0,HORZ_PAD,HORZ_PAD,VERT_PAD,VERT_PAD);
    new FXButton(buttons,"&No",NULL,this,ID_CLICKED_NO,FRAME_RAISED|FRAME_THICK|LAYOUT_TOP|LAYOUT_LEFT|LAYOUT_CENTER_X,0,0,0,0,HORZ_PAD,HORZ_PAD,VERT_PAD,VERT_PAD);
    new FXButton(buttons,"&Cancel",NULL,this,ID_CLICKED_CANCEL,FRAME_RAISED|FRAME_THICK|LAYOUT_TOP|LAYOUT_LEFT|LAYOUT_CENTER_X,0,0,0,0,HORZ_PAD,HORZ_PAD,VERT_PAD,VERT_PAD);
    }
  else if(whichbuttons==MBOX_QUIT_CANCEL){
    new FXButton(buttons,"&Quit",NULL,this,ID_CLICKED_QUIT,BUTTON_DEFAULT|FRAME_RAISED|FRAME_THICK|LAYOUT_TOP|LAYOUT_LEFT|LAYOUT_CENTER_X,0,0,0,0,HORZ_PAD,HORZ_PAD,VERT_PAD,VERT_PAD);
    new FXButton(buttons,"&Cancel",NULL,this,ID_CLICKED_CANCEL,FRAME_RAISED|FRAME_THICK|LAYOUT_TOP|LAYOUT_LEFT|LAYOUT_CENTER_X,0,0,0,0,HORZ_PAD,HORZ_PAD,VERT_PAD,VERT_PAD);
    }
  else if(whichbuttons==MBOX_QUIT_SAVE_CANCEL){
    new FXButton(buttons,"&Quit",NULL,this,ID_CLICKED_QUIT,BUTTON_DEFAULT|FRAME_RAISED|FRAME_THICK|LAYOUT_TOP|LAYOUT_LEFT|LAYOUT_CENTER_X,0,0,0,0,HORZ_PAD,HORZ_PAD,VERT_PAD,VERT_PAD);
    new FXButton(buttons,"&Save",NULL,this,ID_CLICKED_SAVE,FRAME_RAISED|FRAME_THICK|LAYOUT_TOP|LAYOUT_LEFT|LAYOUT_CENTER_X,0,0,0,0,HORZ_PAD,HORZ_PAD,VERT_PAD,VERT_PAD);
    new FXButton(buttons,"&Cancel",NULL,this,ID_CLICKED_CANCEL,FRAME_RAISED|FRAME_THICK|LAYOUT_TOP|LAYOUT_LEFT|LAYOUT_CENTER_X,0,0,0,0,HORZ_PAD,HORZ_PAD,VERT_PAD,VERT_PAD);
    }
  }


// Close dialog with a cancel
long FXMessageBox::onCmdClicked(FXObject*,FXSelector sel,void*){
  getApp()->stopModal(this,MBOX_CLICKED_YES+(SELID(sel)-ID_CLICKED_YES));
  hide();
  return 1;
  }


/*******************************************************************************/

// Show a modal error message
FXuint FXMessageBox::error(FXWindow* owner,FXuint opts,const char* caption,const char* message,...){
  const unsigned char errorIcon[]={
    0x47,0x49,0x46,0x38,0x37,0x61,0x20,0x00,0x20,0x00,0xf1,0x00,0x00,0x80,0x80,0x80,
    0x80,0x00,0x00,0xff,0x00,0x00,0xff,0xff,0xff,0x2c,0x00,0x00,0x00,0x00,0x20,0x00,
    0x20,0x00,0x00,0x02,0x91,0x84,0x8f,0x10,0xcb,0x9b,0x0f,0x0f,0x13,0xb4,0x52,0x16,
    0x73,0xb0,0x9c,0x87,0x9c,0x2c,0xdd,0x58,0x39,0xe0,0x46,0xa6,0x97,0xa6,0xb6,0xc2,
    0x07,0xa1,0x2e,0x09,0x87,0xdd,0xa0,0xe2,0x9e,0xcd,0x0d,0x3e,0xe9,0xd3,0x59,0x6a,
    0x8a,0x5e,0x50,0x58,0x39,0x22,0x5f,0x08,0x59,0xf2,0x68,0x51,0x76,0x6a,0xce,0x28,
    0x54,0x20,0x1d,0xc1,0xaa,0x56,0x65,0x30,0xb5,0xcd,0x79,0x97,0xbb,0xa2,0xf8,0x0a,
    0x36,0x70,0x8d,0x68,0x9a,0xfa,0x9c,0x75,0x9b,0x47,0xe3,0xaf,0x7c,0x8d,0xbd,0xc6,
    0xcb,0xf3,0xa7,0x9d,0xb2,0xb7,0x22,0xc1,0xf6,0x43,0xb8,0x44,0xc4,0xf5,0xc7,0x36,
    0xc5,0x13,0x95,0xc3,0xf8,0x80,0x37,0xc3,0x14,0x33,0x29,0x57,0x69,0x39,0x04,0xa2,
    0x20,0xa9,0x45,0x74,0x32,0xf9,0xb9,0xc9,0x89,0x87,0x31,0x1a,0xd1,0xd0,0x70,0xba,
    0xca,0xda,0xea,0x6a,0x50,0x00,0x00,0x3b
    };
  FXGIFIcon icon(owner->getApp(),errorIcon);
  va_list arguments;
  FXchar buf[1000];
  va_start(arguments,message);
#ifdef _GNU_SOURCE
  vsnprintf(buf,sizeof(buf),message,arguments);
#else
  vsprintf(buf,message,arguments);
#endif
  va_end(arguments);
  FXMessageBox box(owner,caption,buf,&icon,opts|DECOR_TITLE|DECOR_BORDER);
  return box.execute();
  }


// Show a modal warning message
FXuint FXMessageBox::warning(FXWindow* owner,FXuint opts,const char* caption,const char* message,...){
  const unsigned char warningIcon[]={
    0x47,0x49,0x46,0x38,0x37,0x61,0x20,0x00,0x20,0x00,0xf2,0x00,0x00,0x80,0x80,0x80,
    0x80,0x80,0x00,0xff,0xff,0x00,0xc0,0xc0,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x2c,0x00,0x00,0x00,0x00,0x20,0x00,0x20,0x00,0x00,0x03,
    0x8f,0x08,0xba,0xbc,0xf1,0x2d,0xca,0xa9,0x82,0x10,0x83,0xd0,0x2d,0xed,0xc5,0x1a,
    0x27,0x02,0xde,0x17,0x8e,0x54,0xf9,0x65,0x68,0xfa,0xbd,0x67,0xcb,0xa8,0x2f,0x2b,
    0xcf,0x6f,0x1e,0xcb,0x74,0x6e,0xdf,0xa5,0x0c,0x81,0x30,0x30,0xdd,0x48,0xb0,0xe1,
    0x70,0xb5,0x13,0xa9,0x94,0x4b,0x63,0x8b,0x06,0x25,0xd4,0x9a,0xae,0xa4,0x52,0x87,
    0xea,0x55,0x7d,0xd8,0x48,0x2f,0xa0,0xf4,0x3a,0x73,0x17,0x21,0x11,0xfd,0x9b,0xf4,
    0x2e,0x5b,0xb4,0x20,0x5c,0x91,0x5f,0xc8,0x6f,0x50,0x56,0x9e,0x29,0xda,0xc3,0x79,
    0x26,0x76,0x69,0x58,0x81,0x83,0x5c,0x0d,0x86,0x20,0x6b,0x76,0x6d,0x48,0x87,0x50,
    0x90,0x38,0x87,0x73,0x71,0x8d,0x27,0x8a,0x8b,0x7e,0x83,0x98,0x94,0x9e,0x30,0x0e,
    0x9f,0x9f,0x6d,0x99,0x9e,0x8e,0x24,0x55,0xa9,0xaa,0xa9,0x47,0xad,0xae,0x22,0x09,
    0x00,0x3b
    };
  FXGIFIcon icon(owner->getApp(),warningIcon);
  va_list arguments;
  FXchar buf[1000];
  va_start(arguments,message);
#ifdef _GNU_SOURCE
  vsnprintf(buf,sizeof(buf),message,arguments);
#else
  vsprintf(buf,message,arguments);
#endif
  va_end(arguments);
  FXMessageBox box(owner,caption,buf,&icon,opts|DECOR_TITLE|DECOR_BORDER);
  return box.execute();
  }


// Show a modal question dialog
FXuint FXMessageBox::question(FXWindow* owner,FXuint opts,const char* caption,const char* message,...){
  const unsigned char questionIcon[]={
    0x47,0x49,0x46,0x38,0x37,0x61,0x20,0x00,0x20,0x00,0xf2,0x00,0x00,0x80,0x80,0x80,
    0xc0,0xc0,0xc0,0xff,0xff,0xff,0x00,0x00,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x2c,0x00,0x00,0x00,0x00,0x20,0x00,0x20,0x00,0x00,0x03,
    0x97,0x08,0xba,0xdc,0xfe,0xf0,0x05,0x41,0x6b,0x88,0x58,0xcd,0xca,0xf9,0xcd,0xcc,
    0xd6,0x8d,0x16,0x08,0x90,0x02,0x30,0x0c,0x80,0xc8,0x11,0x18,0x19,0xac,0xf4,0xe0,
    0x56,0xf0,0x23,0xdb,0x54,0x7d,0x53,0xb9,0x10,0x69,0xc5,0xa9,0xc9,0x82,0x0a,0x94,
    0x51,0xb0,0x1c,0x21,0x7f,0x3d,0x9a,0x60,0x26,0x3d,0x2e,0x50,0xd3,0xd5,0xa4,0x49,
    0x0a,0x62,0x3d,0x55,0xac,0xf7,0x1b,0x1d,0x90,0x05,0x63,0xb2,0xf6,0x9c,0xfe,0x12,
    0xd9,0x0b,0xe8,0xd9,0x7a,0xfd,0x52,0xe5,0xb8,0x06,0x9e,0x19,0xa6,0x33,0xdc,0x7d,
    0x4e,0x0f,0x04,0x58,0x77,0x62,0x11,0x84,0x73,0x82,0x18,0x04,0x7b,0x23,0x01,0x48,
    0x88,0x8d,0x67,0x90,0x91,0x19,0x04,0x98,0x3f,0x95,0x96,0x26,0x0a,0x98,0x93,0x40,
    0x9d,0x26,0x89,0x68,0xa2,0x20,0xa4,0x9c,0xa6,0x0d,0x89,0xa9,0xaa,0x0c,0x84,0xad,
    0xae,0x0b,0x98,0xb2,0xb5,0xb6,0xaa,0x09,0x00,0x3b
    };
  FXGIFIcon icon(owner->getApp(),questionIcon);
  va_list arguments;
  FXchar buf[1000];
  va_start(arguments,message);
#ifdef _GNU_SOURCE
  vsnprintf(buf,sizeof(buf),message,arguments);
#else
  vsprintf(buf,message,arguments);
#endif
  va_end(arguments);
  FXMessageBox box(owner,caption,buf,&icon,opts|DECOR_TITLE|DECOR_BORDER);
  return box.execute();
  }


// Show a modal information dialog
FXuint FXMessageBox::information(FXWindow* owner,FXuint opts,const char* caption,const char* message,...){
  const unsigned char infoIcon[]={
    0x47,0x49,0x46,0x38,0x37,0x61,0x20,0x00,0x20,0x00,0xf2,0x00,0x00,0x80,0x80,0x80,
    0xc0,0xc0,0xc0,0xff,0xff,0xff,0x00,0x00,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x2c,0x00,0x00,0x00,0x00,0x20,0x00,0x20,0x00,0x00,0x03,
    0x8c,0x08,0xba,0xdc,0xfe,0xf0,0x05,0x41,0x6b,0x88,0x58,0xcd,0xca,0xf9,0xcd,0xcc,
    0xd6,0x8d,0x16,0x08,0x90,0xc1,0xa0,0x0e,0x22,0x47,0x60,0xa4,0xb0,0xae,0xf1,0xfb,
    0xc4,0xf2,0x3c,0xe0,0x76,0x88,0xa7,0xab,0x56,0x27,0xd0,0x53,0xe0,0x8e,0xa4,0xa2,
    0x10,0x79,0x24,0x2e,0x8e,0x3a,0x15,0xb2,0xc7,0xd4,0x4d,0x9f,0x48,0xeb,0x91,0x9a,
    0x9d,0x5d,0x8d,0x5d,0xda,0x76,0xb1,0xec,0x68,0x63,0x4e,0x2c,0xee,0x9c,0x6c,0x94,
    0x2b,0xec,0x61,0x11,0x3c,0x8a,0x8a,0x3b,0x73,0x05,0x81,0x39,0x86,0xec,0xf9,0x23,
    0x79,0x0d,0x04,0x6f,0x68,0x82,0x0e,0x04,0x84,0x4c,0x44,0x87,0x7e,0x89,0x4b,0x8c,
    0x8d,0x20,0x89,0x8a,0x14,0x92,0x26,0x0c,0x7f,0x02,0x97,0x98,0x7a,0x15,0x9c,0x9d,
    0x00,0x7f,0xa0,0xa1,0x7b,0xa4,0xa5,0xa7,0xa1,0xaa,0xab,0x19,0x09,0x00,0x3b
    };
  FXGIFIcon icon(owner->getApp(),infoIcon);
  va_list arguments;
  FXchar buf[1000];
  va_start(arguments,message);
#ifdef _GNU_SOURCE
  vsnprintf(buf,sizeof(buf),message,arguments);
#else
  vsprintf(buf,message,arguments);
#endif
  va_end(arguments);
  FXMessageBox box(owner,caption,buf,&icon,opts|DECOR_TITLE|DECOR_BORDER);
  return box.execute();
  }

