/********************************************************************************
*                                                                               *
*                               I c o n - O b j e c t                           *
*                                                                               *
*********************************************************************************
* Copyright (C) 1997 by Jeroen van der Zijp.   All Rights Reserved.             *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Library General Public                   *
* License as published by the Free Software Foundation; either                  *
* version 2 of the License, or (at your option) any later version.              *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Library General Public License for more details.                              *
*                                                                               *
* You should have received a copy of the GNU Library General Public             *
* License along with this library; if not, write to the Free                    *
* Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
*********************************************************************************
* $Id: FXIcon.cpp,v 1.4 1999/11/04 20:46:38 jeroen Exp $                        *
********************************************************************************/
#include "xincs.h"
#include "fxdefs.h"
#include "FXStream.h"
#include "FXString.h"
#include "FXObject.h"
#include "FXDict.h"
#include "FXRegistry.h"
#include "FXApp.h"
#include "FXId.h"
#include "FXVisual.h"
#include "FXDrawable.h"
#include "FXImage.h"
#include "FXIcon.h"


/*
  Notes:
  - Debug the render function between different hosts.
  - Bug: icons with no transparency
  - Option to guess alpha color from corners.
*/

/*******************************************************************************/

// Object implementation
FXIMPLEMENT(FXIcon,FXImage,NULL,0)


// Initialize nicely
FXIcon::FXIcon(FXApp* a,const void *pix,FXColor clr,FXuint opts,FXint w,FXint h):
  FXImage(a,pix,opts,w,h){
  FXTRACE((100,"FXIcon::FXIcon %08x\n",this));
  shape=0;
  transp=clr;
  }


// Guess alpha color based on corners; the initial guess is standard GUI color
FXColor FXIcon::guesstransp(){
  register FXint tr,bl,br,best,t;
  register FXColor guess=FXRGB(192,192,192);
  FXColor color[4];
  if(data && 0<width && 0<height){
    best=-1;
    if(options&IMAGE_ALPHA){
      tr=4*(width-1); bl=4*width*(height-1); br=bl+tr;
      }
    else{
      tr=3*(width-1); bl=3*width*(height-1); br=bl+tr;
      }
    color[0]=FXRGB(data[0],data[1],data[2]);
    color[1]=FXRGB(data[tr],data[tr+1],data[tr+2]);
    color[2]=FXRGB(data[bl],data[bl+1],data[bl+2]);
    color[3]=FXRGB(data[br],data[br+1],data[br+2]);
    if((t=((color[0]==color[1])+(color[0]==color[2])+(color[0]==color[3])))>best){ guess=color[0]; best=t; }
    if((t=((color[1]==color[2])+(color[1]==color[3])+(color[1]==color[0])))>best){ guess=color[1]; best=t; }
    if((t=((color[2]==color[3])+(color[2]==color[0])+(color[2]==color[1])))>best){ guess=color[2]; best=t; }
    if((t=((color[3]==color[0])+(color[3]==color[1])+(color[3]==color[2])))>best){ guess=color[3]; }
    }
  return guess;
  }


// Create icon
void FXIcon::create(){
  if(!xid){
    FXTRACE((100,"%s::create %08x\n",getClassName(),this));
    
#ifndef FX_NATIVE_WIN32
    
    // App should exist
    if(!getApp()->display){ fxerror("%s::create: trying to create image before opening display.\n",getClassName()); }
  
    // Get depth (should use visual!!)
    int dd=DefaultDepth(getApp()->display,DefaultScreen(getApp()->display));
    
    // Make image pixmap
    xid=XCreatePixmap(getApp()->display,XDefaultRootWindow(getApp()->display),width,height,dd);
    if(!xid){ fxerror("%s::create: unable to create icon.\n",getClassName()); }

    // Make shape pixmap
    shape=XCreatePixmap(getApp()->display,XDefaultRootWindow(getApp()->display),width,height,1);
    if(!shape){ fxerror("%s::create: unable to create icon.\n",getClassName()); }

#else

    // Create a memory DC compatible with current display
    HDC hdc=::GetDC(GetDesktopWindow());
    hdcmem=CreateCompatibleDC(hdc);
    if(!hdcmem){ fxerror("%s::create: unable to create image.\n",getClassName()); }
    xid=CreateCompatibleBitmap(hdc,width,height);
    ::ReleaseDC(GetDesktopWindow(),hdc);
    if(!xid){ fxerror("%s::create: unable to create image.\n",getClassName()); }

    // Create uninitialized shape bitmap
    shape=CreateBitmap(width,height,1,1,NULL);
    if(!shape){ fxerror("%s::create: unable to create icon.\n",getClassName()); }

#endif
  
    // Render pixels 
    render();
    
    // Zap data 
    if(!(options&IMAGE_KEEP) && (options&IMAGE_OWNED)){
      options&=~IMAGE_OWNED;
      FXFREE(&data);
      }
    }
  }


// Detach icon
void FXIcon::detach(){
  if(xid){
    FXTRACE((100,"%s::detach %08x\n",getClassName(),this));
    shape=0;
    xid=0;
    }
  }


// Destroy icon
void FXIcon::destroy(){
  if(xid){
#ifndef FX_NATIVE_WIN32
    FXTRACE((100,"%s::destroy %08x\n",getClassName(),this));
    XFreePixmap(getApp()->display,shape);
    XFreePixmap(getApp()->display,xid);
#else
    DeleteObject(xid);
    DeleteObject(shape);
#endif
    shape=0;
    xid=0;
    }
  }


// // Restore image from drawables
// int FXIcon::restore(){
//   if(FXImage::restore()){
//     if(shape){
//       if(mask) XDestroyImage(mask);
//       mask=XGetImage(getApp()->display,shape,0,0,width,height,AllPlanes,ZPixmap);
//       }
//     }
//   return mask!=0 && image!=0;
//   }


// Render pixels into bitmap
#ifndef FX_NATIVE_WIN32
void FXIcon::render_bitmap(XImage *xim,FXuchar *img){
  register FXuchar *pix,tr,tg,tb;
  register FXuint jmp;
  register FXint x,y;
  pix=(FXuchar*)xim->data;
  jmp=xim->bytes_per_line;
  
  // Transparent image
  if(!(options&IMAGE_OPAQUE)){
    
    // Transparency through alpha channel
    if(options&IMAGE_ALPHA){
      if(xim->bitmap_bit_order==MSBFirst){
        for(y=0; y<height; y++){
          for(x=0; x<width; x++){
            if(img[3]==0)
              XPutPixel(xim,x,y,0);
//             pix[x>>3]&=(0x80>>(x&7));
            else
              XPutPixel(xim,x,y,1);
//             pix[x>>3]|=(0x80>>(x&7));
            img+=4;
            }
          pix+=jmp;
          }
        }
      else{
        for(y=0; y<height; y++){
          for(x=0; x<width; x++){
            if(img[3]==0)
              XPutPixel(xim,x,y,0);
//             pix[x>>3]&=(0x01<<(x&7));
            else
              XPutPixel(xim,x,y,1);
//             pix[x>>3]|=(0x01<<(x&7));
            img+=4;
            }
          pix+=jmp;
          }
        }
      }

    // Transparency indicated by special pixel value
    else{
      tr=FXREDVAL(transp);
      tg=FXGREENVAL(transp);
      tb=FXBLUEVAL(transp);
      if(xim->bitmap_bit_order==MSBFirst){
        for(y=0; y<height; y++){
          for(x=0; x<width; x++){
            if(img[0]==tr && img[1]==tg && img[2]==tb)
              XPutPixel(xim,x,y,0);
//             pix[x>>3]&=(0x80>>(x&7));
            else
              XPutPixel(xim,x,y,1);
//             pix[x>>3]|=(0x80>>(x&7));
            img+=3;
            }
          pix+=jmp;
          }
        }
      else{
        for(y=0; y<height; y++){
          for(x=0; x<width; x++){
            if(img[0]==tr && img[1]==tg && img[2]==tb)
              XPutPixel(xim,x,y,0);
//             pix[x>>3]&=(0x01<<(x&7));
            else
              XPutPixel(xim,x,y,1);
//             pix[x>>3]|=(0x01<<(x&7));
            img+=3;
            }
          pix+=jmp;
          }
        }
      }
    }
  
  // No transparency at all:- just set it all to 1's
  else{
    for(y=0; y<height; y++){
      for(x=0; x<width; x++){
        XPutPixel(xim,x,y,1);
        }
      }
//     memset(pix,0xff,xim->bytes_per_line*height);
    }
  }
#endif


#ifndef FX_NATIVE_WIN32

// Render icon X Windows
void FXIcon::render(){
#ifdef HAVE_XSHM
  XShmSegmentInfo shminfo;
#endif
  register Visual *vis;
  register XImage *xim=NULL;
  register FXbool shmi=FALSE;
  XGCValues values;
  GC gc;
  
  FXTRACE((100,"%s::render shape %0x8\n",getClassName(),this));
  
  // Can not render before creation
  if(!xid || !shape){ fxerror("%s::render: trying to render icon before it has been created.\n",getClassName()); }

  // Check for legal size
  if(width<2 || height<2){ fxerror("%s::render: illegal icon size.\n",getClassName()); }

  // Render the image pixels
  FXImage::render();
 
  // Make GC
  values.foreground=0xffffffff;
  values.background=0xffffffff;
  gc=XCreateGC(getApp()->display,shape,GCForeground|GCBackground,&values);
 
  // Just leave if black if no data
  if(data){
   
    // Get Visual
    vis=visual->visual;
  
    // Turn it on iff both supported and desired
#ifdef HAVE_XSHM
    if(options&IMAGE_SHMI) shmi=getApp()->shmi;
#endif
    
    // First try XShm
#ifdef HAVE_XSHM
    if(shmi){
      xim=XShmCreateImage(getApp()->display,vis,1,ZPixmap,NULL,&shminfo,width,height);
      if(!xim){ shmi=0; }
      if(shmi){
        shminfo.shmid=shmget(IPC_PRIVATE,xim->bytes_per_line*xim->height,IPC_CREAT|0777);
        if(shminfo.shmid==-1){ XDestroyImage(xim); xim=NULL; shmi=0; }
        if(shmi){
          shminfo.shmaddr=xim->data=(char*)shmat(shminfo.shmid,0,0);
          shminfo.readOnly=FALSE;
          XShmAttach(getApp()->display,&shminfo);
          FXTRACE((150,"Bitmap XSHM attached at memory=0x%08x (%d bytes)\n",xim->data,xim->bytes_per_line*xim->height));
          }
        }
      }
#endif
    
    // Try the old fashioned way
    if(!shmi){
      
      // Try create image
      xim=XCreateImage(getApp()->display,vis,1,ZPixmap,0,NULL,width,height,32,0);
      if(!xim){ fxerror("%s::render: unable to render icon.\n",getClassName()); }
  
      // Try create temp pixel store
      xim->data=(char*)malloc(xim->bytes_per_line*height);
      if(!xim->data){ fxerror("%s::render: unable to allocate memory.\n",getClassName()); }
      }

    // Should have succeeded
    FXASSERT(xim);

    FXTRACE((150,"bm format = %d\n",xim->format));
    FXTRACE((150,"bm byte_order = %s\n",(xim->byte_order==MSBFirst)?"MSBFirst":"LSBFirst"));
    FXTRACE((150,"bm bitmap_unit = %d\n",xim->bitmap_unit));
    FXTRACE((150,"bm bitmap_bit_order = %s\n",(xim->bitmap_bit_order==MSBFirst)?"MSBFirst":"LSBFirst"));
    FXTRACE((150,"bm bitmap_pad = %d\n",xim->bitmap_pad));
    FXTRACE((150,"bm bitmap_unit = %d\n",xim->bitmap_unit));
    FXTRACE((150,"bm depth = %d\n",xim->depth));
    FXTRACE((150,"bm bytes_per_line = %d\n",xim->bytes_per_line));
    FXTRACE((150,"bm bits_per_pixel = %d\n",xim->bits_per_pixel));

    // Render the shape
    render_bitmap(xim,data);

    // Transfer image with shared memory
#ifdef HAVE_XSHM
    if(shmi){
      XShmPutImage(getApp()->display,shape,gc,xim,0,0,0,0,width,height,False);
      XSync(getApp()->display,False);
      FXTRACE((150,"Bitmap XSHM detached at memory=0x%08x (%d bytes)\n",xim->data,xim->bytes_per_line*xim->height));
      XShmDetach(getApp()->display,&shminfo);
      XDestroyImage(xim);
      shmdt(shminfo.shmaddr);
      shmctl(shminfo.shmid,IPC_RMID,0);
      }
#endif

    // Transfer the image old way
    if(!shmi){
      XPutImage(getApp()->display,shape,gc,xim,0,0,0,0,width,height);
#ifndef WIN32
      //// Need to use something other than malloc for WIN32....
      XDestroyImage(xim);
#endif
      }
    }

  // No data, make shape opaque
  else{
    XFillRectangle(getApp()->display,shape,gc,0,0,width,height);
    }
 
  // We're done
  XFreeGC(getApp()->display,gc);
  }


#else


// Render Icon MS-Windows
void FXIcon::render(){
  register FXuchar *widedata,*pix,*img;
  register FXint x,y;
  register FXuchar tr,tg,tb;
 
  FXTRACE((100,"%s::render %0x8\n",getClassName(),this));

  // Can not render before creation
  if(!xid || !shape){ fxerror("%s::render: trying to render icon before it has been created.\n",getClassName()); }

  // Check for legal size
  if(width<2 || height<2){ fxerror("%s::render: illegal icon size.\n",getClassName()); }

  // Just leave if black if no data
  if(data){
   
    // Render the image (color) pixels as usual
    FXImage::render();
		
    // Now render the shape
    if(!(options&IMAGE_OPAQUE)){

      // Allocate temp bit buffer
      FXuint bytes_per_line=((width+31)&~31)>>3;
      FXCALLOC(&widedata,FXuchar,height*bytes_per_line);

      // 0->fg, 1->bg

      // Transparency through alpha channel
      if(options&IMAGE_ALPHA){
        pix=widedata+(height-1)*bytes_per_line;
        img=data;
        for(y=0; y<height; y++){
          for(x=0; x<width; x++){
            if(img[3]==0) pix[x>>3]|=(0x80>>(x&7));
            img+=4;
            }
          pix-=bytes_per_line;
          }
        }

      // Transparency indicated by special pixel value
      else{
        tr=FXREDVAL(transp);
        tg=FXGREENVAL(transp);
        tb=FXBLUEVAL(transp);
        pix=widedata+(height-1)*bytes_per_line;
        img=data;
        for(y=0; y<height; y++){
          for(x=0; x<width; x++){
            if(img[0]==tr && img[1]==tg && img[2]==tb) pix[x>>3]|=(0x80>>(x&7));
            img+=3;
            }
          pix-=bytes_per_line;
          }
        }

      // Set up the bitmap info
      LPBITMAPINFO bmi;
      FXCALLOC(&bmi,BYTE,sizeof(BITMAPINFOHEADER)+2*sizeof(RGBQUAD));
      bmi->bmiHeader.biSize=sizeof(BITMAPINFOHEADER);
      bmi->bmiHeader.biWidth=width;
      bmi->bmiHeader.biHeight=height;
      bmi->bmiHeader.biPlanes=1;
      bmi->bmiHeader.biBitCount=1;
      bmi->bmiHeader.biCompression=0;
      bmi->bmiHeader.biSizeImage=0;
      bmi->bmiHeader.biXPelsPerMeter=0;
      bmi->bmiHeader.biYPelsPerMeter=0;
      bmi->bmiHeader.biClrUsed=0;
      bmi->bmiHeader.biClrImportant=0;
      bmi->bmiColors[0].rgbBlue=0;
      bmi->bmiColors[0].rgbGreen=0;
      bmi->bmiColors[0].rgbRed=0;
      bmi->bmiColors[0].rgbReserved=0;
      bmi->bmiColors[1].rgbBlue=255;
      bmi->bmiColors[1].rgbGreen=255;
      bmi->bmiColors[1].rgbRed=255;
      bmi->bmiColors[1].rgbReserved=0;

      // The MSDN documentation for SetDIBits() states that "the device context
      // identified by the (first) parameter is used only if the DIB_PAL_COLORS
      // constant is set for the (last) parameter". This may be true, but under
      // Win95 you must pass in a non-NULL hdc for the first parameter; otherwise
      // this call to SetDIBits() will fail. (In contrast, it works fine under
      // Windows NT if you pass in a NULL hdc.)
      if(!SetDIBits((HDC)hdcmem,(HBITMAP)shape,0,height,widedata,bmi,DIB_RGB_COLORS)){
        fxerror("%s::render: unable to render pixels\n",getClassName());
        }

      FXFREE(&bmi);

      GdiFlush();

      FXFREE(&widedata);
      }
    else{
      HDC hdc=::GetDC(GetDesktopWindow());
      HDC hdcMsk=CreateCompatibleDC(hdc);
      ::ReleaseDC(GetDesktopWindow(),hdc);

      // Initialize all bits to 0
      HBITMAP old=(HBITMAP)SelectObject(hdcMsk,shape);
      BitBlt(hdcMsk,0,0,width,height,hdcMsk,0,0,BLACKNESS);

      // Clean up
      SelectObject(hdcMsk,old);
      DeleteDC(hdcMsk);
      }
    }
  }


#endif


// Clean up
FXIcon::~FXIcon(){
  FXTRACE((100,"FXIcon::~FXIcon %08x\n",this));
  if(shape){
#ifndef FX_NATIVE_WIN32
    XFreePixmap(getApp()->display,shape);
#else
    DeleteObject(shape);
#endif
    }
  }
