/********************************************************************************
*                                                                               *
*                 F i l e  - A s s o c i a t i o n   T a b l e                  *
*                                                                               *
*********************************************************************************
* Copyright (C) 1998 by Jeroen van der Zijp.   All Rights Reserved.             *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Library General Public                   *
* License as published by the Free Software Foundation; either                  *
* version 2 of the License, or (at your option) any later version.              *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Library General Public License for more details.                              *
*                                                                               *
* You should have received a copy of the GNU Library General Public             *
* License along with this library; if not, write to the Free                    *
* Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
*********************************************************************************
* $Id: FXFileDict.cpp,v 1.2 1999/11/16 18:29:26 jeroen Exp $                    *
********************************************************************************/
#include "xincs.h"
#include "fxdefs.h"
#include "FXStream.h"
#include "FXString.h"
#include "FXObject.h"
#include "FXDict.h"
#include "FXRegistry.h"
#include "FXApp.h"
#include "FXId.h"
#include "FXDrawable.h"
#include "FXImage.h"
#include "FXIcon.h"
#include "FXGIFIcon.h"
#include "FXBMPIcon.h"
#include "FXFileDict.h"

  
/*
  Notes:
  - FXIconDict should keep path in an FXString; path should be settable
    from outside, rather than automatically from registry; this will make
    FXIconDict a little bit more generally applicable.
  - FXFileDict needs additional fields, e.g. a print command.
  - Add mime-type.
*/


#define COMMANDLEN   256
#define EXTENSIONLEN 128
#define MIMETYPELEN  64
#define ICONNAMELEN  64


/*******************************************************************************/


// Object implementation
FXIMPLEMENT(FXIconDict,FXDict,NULL,0)


// Build icon table
FXIconDict::FXIconDict(FXApp* a):app(a),path(NULL){
  FXTRACE((100,"FXIconDict::FXIconDict\n"));
  }


// Try and load the icon
void *FXIconDict::createData(const void* ptr){
  register const FXchar *ext;  
  
  // Make sure
  if(!ptr) return NULL;

  // Get icon path
  if(!path){
    path=app->reg().readStringEntry("SETTINGS","iconpath","~/.foxicons");
    FXTRACE((150,"FXIconDict: iconpath = %s\n",path));
    }
  
  // Get file extension
  ext=strrchr((const char*)ptr,'.');
  
  // Determine what type
  if(ext){
    FXIcon *icon=NULL;
    
    // Create icon of the right type
    if(strcmp(".gif",ext)==0 || strcmp(".GIF",ext)==0){
      icon=new FXGIFIcon(app);
      }
    else if(strcmp(".bmp",ext)==0 || strcmp(".BMP",ext)==0){
      icon=new FXBMPIcon(app);
      }
    
    // Got icon
    if(icon){
      FXchar iconfile[MAXPATHLEN];
      
      // Find icon in the icon directory
      if(fxsearchpath(iconfile,path,(const char*)ptr)){
        FXFileStream str;
        
        FXTRACE((150,"FXIconDict: found icon in = %s\n",iconfile));
  
        // Try open the file
        if(str.open(iconfile,FXStreamLoad)){

          FXTRACE((150,"FXIconDict: loading = %s\n",iconfile));

          // Load it
          icon->loadPixels(str);

          // Done
          str.close();

          return icon;
          }
        }
      
      // Failed, delete the icon
      delete icon;
      }
    }
  return NULL;
  }


// Free the icon
void FXIconDict::deleteData(void* ptr){
  delete ((FXIcon*)ptr);
  }


// Save data
void FXIconDict::save(FXStream& store) const {
  FXDict::save(store);
  FXASSERT(0);
  }


// Load data
void FXIconDict::load(FXStream& store){ 
  FXDict::load(store);
  FXASSERT(0);
  }


// Destructor
FXIconDict::~FXIconDict(){
  FXTRACE((100,"FXIconDict::~FXIconDict\n"));
  clear();
  }


/*******************************************************************************/

// Object implementation
FXIMPLEMENT(FXFileDict,FXDict,NULL,0)


// Construct file extension mapping dictionary
FXFileDict::FXFileDict(FXApp* a):icons(a){
  FXTRACE((100,"FXFileDict::FXFileDict\n"));
  }


// Create new association from extension
void *FXFileDict::createData(const void* ptr){
  FXchar command[COMMANDLEN];
  FXchar extension[EXTENSIONLEN];
  FXchar mimetype[MIMETYPELEN];
  FXchar bigname[ICONNAMELEN];
  FXchar mininame[ICONNAMELEN];
  FXFileAssoc *fileassoc;
  const FXchar *p;
  FXchar *q;
  
  FXTRACE((150,"FXFileDict: adding association: %s\n",(FXchar*)ptr));
  
  // Make association record
  fileassoc=new FXFileAssoc;

  // Scan entry
  p=(FXchar*)ptr;
  q=command;
  while(*p && *p!=';' && (p<&command[COMMANDLEN-1])) *q++=*p++;
  *q='\0';
  if(*p==';') p++;
  q=extension;
  while(*p && *p!=';' && (p<&command[EXTENSIONLEN-1])) *q++=*p++;
  *q='\0';
  if(*p==';') p++;
  q=bigname;
  while(*p && *p!=';' && (p<&command[ICONNAMELEN-1])) *q++=*p++;
  *q='\0';
  if(*p==';') p++;
  q=mininame;
  while(*p && *p!=';' && (p<&command[ICONNAMELEN-1])) *q++=*p++;
  *q='\0';
  q=mimetype;
  while(*p && *p!=';' && (p<&command[MIMETYPELEN-1])) *q++=*p++;
  *q='\0';


  FXTRACE((150,"FXFileDict: command=\"%s\" extension=\"%s\" mimetype=\"%s\" big=\"%s\" mini=\"%s\"\n",command,extension,mimetype,bigname,mininame));

  // Set association data
  fileassoc->command=command;
  fileassoc->extension=extension;
  fileassoc->mimetype=mimetype;

  // Got big icon?
  fileassoc->bigicon=NULL;
  if(bigname[0]){
    fileassoc->bigicon=icons.insert(bigname);
    }

  // Got miniicon
  fileassoc->miniicon=NULL;
  if(mininame[0]){
    fileassoc->miniicon=icons.insert(mininame);
    }

  // Drag type
  fileassoc->dragtype=0;
  return fileassoc;
  }


// Delete association
void FXFileDict::deleteData(void* ptr){
  delete ((FXFileAssoc*)ptr);
  }


// Replace or add file association
FXFileAssoc* FXFileDict::replace(const FXchar* ext,const FXchar* str){
  
  // Replace entry in registry
  getApp()->reg().writeStringEntry("FILETYPES",ext,str);
  
  // Replace record 
  return (FXFileAssoc*)FXDict::replace(ext,str);
  }


// Remove file association
FXFileAssoc* FXFileDict::remove(const FXchar* ext){
  
  // Delete registry entry for this type
  getApp()->reg().deleteEntry("FILETYPES",ext);
  
  // Remove record
  FXDict::remove(ext);
  
  return NULL;
  }


// Find file association
FXFileAssoc* FXFileDict::associate(const FXchar* ext){
  register const FXchar *association;
  register FXFileAssoc* record;
  
  FXTRACE((150,"FXFileDict: searching extension: %s\n",ext));

  // See if we have an existing record already
  if((record=find(ext))!=NULL) return record;
  
  // If not, see if this entry is known in FILETYPES
  association=getApp()->reg().readStringEntry("FILETYPES",ext,(FXchar*)NULL);
  
  // If known, make a record for it now
  if(association) return (FXFileAssoc*)FXDict::insert(ext,association);
  
  // Not a known file type
  return NULL;
  }


// Save data
void FXFileDict::save(FXStream& store) const {
  FXDict::save(store);
  FXASSERT(0);
  }


// Load data
void FXFileDict::load(FXStream& store){ 
  FXDict::load(store);
  FXASSERT(0);
  }


// Destructor
FXFileDict::~FXFileDict(){
  FXTRACE((100,"FXFileDict::~FXFileDict\n"));
  clear();
  }
