/********************************************************************************
*                                                                               *
*                      F i l e   S e l e c t i o n   O b j e c t                *
*                                                                               *
*********************************************************************************
* Copyright (C) 1998 by Jeroen van der Zijp.   All Rights Reserved.             *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Library General Public                   *
* License as published by the Free Software Foundation; either                  *
* version 2 of the License, or (at your option) any later version.              *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Library General Public License for more details.                              *
*                                                                               *
* You should have received a copy of the GNU Library General Public             *
* License along with this library; if not, write to the Free                    *
* Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
*********************************************************************************
* $Id: FXFileSelector.h,v 1.3 1999/11/16 18:29:25 jeroen Exp $                  *
********************************************************************************/
#ifndef FXFILESELECTOR_H
#define FXFILESELECTOR_H


// File selection widget
class FXAPI FXFileSelector : public FXPacker {
  FXDECLARE(FXFileSelector)
protected:
  FXFileList    *filebox;         // File list widget
  FXTextField   *filename;        // File name entry field
  FXComboBox    *filefilter;      // Combobox for pattern list
  FXDirBox      *dirbox;          // Directory hierarchy list
  FXButton      *accept;          // Accept button
  FXButton      *cancel;          // Cancel button
  FXGIFIcon     *updiricon;       // Up directory icon
  FXGIFIcon     *newdiricon;      // New directory icon
  FXGIFIcon     *listicon;        // List mode icon
  FXGIFIcon     *detailicon;      // Detail mode icon
  FXGIFIcon     *iconsicon;       // Icon mode icon
protected:
  FXFileSelector(){}
private:
  FXFileSelector(const FXFileSelector&);
  FXFileSelector &operator=(const FXFileSelector&);
public:
  long onCmdName(FXObject*,FXSelector,void*);
  long onCmdFilter(FXObject*,FXSelector,void*);
  long onCmdItemOpened(FXObject*,FXSelector,void*);
  long onCmdItemSelected(FXObject*,FXSelector,void*);
  long onCmdDirectoryUp(FXObject*,FXSelector,void*);
  long onUpdDirectoryUp(FXObject*,FXSelector,void*);
  long onCmdDirTree(FXObject*,FXSelector,void*);
public:
  enum{
    ID_FILEFILTER=FXPacker::ID_LAST,
    ID_FILENAME,
    ID_FILELIST,
    ID_DIRECTORY_UP,
    ID_DIRTREE,
    ID_LAST
    };
public:
  FXFileSelector(FXComposite *p,FXObject* tgt=NULL,FXSelector sel=0,FXuint opts=0,FXint x=0,FXint y=0,FXint w=0,FXint h=0);
  FXButton *acceptButton() const { return accept; }
  FXButton *cancelButton() const { return cancel; }
  void setFilename(const FXString& path);
  FXString getFilename() const;
  void setPattern(const FXString& ptrn);
  FXString getPattern() const;
  void setDirectory(const FXString& path);
  FXString getDirectory() const;
  void setCurrentPattern(FXint n);
  FXint getCurrentPattern() const;
  FXString getPatternText(FXint patno) const;
  void setPatternText(FXint patno,const FXString& text);
  void setPatternList(const FXchar **ptrns);
  void setItemSpace(FXint s);
  FXint getItemSpace() const;
  virtual void save(FXStream& store) const;
  virtual void load(FXStream& store);
  virtual ~FXFileSelector();
  };


#endif
