/********************************************************************************
*                                                                               *
*                         T r e e   L i s t   W i d g e t                       *
*                                                                               *
*********************************************************************************
* Copyright (C) 1997 by Jeroen van der Zijp.   All Rights Reserved.             *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Library General Public                   *
* License as published by the Free Software Foundation; either                  *
* version 2 of the License, or (at your option) any later version.              *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Library General Public License for more details.                              *
*                                                                               *
* You should have received a copy of the GNU Library General Public             *
* License along with this library; if not, write to the Free                    *
* Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
*********************************************************************************
* $Id: FXOldTreeList.h,v 1.2 1999/09/21 13:30:03 jeroen Exp $                   *
********************************************************************************/
#ifndef FXOLDTREELIST_H
#define FXOLDTREELIST_H


//////////////////////  THIS WIDGET HAS BEEN DEPRECATED  ////////////////////////


// Tree List options
enum FXOldTreeListStyle {
  OLDTREELIST_EXTENDEDSELECT = 0,
  OLDTREELIST_SINGLESELECT   = 0x00100000,       // Single selection mode
  OLDTREELIST_BROWSESELECT   = 0x00200000,       // Browse selection mode
  OLDTREELIST_MULTIPLESELECT = OLDTREELIST_SINGLESELECT|OLDTREELIST_BROWSESELECT,  // Multiple select
  OLDTREELIST_AUTOSELECT     = 0x00400000,       // Automatically select under cursor
  OLDTREELIST_SHOWS_LINES    = 0x00800000,       // Lines shown
  OLDTREELIST_SHOWS_BOXES    = 0x01000000,       // Boxes to expand shown
  OLDTREELIST_ROOT_BOXES     = 0x02000000,       // Display root boxes also
  OLDTREELIST_WANTSELECTION  = 0x04000000        // Claim the selection
  };


enum FXTreeItemState {
  OLDTREEITEM_CURRENT    = 1,                    // Current item
  OLDTREEITEM_SELECTED   = 2,                    // Has been selected
  OLDTREEITEM_HISTORY    = 4,                    // Was selected
  OLDTREEITEM_MARK       = 8,                    // Marked selection state
  OLDTREEITEM_OPEN       = 16,                   // Item is open
  OLDTREEITEM_EXPANDED   = 32,                   // Item is expanded
  OLDTREEITEM_HASITEMS   = 64,                   // Logically has subitems
  OLDTREEITEM_DRAGGABLE  = 128                   // Item may be dragged
  };


struct FXAPI FXOldTreeItem {
  FXOldTreeItem *prev;
  FXOldTreeItem *next;
  FXOldTreeItem *parent;
  FXOldTreeItem *first;
  FXOldTreeItem *last;
  FXString       label;
  FXIcon        *openIcon;
  FXIcon        *closedIcon;
  FXuint         state;
  void          *data;
  FXint          x,y;
  };



// Item collate function
typedef FXbool (*FXOldTreeItemSortFunc)(const FXOldTreeItem*,const FXOldTreeItem*);


// Generic tab item
class FXAPI FXOldTreeList : public FXScrollArea {
  FXDECLARE(FXOldTreeList)
protected:
  FXOldTreeItem        *firstitem;
  FXOldTreeItem        *lastitem;
  FXOldTreeItem        *anchoritem;
  FXOldTreeItem        *currentitem;
  FXFont               *font;
  FXOldTreeItemSortFunc sortfunc;
  FXColor               textColor;
  FXColor               selbackColor;
  FXColor               seltextColor;
  FXColor               lineColor;
  FXint                 iconWidth;
  FXint                 iconHeight;
  FXint                 itemWidth;
  FXint                 itemHeight;
  FXint                 totalWidth;
  FXint                 totalHeight;
  FXint                 indent;
  FXTimer              *timer;
  FXString              help;
protected:
  FXOldTreeList();
  virtual FXOldTreeItem* createItem();
  virtual void deleteItem(FXOldTreeItem*);
  void drawFocusRectangle(FXDCWindow& dc,FXint x,FXint y,FXint w,FXint h);
  void sort(FXOldTreeItem*& f1,FXOldTreeItem*& t1,FXOldTreeItem*& f2,FXOldTreeItem*& t2,int n);
  void recompute();
  virtual void layout();
private:
  FXOldTreeList(const FXOldTreeList&);
  FXOldTreeList &operator=(const FXOldTreeList&);
public:
  long onPaint(FXObject*,FXSelector,void*);
  long onEnter(FXObject*,FXSelector,void*);
  long onLeave(FXObject*,FXSelector,void*);
  long onUngrabbed(FXObject*,FXSelector,void*);
  long onMotion(FXObject*,FXSelector,void*);
  long onKeyPress(FXObject*,FXSelector,void*);
  long onKeyRelease(FXObject*,FXSelector,void*);
  long onLeftBtnPress(FXObject*,FXSelector,void*);
  long onLeftBtnRelease(FXObject*,FXSelector,void*);
  long onActivate(FXObject*,FXSelector,void*);
  long onDeactivate(FXObject*,FXSelector,void*);
  long onQueryTip(FXObject*,FXSelector,void*);
  long onQueryHelp(FXObject*,FXSelector,void*);
  long onTipTimer(FXObject*,FXSelector,void*);
  long onFocusIn(FXObject*,FXSelector,void*);
  long onFocusOut(FXObject*,FXSelector,void*);
  long onSelectionLost(FXObject*,FXSelector,void*);
  long onSelectionGained(FXObject*,FXSelector,void*);
  long onAutoScroll(FXObject*,FXSelector,void*);
  long onItemOpened(FXObject*,FXSelector,void*);
  long onItemClosed(FXObject*,FXSelector,void*);
  long onItemExpanded(FXObject*,FXSelector,void*);
  long onItemCollapsed(FXObject*,FXSelector,void*);
  long onChanged(FXObject*,FXSelector,void*);
  long onClicked(FXObject*,FXSelector,void*);
  long onDoubleClicked(FXObject*,FXSelector,void*);
  long onTripleClicked(FXObject*,FXSelector,void*);
  long onSelected(FXObject*,FXSelector,void*);
  long onDeselected(FXObject*,FXSelector,void*);
public:
  enum {
    ID_TIPTIMER=FXScrollArea::ID_LAST,
    ID_LAST
    };
public:
  FXOldTreeList(FXComposite *p,FXObject* tgt=NULL,FXSelector sel=0,FXuint opts=0,FXint x=0,FXint y=0,FXint w=0,FXint h=0);
  virtual void create();
  virtual void detach();
  virtual void recalc();
  virtual FXint getContentWidth();
  virtual FXint getContentHeight();
  virtual FXbool canFocus() const;
  FXint getNumItems() const;
  FXint getNumChildItems(FXOldTreeItem* par) const;
  FXint getNumSelectedItems() const;
  FXOldTreeItem** getSelectedItems() const;
  FXOldTreeItem* getFirstItem() const { return firstitem; }
  FXOldTreeItem* getLastItem() const { return lastitem; }
  FXOldTreeItem* getNextItem(const FXOldTreeItem* item) const;
  FXOldTreeItem* getPrevItem(const FXOldTreeItem* item) const;
  FXOldTreeItem* getFirstChildItem(const FXOldTreeItem* item) const;
  FXOldTreeItem* getLastChildItem(const FXOldTreeItem* item) const;
  FXOldTreeItem* getParentItem(const FXOldTreeItem* item) const;
  FXOldTreeItem* getItemAbove(FXOldTreeItem* item) const;
  FXOldTreeItem* getItemBelow(FXOldTreeItem* item) const;
  virtual FXOldTreeItem* addItemFirst(FXOldTreeItem* p,const FXString& text,FXIcon* oi=NULL,FXIcon* ci=NULL,void* ptr=NULL);
  virtual FXOldTreeItem* addItemLast(FXOldTreeItem* p,const FXString& text,FXIcon* oi=NULL,FXIcon* ci=NULL,void* ptr=NULL);
  virtual FXOldTreeItem* addItemAfter(FXOldTreeItem* other,const FXString& text,FXIcon* oi=NULL,FXIcon* ci=NULL,void* ptr=NULL);
  virtual FXOldTreeItem* addItemBefore(FXOldTreeItem* other,const FXString& text,FXIcon* oi=NULL,FXIcon* ci=NULL,void* ptr=NULL);
  virtual void removeItem(FXOldTreeItem* item);
  virtual void removeItems(FXOldTreeItem* fm,FXOldTreeItem* to);
  virtual void removeAllItems();
  virtual FXOldTreeItem* getItemAt(FXint x,FXint y) const;
  FXbool openItem(FXOldTreeItem* item);
  FXbool closeItem(FXOldTreeItem* item);
  FXbool collapseTree(FXOldTreeItem* tree);
  FXbool expandTree(FXOldTreeItem* tree);
  virtual FXint getItemX(const FXOldTreeItem* item) const;
  virtual FXint getItemY(const FXOldTreeItem* item) const;
  virtual FXint getItemWidth(const FXOldTreeItem* item) const;
  virtual FXint getItemHeight(const FXOldTreeItem* item) const;
  void updateItem(FXOldTreeItem* item);
  void makeItemVisible(FXOldTreeItem* item);
  FXbool isItemSelected(const FXOldTreeItem* item) const;
  FXbool isItemCurrent(const FXOldTreeItem* item) const;
  FXbool isItemVisible(const FXOldTreeItem* item) const;
  FXbool isItemOpen(const FXOldTreeItem* item) const;
  FXbool isItemExpanded(const FXOldTreeItem* item) const;
  FXbool isItemLeaf(const FXOldTreeItem* item) const;
  FXbool hitItem(const FXOldTreeItem* item,FXint x,FXint y) const;
  FXbool hitItemBox(const FXOldTreeItem* item,FXint x,FXint y) const;
  FXbool hitItemIcon(const FXOldTreeItem* item,FXint x,FXint y) const;
  void markItems();
  FXbool selectItemRange(FXOldTreeItem* beg,FXOldTreeItem* end);
  FXbool deselectItemRange(FXOldTreeItem* beg,FXOldTreeItem* end);
  FXbool toggleItemRange(FXOldTreeItem* beg,FXOldTreeItem* end);
  FXbool restoreItemRange(FXOldTreeItem* beg,FXOldTreeItem* end);
  FXbool selectItem(FXOldTreeItem* item);
  FXbool toggleItem(FXOldTreeItem* item);
  FXbool deselectItem(FXOldTreeItem* item);
  FXbool restoreItem(FXOldTreeItem* item);
  void sortChildItems(FXOldTreeItem* item);
  void sortItems();
  void setCurrentItem(FXOldTreeItem* item);
  FXOldTreeItem* getCurrentItem() const { return currentitem; }
  void setAnchorItem(FXOldTreeItem* item);
  FXOldTreeItem* getAnchorItem() const { return anchoritem; }
  FXbool extendSelection(FXOldTreeItem* item);
  FXOldTreeItem* findItem(const FXString& text,FXuint len=2147483647) const;
  FXOldTreeItem* findChildItem(FXOldTreeItem* parentitem,const FXString& text,FXuint len=2147483647) const;
  void setItemText(FXOldTreeItem* item,const FXString& text);
  FXString getItemText(const FXOldTreeItem* item) const;
  void setItemOpenIcon(FXOldTreeItem* item,FXIcon* icon);
  FXIcon* getItemOpenIcon(const FXOldTreeItem* item) const;
  void setItemClosedIcon(FXOldTreeItem* item,FXIcon* icon);
  FXIcon* getItemClosedIcon(const FXOldTreeItem* item) const;
  void setItemData(FXOldTreeItem* item,void* ptr) const;
  void* getItemData(const FXOldTreeItem* item) const;
  void setFont(FXFont* fnt);
  FXFont* getFont() const { return font; }
  FXColor getTextColor() const { return textColor; }
  void setTextColor(FXColor clr);
  FXColor getSelBackColor() const { return selbackColor; }
  void setSelBackColor(FXColor clr);
  FXColor getSelTextColor() const { return seltextColor; }
  void setSelTextColor(FXColor clr);
  FXColor getLineColor() const { return lineColor; }
  void setLineColor(FXColor clr);
  void setIconWidth(FXint w);
  FXint getIconWidth() const { return iconWidth; }
  void setIconHeight(FXint h);
  FXint getIconHeight() const { return iconHeight; }
  void setIndent(FXint in);
  FXint getIndent() const { return indent; }
  void setHelpText(const FXString& text);
  FXString getHelpText() const { return help; }
  FXOldTreeItemSortFunc getSortFunc() const { return sortfunc; }
  void setSortFunc(FXOldTreeItemSortFunc func){ sortfunc=func; }
  FXuint getListStyle() const;
  void setListStyle(FXuint style);
  virtual void save(FXStream& store) const;
  virtual void load(FXStream& store);
  virtual ~FXOldTreeList();
  };


#endif
