#
# $Header: /usr/local/cvsroot/pythondoc/formatters/HTML4strings.py,v 1.2 1999/05/01 01:13:21 daniel Exp $
#
# Copyright (C) Daniel Larsson
# All Rights Reserved.
#
# See copyright notice in the file 'LICENSE.TXT', which should have accompanied
# this distribution.
#

"""Strings used to build HTML files.

This module just contains some string used by the HTML 4.0 formatter
to create the HTML files. It is separated from the formatter to more easily
be able to adapt the output.
"""

__author__ = "Daniel Larsson, Daniel.Larsson@telia.com"

import time
import pythondoc.version

HEADER = \
'''<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" "http://www.w3.org/TR/REC-html40/loose.dtd">
<html>

<head>

<META NAME="GENERATOR" CONTENT="pythondoc %s (%s)">

<link rel="stylesheet" href="%%(stylesheet)s" type="text/css">
''' % (pythondoc.version.__version__, time.ctime(time.time()))

MODULE_HEADER = HEADER + '''
<title>Module %(modulename)s</title>
</head>

<body>
%(header)s
<H1 CLASS="ModuleName">Module %(modulename)s</H1>
'''

DECL_IN = '''
<P CLASS="DeclaredIn">Declared in module <A HREF="%s.html">%s</A></P>
'''

FILE_END = '''
%(footer)s
</body>
</html>
'''

CLASS_HEADER = HEADER + '''
<title>Class %(classname)s</title>
</head>

<body>
%(header)s
<H1 CLASS="ClassName">class %(classname)s%(oneliner)s</H1>
<P CLASS="DeclaredIn">Declared in module <A HREF="%(modulename)s.html">%(modulename)s</A></P>

%(hierarchy)s

<H2>Synopsis</H2>
<PRE CLASS="ClassDeclaration">
<SPAN CLASS="PyKeyword">class</SPAN> <SPAN CLASS="ClassName">%(classname)s</SPAN>%(bases)s:
%(methods)s
'''

CLASS_END = '''</PRE>'''

FUNCTION_HEADER = HEADER + '''
<title>Function %(functionname)s</title>
</head>

<body>
%(header)s
<H1 CLASS="FunctionName">%(functionname)s%(oneliner)s</H1>
<P CLASS="DeclaredIn">Declared in module <A HREF="%(modulename)s.html">%(modulename)s</A></P>

<PRE CLASS="FunctionDeclaration">
<SPAN CLASS="PyKeyword">def</SPAN> <SPAN CLASS="FunctionName">%(functionname)s</SPAN>(%(args)s)
'''

FUNCTION_END = '''
</PRE>'''

METHOD = '''    %(linkstart)s<SPAN CLASS="PyKeyword">def</SPAN> <SPAN CLASS="FunctionName">%(methodname)s</SPAN>%(linkend)s(%(args)s)'''

METHOD_HEAD = '''<H2 ID="%(methodname)s" CLASS="Method">%(methodname)s(%(args)s)</H2>
<P>%(oneliner)s</P>
'''

INHERITS_FROM = '\n    <SPAN CLASS="InheritsHead"># Inherited from %s</SPAN>\n'

PARAGRAPH = '''
<P CLASS="Body">
%s
</P>
'''

MODMODULE = '<SPAN CLASS="ModuleHead"><A CLASS="DocLink" HREF="%s.html"><SPAN CLASS="PyKeyword">submodule</SPAN> <SPAN CLASS="ModuleName">%s</SPAN></A></SPAN>%s\n'

MODCLASS = '<SPAN CLASS="ClassHead"><A CLASS="DocLink" HREF="%(href)s.html"><SPAN CLASS="PyKeyword">class</SPAN> <SPAN CLASS="ClassName">%(classname)s</SPAN></A>%(bases)s</SPAN>%(oneliner)s\n'

FUNC_NAME = '<SPAN CLASS="PyKeyword">def</SPAN> <SPAN CLASS="FunctionName">%(funcname)s</SPAN>'

FUNC_DOCLINK = '<A CLASS="DocLink" HREF="#%(funcref)s">' + FUNC_NAME + '</A>'

MODFUNC_T = '<SPAN CLASS="FunctionHead">%s(%%(args)s)</SPAN>%%(oneliner_top)s\n'
MODFUNC = MODFUNC_T % FUNC_NAME
MODFUNC_DOC = MODFUNC_T % FUNC_DOCLINK

MODVAR = '<SPAN CLASS="VariableHead"><SPAN CLASS="VariableType">%s</SPAN> <SPAN CLASS="VariableName">%s</SPAN> = <SPAN CLASS="VariableValue">%s</SPAN></SPAN>\n'

MODALIAS = '<SPAN CLASS="PyKeyword">alias</SPAN> <SPAN CLASS="AliasName">%s</SPAN> = <SPAN CLASS="AliasFor">%s (type %s)</SPAN>\n'

FUNCTION_HEAD = '''<H2 ID="%(funcref)s" CLASS="Function">%(funcname)s(%(args)s)</H2>
<P>%(oneliner)s</P>
'''

ONELINER = '<SPAN CLASS="OneLiner"> # %s</SPAN>'

ARGS_DESC = '''<DL CLASS="Arguments">
  %s
</DL>
'''
ARG_DESC = '''<DT CLASS="Argument" ID="%s">%s</DT><DD CLASS="Argument">%s</DD>\n'''

INDEX_HEADER = HEADER + '''
<title>Contents</title>
</head>

<body>
%(header)s
<H1>Documented Python modules</H1>
<P><A HREF="indices.html">Index</A></P>
'''

INDICES_HEADER = HEADER + '''
<title>Index page</title>
</head>

<body>
%(header)s
<H1>Index page</H1>
<P><A HREF="index.html">Table of contents</A></P>
'''

INDEX_ENTRY = '<P CLASS="IndexEntry%d"><A CLASS="IndexLink" HREF="%s">%s</A></P>\n'

#
# $Log: HTML4strings.py,v $
# Revision 1.2  1999/05/01 01:13:21  daniel
# Removed Windows style line endings.
#
# 
# *****************  Version 6  *****************
# User: Daniel       Date: 98-12-13   Time: 16:14
# Updated in $/Pythondoc/formatters
# New email address.
# Fixed some outputs.
# 
# *****************  Version 5  *****************
# User: Daniel       Date: 98-10-04   Time: 20:48
# Updated in $/Pythondoc/formatters
# Added <META> tag to tell pythondoc generated the HTML pages...
# 
# *****************  Version 4  *****************
# User: Daniel       Date: 98-08-11   Time: 20:52
# Updated in $/Pythondoc/formatters
# Added placeholder for inheritance hierarchy.
# Now, links from functions are only created if there is something to
# link to!!
# 
# *****************  Version 3  *****************
# User: Daniel       Date: 98-08-06   Time: 21:36
# Updated in $/Pythondoc/formatters
# Fixed nested <A> elements to make the generated HTML valid.
# 
# *****************  Version 2  *****************
# User: Daniel       Date: 98-08-06   Time: 20:24
# Updated in $/Pythondoc/formatters
# Added id attribute on argument description element (hyperlink target!).
# 
