/*
 * This file is part of the portable Forth environment written in ANSI C.
 * Copyright (C) 1995  Dirk Uwe Zoller
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * This file is version 0.9.14 of 01-November-95
 * Check for the latest version of this package via anonymous ftp at
 *	roxi.rz.fht-mannheim.de:/pub/languages/forth/pfe-VERSION.tar.gz
 * or	sunsite.unc.edu:/pub/languages/forth/pfe-VERSION.tar.gz
 * or	ftp.cygnus.com:/pub/forth/pfe-VERSION.tar.gz
 *
 * Please direct any comments via internet to
 *	duz@roxi.rz.fht-mannheim.de.
 * Thank You.
 */
/*
 * block.c ---                The Optional Block Word Set
 * (duz 19Jul93)
 */

#include "forth.h"
#include "support.h"

#include <string.h>
#include <limits.h>

#include "missing.h"

Code (block)
{
  *sp = (Cell) block (BLOCK_FILE, *sp);
}

Code (buffer)
{
  int n;

  *sp = (Cell) buffer (BLOCK_FILE, *sp, &n);
}

Code (empty_buffers)
{
  empty_buffers (BLOCK_FILE);
}

Code (flush)
{
  save_buffers_ ();
  empty_buffers_ ();
}

Code (list)
{
  list (BLOCK_FILE, SCR = *sp++);
}

Code (load)
{
  load (BLOCK_FILE, *sp++);
}

code (save_buffers)
{
  save_buffers (BLOCK_FILE);
}

Code (thru)
{
  int hi = *sp++;
  int lo = *sp++;

  thru (BLOCK_FILE, lo, hi);
}

code (update)
{
  update (BLOCK_FILE);
}

/* *INDENT-OFF* */
LISTWORDS (block) =
{
  SV ("BLK", BLK),
  CO ("BLOCK", block),
  CO ("BUFFER", buffer),
  CO ("EMPTY-BUFFERS", empty_buffers),
  CO ("FLUSH", flush),
  CO ("LIST", list),
  CO ("LOAD", load),
  CO ("SAVE-BUFFERS", save_buffers),
  SV ("SCR", SCR),
  CO ("THRU", thru),
  CO ("UPDATE", update)
};
COUNTWORDS (block, "Block + extensions");
