/*
 * Simple string
 * 1998 by yoshidam
 */

#include <stdio.h>
#include "ustring.h"

UString*
allocUString(UString* str)
{
  str->size = INITIAL_STRING_LEN;
  str->len = 0;
  if ((str->str = (unsigned char*)malloc(INITIAL_STRING_LEN)) == NULL) {
    str->size = 0;
    return NULL;
  }

  return str;
}

UString*
enlargeUString(UString* str, int size)
{
  unsigned char* newptr;

  if ((newptr = (unsigned char*)realloc(str->str, str->size + size))
      == NULL) {
    return NULL;
  }
  str->str = newptr;
  str->size += size;

  return str;
}

void
freeUString(UString* str)
{
  str->size = 0;
  str->len = 0;
  free(str->str);
}

int
addUString(UString* s, const unsigned char* a, int len)
{
  if (s->len + len >= s->size) {
    enlargeUString(s, STRING_EXTEND_LEN);
  }
  memcpy(s->str + s->len, a, len);
  s->len += len;

  return s->len;
}

int
addUChar(UString* s, unsigned char a)
{
  if (s->len + 1 >= s->size) {
    enlargeUString(s, STRING_EXTEND_LEN);
  }
  *(s->str + s->len) = a;
  (s->len)++;

  return s->len;
}

int
addUChar2(UString* s, unsigned char a1, unsigned char a2)
{
  if (s->len + 2 >= s->size) {
    enlargeUString(s, STRING_EXTEND_LEN);
  }
  *(s->str + s->len) = a1;
  *(s->str + s->len + 1) = a2;
  s->len += 2;

  return s->len;
}

int
addUChar3(UString* s, unsigned char a1, unsigned char a2, unsigned char a3)
{
  if (s->len + 3 >= s->size) {
    enlargeUString(s, STRING_EXTEND_LEN);
  }
  *(s->str + s->len) = a1;
  *(s->str + s->len + 1) = a2;
  *(s->str + s->len + 2) = a3;
  s->len += 3;

  return s->len;
}

int
addUChar4(UString* s, unsigned char a1, unsigned char a2,
	  unsigned char a3, unsigned char a4)
{
  if (s->len + 4 >= s->size) {
    enlargeUString(s, STRING_EXTEND_LEN);
  }
  *(s->str + s->len) = a1;
  *(s->str + s->len + 1) = a2;
  *(s->str + s->len + 2) = a3;
  *(s->str + s->len + 3) = a4;
  s->len += 4;

  return s->len;
}

int
addUChar5(UString* s, unsigned char a1, unsigned char a2,
	  unsigned char a3, unsigned char a4, unsigned char a5)
{
  if (s->len + 5 >= s->size) {
    enlargeUString(s, STRING_EXTEND_LEN);
  }
  *(s->str + s->len) = a1;
  *(s->str + s->len + 1) = a2;
  *(s->str + s->len + 2) = a3;
  *(s->str + s->len + 3) = a4;
  *(s->str + s->len + 4) = a5;
  s->len += 5;

  return s->len;
}

int
addUChar6(UString* s, unsigned char a1, unsigned char a2,
	  unsigned char a3, unsigned char a4,
	  unsigned char a5, unsigned char a6)
{
  if (s->len + 6 >= s->size) {
    enlargeUString(s, STRING_EXTEND_LEN);
  }
  *(s->str + s->len) = a1;
  *(s->str + s->len + 1) = a2;
  *(s->str + s->len + 2) = a3;
  *(s->str + s->len + 3) = a4;
  *(s->str + s->len + 4) = a5;
  *(s->str + s->len + 5) = a6;
  s->len += 6;

  return s->len;
}

void
dumpUString(UString* s)
{
  int i;

  printf("[%d/%d] ", s->len, s->size);
  for (i = 0; i < s->len ; i++) {
    printf("%02x ", *(s->str + i));
  }
  printf("\n");
}
