\ matfiles.4th
\
\ Write matrices to files
\
\ Copyright (c) 1999 Krishna Myneni
\ Provided under the terms of the GNU General Public License
\
\ Required source files:
\
\	matrix.4th
\	files.4th
\	strings.4th
\
\ Revisions:
\
\	3-26-1999 created  KM
\	5-7-1999  added write_fmat_ascii_file  KM
\

variable matfile_fd

: write_mat_file ( a ^name -- | write a binary integer matrix file )
  \ a is the address of the matrix buffer
  \ ^name is a counted string containing the filename,
  count W/O create-file 
  if 
    2drop
    cr ." Error opening file." cr  
    exit 
  then
  matfile_fd !
  dup mat_size@ * 4 * 8 + 
  matfile_fd @ write-file
  cr . ."  bytes written" cr
  matfile_fd @ close-file drop ;

: write_mat_ascii_file ( a ^name -- | write an ascii integer matrix file )
  count W/O create-file 
  if 
    2drop
    cr ." Error opening file." cr  
    exit 
  then
  matfile_fd !
  dup mat_size@ swap
  0 do
    "  "
    over 0 do
      j 1+ i 1+ 4 pick mat@
      swap count rot s>string count strcat
      "   " count strcat strpck
    loop
    count matfile_fd @ write-line drop
  loop
  2drop 
  matfile_fd @ close-file drop ;

: write_fmat_ascii_file ( a ^name -- | write floating pt matrix file )
	count W/O create-file
	if
	  2drop
	  cr ." Error opening file." cr
	  exit
	then
	matfile_fd !
	dup mat_size@ swap
	0 do
	  "  "
	  over 0 do
	    j 1+ i 1+ 4 pick fmat@ 6 f>string
	    >r count r> count strcat
	    "   " count strcat strpck
	  loop
	  count matfile_fd @ write-line drop
	loop
	2drop
	matfile_fd @ close-file drop ;
       



