// ---------------------------------------------------------------------------
// - t_cio.cpp                                                               -
// - standard system library - simple io tester module                       -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2000 amaury darsch                                   -
// ---------------------------------------------------------------------------

#include "cio.hxx"

int main (int, char**) {
  using namespace aleph;

  // check for standard io stream
  if (c_stdin  () < 0) return 1;
  if (c_stdout () < 0) return 1;
  if (c_stderr () < 0) return 1;

  // check if our file exists
  if (c_isfile ("t_cio.cpp") == false) return 1;
  
  // try to open the file
  int sid = c_openr ("t_cio.cpp");
  if (sid < 0) return 1;
  c_close (sid);

  // try to get a temporary file name
  if (! c_tmpname ()) return 1;

  // ok this is enough
  return 0;
}
