// ---------------------------------------------------------------------------
// - csys.hxx                                                                -
// - standard system library - c system native function definition           -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2000 amaury darsch                                   -
// ---------------------------------------------------------------------------

/// This package contains c-system related procedures. System procedures are
/// os dependant. Typical functions found here are file system definitions,
/// time, revision etc.
/// @author amaury darsch

#ifndef ALEPH_CSYS_HXX
#define ALEPH_CSYS_HXX

namespace aleph {

  /// @return the native directory separator
  char c_dirsep (void);

  /// @return the native option separator
  char c_optsep (void);

  /// @return the os name
  const char* c_osname (void);

  /// exit unconditionnaly with a status code
  void c_exit (int status);

  /// pause for a certain time
  /// @param time the time to pause in milliseonds
  void c_sleep (const long time);

  /// Execute a shell command in another process
  /// @param cmd the command to execute
  /// @return true on success false otherwise
  bool c_system (const char* cmd);
}

#endif
