// ---------------------------------------------------------------------------
// - cserial.hxx                                                             -
// - standard system library - c serial native function definition           -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2000 amaury darsch                                   -
// ---------------------------------------------------------------------------

/// This package contains the functions needed to perfom platform independent
/// data serialization. The package is designed for 32/64 bits signed
/// integers, double floating point number, boolean, and strings.
/// @author amaury darsch

#ifndef ALEPH_CSERIAL_HXX
#define ALEPH_CSERIAL_HXX

namespace aleph {

  /// convert an integer to an array of bytes
  /// @param value the value to convert
  /// @param array the resulting array
  void c_ihton (const int value, char* array);

  /// convert an array of bytes to an integer
  /// @param array the array to convert
  /// @return the integer value
  int c_intoh (char* array);

  /// convert a long long integer to an array of bytes
  /// @param value the value to convert
  /// @param array the resulting array
  void c_llhton (const long long int value, char* array);

  /// convert an array of bytes to an integer
  /// @param array the array to convert
  /// @return the integer value
  long long int c_llntoh (char* array);
}

#endif
