// ---------------------------------------------------------------------------
// - OutputString.hpp                                                        -
// - standard object library - output string stream class definition         -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2000 amaury darsch                                   -
// ---------------------------------------------------------------------------

#ifndef  ALEPH_OUTPUTSTRING_HPP
#define  ALEPH_OUTPUTSTRING_HPP

#ifndef  ALEPH_OUTPUT_HPP
#include "Output.hpp"
#endif

#ifndef  ALEPH_BUFFER_HPP
#include "Buffer.hpp"
#endif

namespace aleph {

  /// The OutputString class offers a facility to treat a string buffer like
  /// a string. Each call to the write method accumulates characters in the 
  /// string buffer. When the toString method is called, the accumulated string
  /// is returned and the buffer is flushed. The OutputString class is very
  /// usefull to perform stream based testing.
  /// @author amaury darsch

  class OutputString: public Output {
  private:
    /// the string buffer
    Buffer d_buffer;

  public:
    /// create a new string stream. 
    OutputString (void);

    /// @return the class name
    String repr (void) const;

    /// write one character on the string stream.
    /// @param value the character to write
    void write (const char value);

    /// write a character string to the output stream
    /// @param value the character string to write  
    void write (const char* value);

    /// write an integer to the output stream
    /// @param value the integer to write
    void write (const long value);

    /// @return the length of this output string buffer
    long length (void) const;

    /// @return a string representation of this buffer and flush
    String toString (void);

    /// flush this string buffer
    void flush (void);
    
  private:
    // make the copy constructor private
    OutputString (const OutputString&);
    // make the assignment operator private
    OutputString& operator = (const OutputString&);
  };
}

#endif
