// ---------------------------------------------------------------------------
// - Reader.hpp                                                              -
// - aleph engine - reader class definition                                  -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2000 amaury darsch                                   -
// ---------------------------------------------------------------------------

#ifndef  ALEPH_READER_HPP
#define  ALEPH_READER_HPP

#ifndef  ALEPH_LEXER_HPP
#include "Lexer.hpp"
#endif

#ifndef  ALEPH_CONS_HPP
#include "Cons.hpp"
#endif

namespace aleph {

  /// The Reader class is the general purpose form reader which supports the
  /// unified aleph syntax. The reader is primarily used to parse file or
  /// be run interactively. The reader consumes tokens until a complete form
  /// can be built. The form does not have any particular meaning and must be
  /// post processed by the application.
  /// @author amaury darsch
  
  class Reader {
  private:
    /// the lexer class
    Lexer* p_lex;
    /// the input stream used by this reader
    Input* p_is;

  public:
    /// create a new reader with an input stream
    /// @param is the input s
    Reader (Input* is);

    /// destroy this reader
    ~Reader (void);

    /// @return a form from this reader or nil in case of eof
    Cons* parse (void);

    /// @return an approximate line number for this reader
    long getlnum (void) const;

  private:
    // make the copy constructor private
    Reader (const Reader&);
    // make the assignement operator private
    Reader& operator = (const Reader&);
    // private reader procedures
    Cons* rform (bool);
    Cons* bform (bool);
  };
}

#endif
