// ---------------------------------------------------------------------------
// - Argument.cpp                                                            -
// - aleph engine - argument class implementation                            -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2000 amaury darsch                                   -
// ---------------------------------------------------------------------------

#include "Interp.hpp"
#include "Argument.hpp"
#include "Exception.hpp"

namespace aleph {

  // create a argument by name with an index

  Argument::Argument (const String& name, const long index) {
    d_name  = name;
    d_index = index;
    d_const  = false;
  }

  // return the class name

  String Argument::repr (void) const {
    return "Argument";
  }

  // set the const flag for this argument

  void Argument::setconst (const bool flag) {
    d_const = flag;
  }

  // set this argument as a const object

  Object* Argument::cdef (Interp* interp, Nameset* nset, Object* object) {
    // check for the const flag
    if (d_const == true)
      throw Exception ("const-error", "const violation for argument", d_name);
    // get the stack interpreter and set the object
    Stack* stk = interp->getstk ();
    stk->set (d_index, object);
    d_const = true;
    return object;
  }

  // set this argument with an object

  Object* Argument::vdef (Interp* interp, Nameset* nset, Object* object) {
    // check for the const flag
    if (d_const == true)
      throw Exception ("const-error", "const violation for argument", d_name);
    // get the stack interpreter and set the object
    Stack* stk = interp->getstk ();
    stk->set (d_index, object);
    return object;
  }

  // evaluate this object - this is like get object

  Object* Argument::eval (Interp* interp, Nameset* nset) {
    Stack* stk = interp->getstk ();
    return stk->get (d_index);
  }
}
