/*  XNECVIEW - a program for visualizing NEC2 structure and gain files
 *
 *  Copyright (C) 1998-1999, P.T. de Boer -- pa3fwm@amsat.org
 *
 *  Distributed on the conditions of the GPL: see the files README and
 *  COPYING, which accompany this source file.
 */

/* ------------------------------------------------------------------------ */


#include "config.h"        /* file defining things like default colours etc. */


#define VERSION "1.0"


typedef struct {     /* structure to describe a point in 3D space */ 
   double x,y,z;
} Point;

typedef struct {     /* structure to describe a straight wire (segment) */
   Point p0,p1;       /* begin and end point */
   double rad;        /* radius */
   int itg;           /* tag number */
   int ns;            /* number of segments for multi-segment wire; -segmentnumber for single-segment wire that's part of a larger wire (GA and GH cards)  */
   int abs;           /* absolute segment number of the first segment of this wire */
   int dispnr;        /* flag: true (nonzero) on any multi-segment wire, and on (a) middle segment for a wire that was split into multiple single-segment wires (GA and GH) */
} Wire;

typedef struct {     /* structure to describe a surface patch */
   int type;          /* see below */
   Point p0,p1,p2,p3; /* corners */
   Point pc;          /* center */
   Point pa;          /* tip of outward normal arrow */
} Surface;
#define SU_rect 1     /* rectangular shape (p2,p3 ignored) */
#define SU_arb 2      /* "arbitrary" shape, shown as a set of 8 crossing lines (p2,p3 ignored) */
#define SU_tri 3      /* triangle (p3 ignored) */
#define SU_quad 4     /* quadrilateral shape */

typedef struct {    /* structure to describe an excitation (only voltage sources, EX card) */
   Wire *wire;        /* pointer to Wire data */
   int seg;           /* segment number withing wire */
} Exci;

typedef struct {    /* structure to describe a load */
   Wire *wire;        /* pointer to Wire data */
   int firstseg;      /* number of first loaded segment within wire */
   int lastseg;       /* number of last loaded segment within wire */
} Load;               /* note: if an LD card specifies a loading which extends over several wires, it is represented here by one Load struct per wire */


extern double extr;	/* size of the biggest dimension of the data to be shown; used for (initial) scaling */

extern int quick;         /* flag to indicate that drawing should be rough but quick */
extern int redraw;        /* flag which signifies need for redrawing */
extern int dragging;      /* flag to indicate that user is dragging the structure */
extern int unbuffered;    /* flag for unbuffered drawing */

                            /* these define the projection: */
extern double phi,theta;      /* angles defining direction of eye */
extern double zoom;           /* zoom factor */
extern double trx,try;        /* 2D-translation, as a fraction of winsize */
extern int winsizex,winsizey; /* size of window in pixels */
extern int winsize;          /* min(winsizex,winsizey) */

extern int gainscale;	     /* type of scaling of gain: */
enum { GSlin,GSarrl,GSlog,numGS };
extern char GSnames[][8];     /* array with names of gainscales */
extern char GSnumbers[][32];  /* array with descriptions of levels of scale lines in plot */

extern int gainplot;         /* type of gain plot: */
enum { GPnone,GP2d,GP3d,numGP };

extern int structplot;       /* type: do structure plot? */
enum { SPnone,SPstruct,SPtags,numSP };

extern int scaleplot;        /* flag: plot gain scale? */

extern int numwires;
extern Wire wires[MAXWIRES];
extern int numsurfaces;
extern Surface surfaces[MAXSURFACES];
extern int numexcis;
extern Exci excis[MAXEXCIS];
extern int numloads;
extern Load loads[MAXLOADS];

extern double gain[MAXTHETAS][MAXPHIS];
extern double gtheta[MAXTHETAS];
extern double gphi[MAXTHETAS];
extern Point gpo[MAXTHETAS][MAXPHIS];
extern int numtheta;
extern int numphi;

extern char *inputfilename;

extern int fontheight;

#ifndef XColor
   #include <X11/Xlib.h>
#endif
extern XColor c_bg;
extern XColor c_axis;
extern XColor c_wire;
extern XColor c_surf;
extern XColor c_back;
extern XColor c_gain;
extern XColor c_scale;
extern XColor c_exci;
extern XColor c_load;



typedef struct {
   void (*SetLineAttributes)(unsigned int,int,int,int);
   void (*DrawLine)(double,double,double,double);
   void (*SetForeground)(XColor *);
   void (*ClearWindow)();
   void (*DrawStringLL)(double,double,char*);
   void (*DrawStringUL)(double,double,char*);
} Outdev;



Outdev *out;

void removecommas(char *p);                 /* change commas in string into spaces */

void read_nec_input(FILE *f);               /* read the input file, and update the arrays of wires and surfaces accordingly */

int read_nec_output(FILE *f);               /* tries to read NEC output data from f, updates gain distribution arrays; returns 1 if not succesful */

void process_nec_output();		    /* transform the gain data array into an array of points in 3D space */

void initX(int *argcp,char **argv);         /* initialize the X-window stuff */

void mainX(void);                           /* main loop (wait for event, process event, redisplay) */

int Pending(void);                          /* test whether events are pending; returns !=0 if present (drawing) action should be interrupted */

void reread(void);                          /* reread the input file(s) */

void draw_all(int ie);                      /* draw antenna; ie=interupt_enable */

void calcproj(void);                        /* calculate the projection matrix etc. */

int write_postscript(char *filename);       /* write postscript to file; return !=0 in case of error */

