/*  XNECVIEW - a program for visualizing NEC2 structure and gain files
 *
 *  Copyright (C) 1998-1999, P.T. de Boer -- pa3fwm@amsat.org
 *
 *  Distributed on the conditions of the GPL: see the files README and
 *  COPYING, which accompany this source file.
 *
 *  Main module.
 */


#include <stdio.h>
#include <stdlib.h>

#include "xnecview.h"


double extr=0;

int unbuffered=0;
int gainscale=0;
int gainplot=GP3d;
int structplot=SPtags;
int scaleplot=0;

int g_argc;
char **g_argv;

char *inputfilename;

/*---------- global variables, together containing the antenna structure -------------*/

int numwires=0;
Wire wires[MAXWIRES];

int numsurfaces=0;
Surface surfaces[MAXSURFACES];

int numexcis=0;
Exci excis[MAXEXCIS];

int numloads=0;
Load loads[MAXLOADS];

/*---------- global variables, together containing the gain distribution -------------*/

double gain[MAXTHETAS][MAXPHIS];
double gtheta[MAXTHETAS];
double gphi[MAXTHETAS];
Point gpo[MAXTHETAS][MAXPHIS];

int numtheta=0;
int numphi=0;

/*------------------------------------------------------------------------------------*/


void info()
{
   puts("Copyright (C) 1998-1999 P.T. de Boer -- pa3fwm@amsat.org\n");
   puts("Xnecview comes with ABSOLUTELY NO WARRANTY. This is free software, and you are\n"
        "welcome to redistribute it under the conditions of version 2 of the GNU GPL.\n"
        "For more information: see the files README and COPYING which should accompany\n"
        "this software, or ask the author.\n");
}

void usage()
{
   puts("Usage: xnecview [-h] [-u] [--help] [--unbuffered] filenames\n"
        "  -h or --help : show this information\n"
        "  -u or --unbuffered : no double buffering\n"
        "  filenames   : names of NEC2 input and/or output files, to be displayed\n");
   exit(1);
}

void cmd(char *s)      /* parse commandline option */
{
   if (!strcmp(s,"-u") || !strcmp(s,"--unbuffered")) { unbuffered=1; return; }
   if (!strcmp(s,"-?") || !strcmp(s,"-h") || !strcmp(s,"--help")) { info(); usage(); exit(0); }
   fprintf(stderr,"Option %s unknown\n",s); usage();
}


void readfile(char *s)
{
   FILE *f;
   f=fopen(s,"r");
   if (!f) {
      fprintf(stderr,"Can't open \"%s\" for reading\n",s);
      usage(); 
   }
   if (numphi>0 || read_nec_output(f)==1) {    /* if gain array not yet filled, try interpreting as output data first */
      rewind(f);
      read_nec_input(f);                       /* otherwise, or if data is not output data, try interpreting as input data */
   }
}


void reread(void)
{
   int i;
   numwires=0;
   numsurfaces=0;
   numexcis=0;
   numloads=0;
   numtheta=0;
   numphi=0;
   extr=0;
   for (i=1;i<g_argc;i++) if (g_argv[i][0]!='-') readfile(g_argv[i]);
   if (numphi>0) process_nec_output();
   calcproj();
}



int main(int argc,char **argv)
{
   int i;
   printf("XNECVIEW %s\n\n",VERSION);

   if (argc==1) {
      info();
      usage();
   }
   initX(&argc,argv);
   g_argc=argc;
   g_argv=argv;
   inputfilename=NULL;
   for (i=1;i<argc;i++) {
      if (argv[i][0]=='-') cmd(argv[i]);
      else {
         if (!inputfilename) inputfilename=argv[i];
         readfile(argv[i]);
      }
   }
   if (numphi==0 && numwires==0 && numsurfaces==0) fprintf(stderr,"No data!\n");
   if (numphi>0) {
      process_nec_output();
      structplot=SPstruct;
   } else {
      gainplot=GPnone;
   }
   calcproj();
   mainX();
   return 0;
}


