/* Terraform - (C) 1997-2000 Robert Gasch (r.gasch@chello.nl)
 *  - http://212.187.12.197/RNG/terraform/
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include <string.h>
#include "TFWindow.h"
#include "HeightField.h"
#include "GlobalTrace.h"
#include "GlobalSanityCheck.h"
#include "MenuDefs.h"
#include "TFOptions.h"


// base color for each color band 
static char	*bandBaseCol[]=	
			{	
				"MidnightBlue",
				"MediumBlue",
				"Blue",
				"Dodger Blue",
				"Green2",
				"Green3",
				"Green4",
				"DarkOliveGreen4",
				"LightGoldenrod2",
				"LightGoldenrod3",
				"LightGoldenrod4",
				"LightYellow4",
				"DimGray",
				"Gray",
				"LightGray",	};

static char 	*bandBaseCol_Desert[]=
			{
				"LightGoldenrod3",
				"LightGoldenrod4",
				"DimGray",
				"LightSlateGray",
				"Gray",
				"LightGray",	};


// never acutally use/compile this code
#if 0
	// This is a dummy object to mislead xgettext into properly 
	// extracting the translatable menu strings. xgettext unfortunately
	// doesn't grok macros, so we need this table to fool it. 
	// This must be kept in sync with MenuDefs.h 
	// The following script will generate this table for you:
	/*
	cat MenuDefs.h | grep "\"" |
	awk ' BEGIN	{ FS = "\""; print ("char *foobar[] = {"); }
			{ printf ("\t\t\t\tN_(\"%s\"),\n", $2); }
		 END	{ print (" };"); } '
	*/
char *foobar[] = {
				N_("/File/"),
				N_("/_File"),
				N_("/File/New"),
				N_("/File/New/Spectral S_ynthesis"),
				N_("/File/New/Sub_division"),
				N_("/File/New/Ra_ndom"),
				N_("/File/_Open"),
				N_("/File/_Merge"),
				N_("/File/Reload"),
				N_("/File/_Save"),
				N_("/File/Save _As ..."),
				N_("/File/Clos_e"),
				N_("/File/Export"),
				N_("/File/Export/Open_GL"),
				N_("/File/Export/PO_VRay"),
				N_("/File/O_ptions"),
				N_("/File/Print Settings"),
				N_("/File/About"),
				N_("/File/_Quit"),
				N_("/HF/"),
				N_("/_HF"),
				N_("/HF/_Craters"),
				N_("/HF/Fill"),
				N_("/HF/_Fold"),
				N_("/HF/Gaussian _Hill"),
				N_("/HF/_Linear Scale"),
				N_("/HF/Mirror"),
				N_("/HF/Rotate"),
				N_("/HF/Ro_ughen&Smooth"),
				N_("/HF/Terrace"),
				N_("/HF/_Transform"),
				N_("/HF/Clone"),
				N_("/HF/Contour Line Map"),
				N_("/HF/Erode"),
				N_("/HF/Flowmap"),
				N_("/HF/_Invert"),
				N_("/HF/Place POV Object"),
				N_("/HF/Rescale"),
				N_("/HF/_Render Options"),
				N_("/View/"),
				N_("/_View"),
				N_("/View/2D Plane"),
				N_("/View/3D Wire"),
				N_("/View/3D Height"),
				N_("/View/3D Light"),
				N_("/View/Fast Wireframe"),
				N_("/View/Auto Rotate"),
				N_("/_Colormap"),
				N_("/Colormap/Color Bands"),
				N_("/Colormap/Desert"),
				N_("/Colormap/Grayscale"),
				N_("/Colormap/RedHot"),
				N_("/Hide"),
				N_("/Show"),
				N_("/Clone"),
				N_("/Close"),
 };
#endif


guint TFWhash (gconstpointer key);			// return hash for key
gint TFWhashcmp (gconstpointer a, gconstpointer b);	// compare 

 
/*
 *  constructor: build the window with an itemfactory, buffered drawing area 
 * 	and colormaps. Store the generated menu in a hash table so we have 
 *	a handy reference later we can use for set_sensitvity calls
 */
TFWindow::TFWindow() : GuiBufferedDrawingArea (),
			d_win (GTK_WINDOW_TOPLEVEL),
       			d_vbox (FALSE, 0),
			d_accelGroup ()
{
	GlobalTrace::trace (GlobalTrace::TRACE_FLOW, "+++ TFWindow\n");

	p_itemFactory = NULL;	
	p_menuHash = NULL;
	p_mNames = NULL;
	p_linearColorMap = p_linearColorMap2 = NULL;
	p_bandColorMap = p_bandColorMap2 = NULL;

	if (TFOptions::s_fixedMenus)
		buildWindowFixedMenu ();
	else
		buildWindowFloatingMenu ();
}


/*
 *  destructor: clean up 
 */
TFWindow::~TFWindow()
{
	this->hide ();
	d_win.hide ();

	delete p_menuHash;
	delete p_linearColorMap;
	delete p_bandColorMap;
	delete [] p_mNames;

	GlobalTrace::trace (GlobalTrace::TRACE_FLOW, "--- TFWindow\n");
}


/*
 *  quit: exit
 */
void TFWindow::quit ()
{
	gtk_exit (0);
}


/*
 *  hide_impl: hide everything there is to hide
 */
//void TFWindow::hide_impl ()
//{
//	d_win.hide ();
//}


/*
 *  show_impl: show everything there is to show 
 */
//void TFWindow::show_impl ()
//{
//	this->realize ();
//	//d_win.show ();
//}


/*
 *  buildWindowFixedMenu: build a TFWindow with the menu contained in a menubar.
 */
void TFWindow::buildWindowFixedMenu ()
{
	GtkStyle		*style; 
	Gtk_Style		Style; 

	p_itemFactory = new Gtk_ItemFactory_MenuBar ("<Main>", d_accelGroup);
	d_win.add (d_vbox);
	style = Style.gtkobj();
	gdk_font_unref (style->font);
	style->font = gdk_font_load ("-*-Helvetica-Medium-R-Normal--*-100-*-*-*-*-*-*");

    	//d_menuBarHandle = static_cast<Gtk_ObjectHandle<Gtk_MenuBar>&> (p_itemFactory->get_menubar_widget(""));
	{
	// uglier than above but without compiler warning 
	Gtk_ObjectHandle<Gtk_MenuBar> a(p_itemFactory->get_menubar_widget(""));
    	d_menuBarHandle = a;
	}

	SanityCheck::bailout ((!d_menuBarHandle.get_object()), "d_menuBarHandle.get_object failed", "TFWindow::TFWindow");
	d_menuBarHandle->push_style (Style);

	addMenus ();

	d_vbox.pack_start(*d_menuBarHandle, FALSE, FALSE, 0);

	// create and attach drawing area 
	d_vbox.pack_start (*this, TRUE, TRUE, 0);

	allocColormaps ();

	// catch destroy event
	connect_to_method (destroy, this, &TFWindow::quit);

	d_win.show ();
	d_win.set_policy (FALSE, FALSE, FALSE);
	d_vbox.show();
	d_menuBarHandle->show();
	this->show();

	// since Gtk-- 0.11.0 this has to be done here in order to properly 
	// size the window when staring without loading a height field. 
	//this->set_usize (400, 400);
	this->setSize (400, 400);
	this->show ();
}


/*
 *  buildWindowFloatingMenu: build a TFWindow with a popup menu
 */
void TFWindow::buildWindowFloatingMenu ()
{
	GtkStyle		*style; 
	Gtk_Style		Style; 

	p_itemFactory = new Gtk_ItemFactory_Menu ("<Main>", d_accelGroup);
	d_win.add (d_vbox);
	style = Style.gtkobj();
	gdk_font_unref (style->font);
	style->font = gdk_font_load ("-*-Helvetica-Medium-R-Normal--*-100-*-*-*-*-*-*");

	{
	// uglier than above but without compiler warning 
	Gtk_ObjectHandle<Gtk_Menu> a(p_itemFactory->get_menu_widget(""));
    	d_menuHandle = a;
	}

	SanityCheck::bailout ((!d_menuHandle.get_object()), "d_menuHandle.get_object failed", "TFWindow::TFWindow");
	d_menuHandle->push_style (Style);

	addMenus ();

	// create and attach drawing area 
	d_vbox.pack_start (*this, TRUE, TRUE, 0);

	allocColormaps ();

	// catch destroy event
	connect_to_method (destroy, this, &TFWindow::quit);

	d_win.show ();
	d_win.set_policy (FALSE, FALSE, FALSE);
	d_vbox.show();
	this->show();

	// since Gtk-- 0.11.0 this has to be done here in order to properly 
	// size the window when staring without loading a height field. 
	//this->set_usize (400, 400);
	this->setSize (400, 400);
	this->show ();
}


/*
 *  addMenus: build up the itemFactory by adding the individual menus
 */
void TFWindow::addMenus ()
{
	char					*s, *t;
	Gtk_ObjectHandle<Gtk_CheckMenuItem>	defaultView;
	string					defaultKey (_(MENU_VIEW_3DWIRE));

	t = new char[80];
	p_menuHash = new Glib_Hash (TFWhash, TFWhashcmp);
	p_mNames = new char*[50];
	d_nameCount = 0;

	// 
	// Build File menu
	//
	s = p_mNames[d_nameCount++] = strdup (_(MENU_FILE_BRANCH));
	p_menuHash->insert (s, p_itemFactory->create_item (s, TFWindow::buildAccel(MENU_FILE_BRANCH, ACCEL_TYPE_ALT, t), "<Branch>", 0));

	s = p_mNames[d_nameCount++] = strdup (_(MENU_FILE_NEW_BRANCH));
	p_menuHash->insert (s, p_itemFactory->create_item (s, 0, "<Branch>", 0));
	s = p_mNames[d_nameCount++] = strdup (_(MENU_FILE_NEW_SYNTHESIS));
	p_menuHash->insert (s, p_itemFactory->create_item (s, TFWindow::buildAccel(s, ACCEL_TYPE_CNTRL, t), "", 
		ItemFactoryConnector<TFWindow, string>(this,&TFWindow::fileMenuCallback, s)));
	s = p_mNames[d_nameCount++] = strdup (_(MENU_FILE_NEW_SUBDIVIDE));
	p_menuHash->insert (s, p_itemFactory->create_item (s, TFWindow::buildAccel(s, ACCEL_TYPE_CNTRL, t), "", 
		ItemFactoryConnector<TFWindow, string>(this,&TFWindow::fileMenuCallback, s)));
	p_itemFactory->create_item (_(MENU_FILE_NEW_SEP), 0, "<Separator>", 0);
	s = p_mNames[d_nameCount++] = strdup (_(MENU_FILE_NEW_RANDOM));
	p_menuHash->insert (s, p_itemFactory->create_item (s, TFWindow::buildAccel(s, ACCEL_TYPE_CNTRL, t), "", 
		ItemFactoryConnector<TFWindow, string>(this,&TFWindow::fileMenuCallback, s)));

	s = p_mNames[d_nameCount++] = strdup (_(MENU_FILE_OPEN));
	p_menuHash->insert (s, p_itemFactory->create_item (s, TFWindow::buildAccel(s, ACCEL_TYPE_CNTRL, t), "", 
	    ItemFactoryConnector<TFWindow, string>(this,&TFWindow::fileMenuCallback, s)));
	s = p_mNames[d_nameCount++] = strdup (_(MENU_FILE_MERGE));
	p_menuHash->insert (s, p_itemFactory->create_item (s, TFWindow::buildAccel(s, ACCEL_TYPE_CNTRL, t), "", 
	    ItemFactoryConnector<TFWindow, string>(this,&TFWindow::fileMenuCallback, s)));
	s = p_mNames[d_nameCount++] = strdup (_(MENU_FILE_RELOAD));
	p_menuHash->insert (s, p_itemFactory->create_item (s, TFWindow::buildAccel(s, ACCEL_TYPE_CNTRL, t), "",
	    ItemFactoryConnector<TFWindow, string>(this,&TFWindow::fileMenuCallback, s)));
	s = p_mNames[d_nameCount++] = strdup (_(MENU_FILE_SAVE));
	p_menuHash->insert (s, p_itemFactory->create_item (s, TFWindow::buildAccel(s, ACCEL_TYPE_CNTRL, t), "",
	    ItemFactoryConnector<TFWindow, string>(this,&TFWindow::fileMenuCallback, s)));
	s = p_mNames[d_nameCount++] = strdup (_(MENU_FILE_SAVEAS));
	p_menuHash->insert (s, p_itemFactory->create_item (s , TFWindow::buildAccel(s, ACCEL_TYPE_CNTRL, t), "",
	    ItemFactoryConnector<TFWindow, string>(this,&TFWindow::fileMenuCallback, s)));
	s = p_mNames[d_nameCount++] = strdup (_(MENU_FILE_CLOSE));
	p_menuHash->insert (s, p_itemFactory->create_item (s, TFWindow::buildAccel(s, ACCEL_TYPE_CNTRL, t), "",
	    ItemFactoryConnector<TFWindow, string>(this,&TFWindow::fileMenuCallback, s)));

	p_itemFactory->create_item (_(MENU_FILE_SEP), 0, "<Separator>", 0);

	s = p_mNames[d_nameCount++] = strdup (_(MENU_FILE_EXPORT_BRANCH));
	p_menuHash->insert (s, p_itemFactory->create_item (s, 0, "<Branch>", 0));
#ifdef HAVE_OPENGL
	s = p_mNames[d_nameCount++] = strdup (_(MENU_FILE_EXPORT_OPENGL));
	p_menuHash->insert (s, p_itemFactory->create_item (s, TFWindow::buildAccel(s, ACCEL_TYPE_CNTRL, t), "", 
		ItemFactoryConnector<TFWindow, string>(this,&TFWindow::fileMenuCallback, s)));
#endif
	s = p_mNames[d_nameCount++] = strdup (_(MENU_FILE_EXPORT_POVRAY));
	p_menuHash->insert (s, p_itemFactory->create_item (s, TFWindow::buildAccel(s, ACCEL_TYPE_CNTRL, t), "", 
		ItemFactoryConnector<TFWindow, string>(this,&TFWindow::fileMenuCallback, s)));

	p_itemFactory->create_item (_(MENU_FILE_SEP), 0, "<Separator>", 0);

	s = p_mNames[d_nameCount++] = strdup (_(MENU_FILE_OPTIONS));
	p_menuHash->insert (s, p_itemFactory->create_item (s, TFWindow::buildAccel(s, ACCEL_TYPE_CNTRL, t), "", 
	    ItemFactoryConnector<TFWindow, string>(this,&TFWindow::fileMenuCallback, s)));
	s = p_mNames[d_nameCount++] = strdup (_(MENU_FILE_PRINT_SETTINGS));
	p_menuHash->insert (s, p_itemFactory->create_item (s, TFWindow::buildAccel(s, ACCEL_TYPE_CNTRL, t), "", 
	    ItemFactoryConnector<TFWindow, string>(this,&TFWindow::fileMenuCallback, s)));
	s = p_mNames[d_nameCount++] = strdup (_(MENU_FILE_ABOUT));
	p_menuHash->insert (s, p_itemFactory->create_item (s, TFWindow::buildAccel(s, ACCEL_TYPE_CNTRL, t), "", 
	    ItemFactoryConnector<TFWindow, string>(this,&TFWindow::fileMenuCallback, s)));
	p_itemFactory->create_item (_(MENU_FILE_SEP), 0, "<Separator>" ,0);
	s = p_mNames[d_nameCount++] = strdup (_(MENU_FILE_QUIT));
	p_menuHash->insert (s, p_itemFactory->create_item (s, TFWindow::buildAccel(s, ACCEL_TYPE_CNTRL, t), "",
	    ItemFactoryConnector<TFWindow, string>(this,&TFWindow::fileMenuCallback, s)));

	// 
	// Build HF menu
	//
	s = p_mNames[d_nameCount++] = strdup (_(MENU_HF_BRANCH));
	p_menuHash->insert (s, p_itemFactory->create_item (s, TFWindow::buildAccel(s, ACCEL_TYPE_ALT, t), "<Branch>", 0));

	s = p_mNames[d_nameCount++] = strdup (_(MENU_HF_CRATERS));
	p_menuHash->insert (s, p_itemFactory->create_item (s, TFWindow::buildAccel(s, ACCEL_TYPE_CNTRL, t), "", 
	    ItemFactoryConnector<TFWindow, string>(this,&TFWindow::hfMenuCallback, s)));
	s = p_mNames[d_nameCount++] = strdup (_(MENU_HF_FILL));
	p_menuHash->insert (s, p_itemFactory->create_item (s, TFWindow::buildAccel(s, ACCEL_TYPE_CNTRL, t), "", 
	    ItemFactoryConnector<TFWindow, string>(this,&TFWindow::hfMenuCallback, s)));
	s = p_mNames[d_nameCount++] = strdup (_(MENU_HF_FOLD));
	p_menuHash->insert (s, p_itemFactory->create_item (s, TFWindow::buildAccel(s, ACCEL_TYPE_CNTRL, t), "",
	    ItemFactoryConnector<TFWindow, string>(this,&TFWindow::hfMenuCallback, s)));
	s = p_mNames[d_nameCount++] = strdup (_(MENU_HF_GAUSS_HILL));
	p_menuHash->insert (s, p_itemFactory->create_item (s, TFWindow::buildAccel(s, ACCEL_TYPE_CNTRL, t), "",
	    ItemFactoryConnector<TFWindow, string>(this,&TFWindow::hfMenuCallback, s)));
	s = p_mNames[d_nameCount++] = strdup (_(MENU_HF_LINSCALE));
	p_menuHash->insert (s, p_itemFactory->create_item (s, TFWindow::buildAccel(s, ACCEL_TYPE_CNTRL, t), "",
	    ItemFactoryConnector<TFWindow, string>(this,&TFWindow::hfMenuCallback, s)));
	s = p_mNames[d_nameCount++] = strdup (_(MENU_HF_MIRROR));
	p_menuHash->insert (s, p_itemFactory->create_item (s, TFWindow::buildAccel(s, ACCEL_TYPE_CNTRL, t), "",
	    ItemFactoryConnector<TFWindow, string>(this,&TFWindow::hfMenuCallback, s)));
	s = p_mNames[d_nameCount++] = strdup (_(MENU_HF_ROTATE));
	p_menuHash->insert (s, p_itemFactory->create_item (s, TFWindow::buildAccel(s, ACCEL_TYPE_CNTRL, t), "",
	    ItemFactoryConnector<TFWindow, string>(this,&TFWindow::hfMenuCallback, s)));
	s = p_mNames[d_nameCount++] = strdup (_(MENU_HF_ROUGHSMOOTH));
	p_menuHash->insert (s, p_itemFactory->create_item (s, TFWindow::buildAccel(s, ACCEL_TYPE_CNTRL, t), "",
	    ItemFactoryConnector<TFWindow, string>(this,&TFWindow::hfMenuCallback, s)));
	s = p_mNames[d_nameCount++] = strdup (_(MENU_HF_TERRACE));
	p_menuHash->insert (s, p_itemFactory->create_item (s, TFWindow::buildAccel(s, ACCEL_TYPE_CNTRL, t), "",
	    ItemFactoryConnector<TFWindow, string>(this,&TFWindow::hfMenuCallback, s)));
	s = p_mNames[d_nameCount++] = strdup (_(MENU_HF_TRANSFORM));
	p_menuHash->insert (s, p_itemFactory->create_item (s, TFWindow::buildAccel(s, ACCEL_TYPE_CNTRL, t), "",
	    ItemFactoryConnector<TFWindow, string>(this,&TFWindow::hfMenuCallback, s)));

	p_itemFactory->create_item (_(MENU_HF_SEP), 0, "<Separator>", 0);

	s = p_mNames[d_nameCount++] = strdup (_(MENU_HF_CLONE));
	p_menuHash->insert (s, p_itemFactory->create_item (s, TFWindow::buildAccel(s, ACCEL_TYPE_CNTRL, t), "", 
	    ItemFactoryConnector<TFWindow, string>(this,&TFWindow::hfMenuCallback, s)));
	s = p_mNames[d_nameCount++] = strdup (_(MENU_HF_EXPORT_CONTOUR));
	p_menuHash->insert (s, p_itemFactory->create_item (s, TFWindow::buildAccel(s, ACCEL_TYPE_CNTRL, t), "", 
	    ItemFactoryConnector<TFWindow, string>(this,&TFWindow::hfMenuCallback, s)));
	s = p_mNames[d_nameCount++] = strdup (_(MENU_HF_ERODE));
	p_menuHash->insert (s, p_itemFactory->create_item (s, TFWindow::buildAccel(s, ACCEL_TYPE_CNTRL, t), "",
	    ItemFactoryConnector<TFWindow, string>(this,&TFWindow::hfMenuCallback, s)));
	s = p_mNames[d_nameCount++] = strdup (_(MENU_HF_FLOWMAP));
	p_menuHash->insert (s, p_itemFactory->create_item (s, TFWindow::buildAccel(s, ACCEL_TYPE_CNTRL, t), "", 
	    ItemFactoryConnector<TFWindow, string>(this,&TFWindow::hfMenuCallback, s)));
	s = p_mNames[d_nameCount++] = strdup (_(MENU_HF_INVERT));
	p_menuHash->insert (s, p_itemFactory->create_item (s, TFWindow::buildAccel(s, ACCEL_TYPE_CNTRL, t), "",
	    ItemFactoryConnector<TFWindow, string>(this,&TFWindow::hfMenuCallback, s)));
	s = p_mNames[d_nameCount++] = strdup (_(MENU_HF_PLACEPOV));
	p_menuHash->insert (s, p_itemFactory->create_item (s, TFWindow::buildAccel(s, ACCEL_TYPE_CNTRL, t), "",
	    ItemFactoryConnector<TFWindow, string>(this,&TFWindow::hfMenuCallback, s)));
	s = p_mNames[d_nameCount++] = strdup (_(MENU_HF_RESCALE));
	p_menuHash->insert (s, p_itemFactory->create_item (s, TFWindow::buildAccel(s, ACCEL_TYPE_CNTRL, t), "",
	    ItemFactoryConnector<TFWindow, string>(this,&TFWindow::hfMenuCallback, s)));

	p_itemFactory->create_item (_(MENU_HF_SEP), 0, "<Separator>", 0);
	s = p_mNames[d_nameCount++] = strdup (_(MENU_HF_RENDER));
	p_menuHash->insert (s, p_itemFactory->create_item (s, TFWindow::buildAccel(s, ACCEL_TYPE_CNTRL, t), "",
	    ItemFactoryConnector<TFWindow, string>(this,&TFWindow::hfMenuCallback, s)));


	// 
	// Build View menu
	//
	s = p_mNames[d_nameCount++] = strdup (_(MENU_VIEW_BRANCH));
	p_menuHash->insert (s, p_itemFactory->create_item (s, TFWindow::buildAccel(s, ACCEL_TYPE_ALT, t), "<Branch>", 0));

	s = p_mNames[d_nameCount++] = strdup (_(MENU_VIEW_2DPLANE));
	p_menuHash->insert (s, p_itemFactory->create_item (s, "<control>1", "<RadioItem>",
	    ItemFactoryConnector<TFWindow, string>(this,&TFWindow::viewMenuCallback, s)));
	s = p_mNames[d_nameCount++] = strdup (_(MENU_VIEW_3DWIRE));
	p_menuHash->insert (s, p_itemFactory->create_item (s, "<control>2", _(MENU_VIEW_2DPLANE),
	    ItemFactoryConnector<TFWindow, string>(this,&TFWindow::viewMenuCallback, s)));
	s = p_mNames[d_nameCount++] = strdup (_(MENU_VIEW_3DHEIGHT));
	p_menuHash->insert (s, p_itemFactory->create_item (s, "<control>3", _(MENU_VIEW_2DPLANE),
	    ItemFactoryConnector<TFWindow, string>(this,&TFWindow::viewMenuCallback, s)));
	s = p_mNames[d_nameCount++] = strdup (_(MENU_VIEW_3DLIGHT));
	p_menuHash->insert (s, p_itemFactory->create_item (s, "<control>4", _(MENU_VIEW_2DPLANE),
	    ItemFactoryConnector<TFWindow, string>(this,&TFWindow::viewMenuCallback, s)));

	p_itemFactory->create_item (_(MENU_VIEW_SEP), 0, "<Separator>", 0);

	s = p_mNames[d_nameCount++] = strdup (_(MENU_VIEW_FASTWIRE));
	p_menuHash->insert (s, p_itemFactory->create_item (s, "<control>5", "<ToggleItem>",
	    ItemFactoryConnector<TFWindow, string>(this,&TFWindow::viewMenuCallback, s)));
	s = p_mNames[d_nameCount++] = strdup (_(MENU_VIEW_AUTOROTATE));
	p_menuHash->insert (s, p_itemFactory->create_item (s, "<control>6", "<ToggleItem>",
	    ItemFactoryConnector<TFWindow, string>(this,&TFWindow::viewMenuCallback, s)));

	// 
	// Build Colormap menu
	//
	s = p_mNames[d_nameCount++] = strdup (_(MENU_CMAP_BRANCH));
	p_menuHash->insert (s, p_itemFactory->create_item (s, TFWindow::buildAccel(s, ACCEL_TYPE_ALT, t), "<Branch>", 0));

	s = p_mNames[d_nameCount++] = strdup (_(MENU_CMAP_COLORBANDS));
	p_menuHash->insert (s, p_itemFactory->create_item (s, "<alt>1", "<RadioItem>", 
	    ItemFactoryConnector<TFWindow, string>(this,&TFWindow::colormapMenuCallback, s)));
	s = p_mNames[d_nameCount++] = strdup (_(MENU_CMAP_DESERT));
	p_menuHash->insert (s, p_itemFactory->create_item (s, "<alt>2", _(MENU_CMAP_COLORBANDS), 
	    ItemFactoryConnector<TFWindow, string>(this,&TFWindow::colormapMenuCallback, s)));
	s = p_mNames[d_nameCount++] = strdup (_(MENU_CMAP_GRAYSCALE));
	p_menuHash->insert (s, p_itemFactory->create_item (s, "<alt>3", _(MENU_CMAP_COLORBANDS),
	    ItemFactoryConnector<TFWindow, string>(this,&TFWindow::colormapMenuCallback, s)));
	s = p_mNames[d_nameCount++] = strdup (_(MENU_CMAP_REDHOT));
	p_menuHash->insert (s, p_itemFactory->create_item (s, "<alt>4", _(MENU_CMAP_COLORBANDS),
	    ItemFactoryConnector<TFWindow, string>(this,&TFWindow::colormapMenuCallback, s)));

	d_win.add_accel_group (d_accelGroup);

	defaultView = p_itemFactory->get_checkmenuitem_widget (defaultKey);
	defaultView->set_active (TRUE);
	delete [] t;
}


/*
 *  allocColormaps: allocate the colormaps 
 */
void TFWindow::allocColormaps ()
{
	// create colormaps
	p_linearColorMap = new GuiColormapLinear (this->get_toplevel(), 255);
	p_linearColorMap->allocColors (225, 0, 0, 0, 1, 1, 1);

	p_linearColorMap2 = new GuiColormapLinear (this->get_toplevel(), 255);
	p_linearColorMap2->allocColors (225, 0, 1, 0, 1, 0, 0);

	p_bandColorMap = new GuiColormapBands (this->get_toplevel(), 15, 15, 4);
	p_bandColorMap->allocColorBands (bandBaseCol); 

	p_bandColorMap2 = new GuiColormapBands (this->get_toplevel(), 6, 15, 1);
	p_bandColorMap2->allocColorBands (bandBaseCol_Desert); 

	d_useLinearColormap = FALSE;
}


/*
 *  fileMenuCallback: default file menu handler
 */
void TFWindow::fileMenuCallback(string m)
{
	if (m == "Exit")
		quit ();
	//cout << "Callback " << m << " caught " << endl;
}


/*
 *  hfMenuCallback: default HF menu handler
 */
void TFWindow::hfMenuCallback(string m)
{
	//cout << "Callback " << m << " caught " << endl;
}


/*
 *  viewMenuCallback: default view menu handler
 */
void TFWindow::viewMenuCallback(string m)
{
	//cout << "Callback " << m << " caught " << endl;
}


/*
 *  colormapMenuCallback: default colormap menu handler
 */
void TFWindow::colormapMenuCallback(string m)
{
	//cout << "Callback " << m << " caught " << endl;
}



/*
 *  setSize: set the size of all the relevant widgets depending on the 
 * 	menu mode used. 
 */
void TFWindow::setSize (int x, int y)
{
	if ((this->width() != x) || (this->height() != y))
		{
		if (TFOptions::s_fixedMenus)
			d_win.set_usize (x, y+d_menuBarHandle->height());
		else
			d_win.set_usize (x, y);
		this->setUsize (x, y);

		d_win.show ();
		this->show();
		gdk_flush ();

		Gtk_Main *gtkMain = Gtk_Main::instance();
		while (gtkMain->events_pending())
			gtkMain->iteration ();
		}
}


/*
 *  buildAccel: the a menu name and extract the accerlator key by 
 * 	searching for the underscore (_) marker. 
 * 
 * 	accelType denotes the mod key used: 
 *		'a'		ALT
 *		'c'		CNTRL
 * 	MenuDefs.h defines these as ACCEL_TYPE_*
 */
char *TFWindow::buildAccel (char *menu, char accelType, char *s)
{
	SanityCheck::bailout ((!menu), "menu==NULL", "TFWindow::buildAccel");
	SanityCheck::bailout ((!s), "s==NULL", "TFWindow::buildAccel");

	//if (!accelType)
	//	return NULL;

	char 	*accelKey = menu;
	char	*accel = s;

	while (*accelKey)
		{
		if (*accelKey == '_')
			{
			accelKey++;		// advance to accelrator key
			break;
			}
		accelKey++;
		}

	if (! (*accelKey))			// no accelerator found
		return NULL;

	strcpy (accel, "");
	if (accelType == 'a')
		sprintf (accel, "<alt>%c", toupper(*accelKey));
	else
	if (accelType == 'c')
		sprintf (accel, "<control>%c", toupper(*accelKey));
	else
		SanityCheck::bailout ((TRUE), "accelType out of Range", "TFWindow::buildAccel");

	//printf ("Menu = %s,   Accel = %s\n", menu, accel);
	if (strlen(accel))
		return accel;
	else	
		return NULL;
}


guint TFWhash (gconstpointer key)
{
	char 	*s = (char *)key;
	int	i, v=0,
		l=strlen(s);

	for (i=0; i<l; i++)
		v = (64*v + s[i])%101;

	return (v);
}


gint TFWhashcmp (gconstpointer a, gconstpointer b)
{
	return (!strcmp((char *)a,(char *)b));
}


