/* Terraform - (C) 1997-2000 Robert Gasch (r.gasch@chello.nl)
 *  - http://212.187.12.197/RNG/terraform/
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "TFDialogCraters.h"
#include "TFOptions.h"
#include "GlobalDefs.h"
#include "GlobalSanityCheck.h"
#include "GlobalTrace.h"
#include "GuiDialogOAC.h"
#include "MathTrig.h"
#include "MathRandom.h"


/*
 *  constructor: initialize all data members 
 */
TFDialogCraters::TFDialogCraters (HeightField *HF, HeightFieldDraw *HFD)
	        : TFPreviewDialog (HF, HFD, "Terraform Crater Dialog", 
					"Parameters", 6, 8),
		  d_vbList (TRUE, 0),
		  d_hbCX (TRUE, 5),
		  d_hbCY (TRUE, 5),
		  d_hbNumCraters (TRUE, 5),
		  d_hbRadius (TRUE, 5),
		  d_hbHeight (TRUE, 5),
		  d_hbCraterCoverage (TRUE, 5),
		  d_hbWrap (TRUE, 5),
		  d_hbGenSeed (TRUE, 5),
		  d_hbSeed (FALSE, 0),
		  d_frmOptions (_("Crater Options"))
{
	GlobalTrace::trace (GlobalTrace::TRACE_FLOW, "+++ TFDialogCraters\n");
	p_seedInitStr = new char [40];
	d_lastPreviewSeed = -1;
	p_adjCX = new Gtk_Adjustment (0.5, 0, 1, 0.01);
	p_adjCY = new Gtk_Adjustment (0.5, 0, 1, 0.01);
	p_adjNumCraters = new Gtk_Adjustment (20, 1, (TFOptions::s_large ? 1000 : 100), 0.01);
	p_adjRadius = new Gtk_Adjustment (0.33, 0, 3, 0.01);
	p_adjHeight = new Gtk_Adjustment (0.33, 0, 2, 0.01);
	p_adjCraterCoverage = new Gtk_Adjustment (0.15, 0.01, 0.5, 0.01);

	p_hsCX = new Gtk_HScale (*p_adjCX);
	p_hsCY = new Gtk_HScale (*p_adjCY);
	p_hsNumCraters = new Gtk_HScale (*p_adjNumCraters);
	p_hsRadius = new Gtk_HScale (*p_adjRadius);
	p_hsHeight = new Gtk_HScale (*p_adjHeight);
	p_hsCraterCoverage = new Gtk_HScale (*p_adjCraterCoverage);

	p_lblCX = new Gtk_Label (_("Center X"));
	p_lblCY = new Gtk_Label (_("Center Y"));
	p_lblNumCraters = new Gtk_Label (_("Number of Craters"));
	p_lblRadius = new Gtk_Label (_("Crater Radius"));
	p_lblHeight = new Gtk_Label (_("Crater Height"));
	p_lblCraterCoverage = new Gtk_Label (_("CraterCoverage"));
	p_lblWrap = new Gtk_Label (_("Wrap"));
	p_lblGenSeed = new Gtk_Label (_("Generate new seed"));
	p_lblSeed = new Gtk_Label (_("Specify Seed"));

	buildDialogWindow ();
	this->setHFobjs (HF, HFD);
	sprintf (this->p_windowTitle, _("Craters: %s"), p_HF->getName());
	this->set_title (this->p_windowTitle);
	this->iterateEvents ();
	adjNumCratersCallback (); 	// calls updatePreviewCallback()

	connect_to_method (p_adjCX->value_changed, this, &TFDialogCraters::updatePreviewCallback);
	connect_to_method (p_adjCY->value_changed, this, &TFDialogCraters::updatePreviewCallback);
	connect_to_method (p_adjNumCraters->value_changed, this, &TFDialogCraters::adjNumCratersCallback);
	connect_to_method (p_adjRadius->value_changed, this, &TFDialogCraters::updatePreviewCallback);
	connect_to_method (p_adjHeight->value_changed, this, &TFDialogCraters::updatePreviewCallback);
	connect_to_method (p_adjCraterCoverage->value_changed, this, &TFDialogCraters::updatePreviewCallback);
	connect_to_method (d_btnWrap.clicked, this, &TFDialogCraters::updatePreviewCallback);
	connect_to_method (d_btnGenSeed.clicked, this, &TFDialogCraters::seedCheckboxCallback);
}


/*
 *  destructor: clean up 
 */
TFDialogCraters::~TFDialogCraters ()
{
	delete [] p_seedInitStr;

	delete p_adjCX;
	delete p_adjCY;
	delete p_adjNumCraters;
	delete p_adjRadius;
	delete p_adjHeight;
	delete p_adjCraterCoverage;

	delete p_hsCX;
	delete p_hsCY;
	delete p_hsNumCraters;
	delete p_hsRadius;
	delete p_hsHeight;
	delete p_hsCraterCoverage;

	delete p_lblCX;
	delete p_lblCY;
	delete p_lblNumCraters;
	delete p_lblRadius;
	delete p_lblHeight;
	delete p_lblCraterCoverage;
	delete p_lblWrap;
	delete p_lblGenSeed;
	delete p_lblSeed;
	GlobalTrace::trace (GlobalTrace::TRACE_FLOW, "--- TFDialogCraters\n");
}


/*
 *  insertOptions: fill the dialog's VBox
 */
void TFDialogCraters::insertOptions ()
{
	d_frmOptions.set_shadow_type (GTK_SHADOW_ETCHED_IN);
	d_frmOptions.set_border_width (5);

	d_hbCX.pack_start (*p_lblCX, TRUE, TRUE, GuiDialogOAC::s_HBOff);
	p_lblCX->show ();
	p_hsCX->set_update_policy (GTK_UPDATE_CONTINUOUS);
	p_hsCX->set_digits (2);
	p_hsCX->set_draw_value (TRUE);
	d_hbCX.pack_end (*p_hsCX, TRUE, TRUE, GuiDialogOAC::s_HBOff);
	p_hsCX->show ();
	d_vbList.pack_start (d_hbCX, TRUE, TRUE, GuiDialogOAC::s_VBOff);
	d_hbCX.show ();

	d_hbCY.pack_start (*p_lblCY, TRUE, TRUE, GuiDialogOAC::s_HBOff);
	p_lblCY->show ();
	p_hsCY->set_update_policy (GTK_UPDATE_CONTINUOUS);
	p_hsCY->set_digits (2);
	p_hsCY->set_draw_value (TRUE);
	d_hbCY.pack_end (*p_hsCY, TRUE, TRUE, GuiDialogOAC::s_HBOff);
	p_hsCY->show ();
	d_vbList.pack_start (d_hbCY, TRUE, TRUE, GuiDialogOAC::s_VBOff);
	d_hbCY.show ();

	d_vbList.pack_start (d_hSep);
	d_hSep.show ();

	d_hbNumCraters.pack_start (*p_lblNumCraters, TRUE, TRUE, GuiDialogOAC::s_HBOff);
	p_lblNumCraters->show ();
	p_hsNumCraters->set_update_policy (GTK_UPDATE_CONTINUOUS);
	p_hsNumCraters->set_digits (0);
	p_hsNumCraters->set_draw_value (TRUE);
	d_hbNumCraters.pack_end (*p_hsNumCraters, TRUE, TRUE, GuiDialogOAC::s_HBOff);
	p_hsNumCraters->show ();
	d_vbList.pack_start (d_hbNumCraters, TRUE, TRUE, GuiDialogOAC::s_VBOff);
	d_hbNumCraters.show ();

	d_hbRadius.pack_start (*p_lblRadius, TRUE, TRUE, GuiDialogOAC::s_HBOff);
	p_lblRadius->show ();
	p_hsRadius->set_update_policy (GTK_UPDATE_CONTINUOUS);
	p_hsRadius->set_digits (2);
	p_hsRadius->set_draw_value (TRUE);
	d_hbRadius.pack_end (*p_hsRadius, TRUE, TRUE, GuiDialogOAC::s_HBOff);
	p_hsRadius->show ();
	d_vbList.pack_start (d_hbRadius, TRUE, TRUE, GuiDialogOAC::s_VBOff);
	d_hbRadius.show ();

	d_hbHeight.pack_start (*p_lblHeight, TRUE, TRUE, GuiDialogOAC::s_HBOff);
	p_lblHeight->show ();
	p_hsHeight->set_update_policy (GTK_UPDATE_CONTINUOUS);
	p_hsHeight->set_digits (2);
	p_hsHeight->set_draw_value (TRUE);
	d_hbHeight.pack_end (*p_hsHeight, TRUE, TRUE, GuiDialogOAC::s_HBOff);
	p_hsHeight->show ();
	d_vbList.pack_start (d_hbHeight, TRUE, TRUE, GuiDialogOAC::s_VBOff);
	d_hbHeight.show ();

	d_hbCraterCoverage.pack_start (*p_lblCraterCoverage, TRUE, TRUE, GuiDialogOAC::s_HBOff);
	p_lblCraterCoverage->show ();
	p_hsCraterCoverage->set_update_policy (GTK_UPDATE_CONTINUOUS);
	p_hsCraterCoverage->set_digits (2);
	p_hsCraterCoverage->set_draw_value (TRUE);
	d_hbCraterCoverage.pack_end (*p_hsCraterCoverage, TRUE, TRUE, GuiDialogOAC::s_HBOff);
	p_hsCraterCoverage->show ();
	d_vbList.pack_start (d_hbCraterCoverage, TRUE, TRUE, GuiDialogOAC::s_VBOff);
	d_hbCraterCoverage.show ();

	d_hbWrap.pack_start (*p_lblWrap, TRUE, TRUE, GuiDialogOAC::s_HBOff);
	p_lblWrap->show ();
	d_hbWrap.pack_end (d_btnWrap, TRUE, TRUE, GuiDialogOAC::s_HBOff);
	d_btnWrap.show ();
	d_vbList.pack_start (d_hbWrap, TRUE, TRUE, GuiDialogOAC::s_VBOff);
	d_hbWrap.show ();

	d_vbList.pack_start (d_hSepSeed);
	d_hSepSeed.show ();

	// random seed parameters
	d_hbGenSeed.pack_start (*p_lblGenSeed, TRUE, TRUE, GuiDialogOAC::s_HBOff);
	p_lblGenSeed->show ();
	d_hbGenSeed.pack_end (d_btnGenSeed, TRUE, TRUE, GuiDialogOAC::s_HBOff);
	d_btnGenSeed.set_active (TRUE);
	d_btnGenSeed.show ();
	d_vbList.pack_start (d_hbGenSeed, TRUE, TRUE, GuiDialogOAC::s_VBOff);
	d_hbGenSeed.show ();

	p_lblSeed->set_justify (GTK_JUSTIFY_RIGHT);
	d_hbSeed.pack_start (*p_lblSeed, TRUE, TRUE, GuiDialogOAC::s_HBOff);
	p_lblSeed->set_sensitive (FALSE);
	p_lblSeed->show ();

	MathRandom	*mRand = new MathRandom ();
	sprintf (p_seedInitStr, "%d", (int)mRand->rnd());
	delete mRand;
	d_enSeed.set_text (p_seedInitStr);
	d_enSeed.set_sensitive (FALSE);
	d_hbSeed.pack_end (d_enSeed, TRUE, TRUE, GuiDialogOAC::s_HBOff);
	d_enSeed.show ();

	d_vbList.pack_start (d_hbSeed, TRUE, TRUE, GuiDialogOAC::s_VBOff);
	d_hbSeed.show ();


	d_frmOptions.add (d_vbList);
	this->p_tblMain->attach (d_frmOptions, 3, 6, 1, 7);
        d_vbList.show ();
	d_frmOptions.show ();
        this->p_frmBase->show ();
        this->get_vbox()->show ();
}



void TFDialogCraters::buildDialogWindow ()
{
	this->set_usize (450, 450);
	this->set_title (this->p_windowTitle);

	this->get_vbox()->set_border_width (2);

	this->setupVBox ();
	this->insertPreview ();
	insertOptions ();
	this->fillActionArea ();

	connect_to_method (p_drawArea->button_press_event, this, 
			&TFDialogCraters::daButtonPressedCallback);
	
	this->show ();
}


void TFDialogCraters::seedCheckboxCallback ()
{
	bool	status=d_enSeed.is_sensitive ();

	p_lblSeed->set_sensitive (!status);
	d_enSeed.set_sensitive (!status);
}


/*
 *  buttonCallbackApply: roughen the Height Field
 */
void TFDialogCraters::buttonCallbackApply ()
{
	float			cx, cy, nc, radius, height, craterCoverage;
	int			seed;
	bool			wrap;

	cx = p_adjCX->get_value ();
	cy = p_adjCY->get_value ();
        nc = p_adjNumCraters->get_value ();
        radius = p_adjRadius->get_value (); 
        height = p_adjHeight->get_value (); 
        craterCoverage = p_adjCraterCoverage->get_value (); 
	wrap = d_btnWrap.get_active ();

	if (d_btnGenSeed.get_active())
		{
		MathRandom      *mRand = new MathRandom ();

		seed = (int) (mRand->rnd()*G_MAXINT);
		sprintf (p_seedInitStr, "%d", seed);
		d_enSeed.set_text (p_seedInitStr);
		delete mRand;
		}
	else
		{
		char *s = const_cast<char*>(d_enSeed.get_text().c_str());
		seed = atoi (s);
		}

	SanityCheck::bailout ((!p_HFO), "p_HFO==NULL", "TFDialogCraters::buttonCallbackApply");
	if (p_adjNumCraters->get_value() == 1.0)
		p_HFO->distributeCraters (nc, wrap, height, radius, craterCoverage, seed, cx, cy);
	else
		p_HFO->distributeCraters (nc, wrap, height, radius, craterCoverage, seed);
	p_HFD->draw ();

	// only do this if window stays open 
	if (b_applyHit)
		{
		this->setHFobjs (p_HF, p_HFD);
		updatePreviewCallback ();
		}

	d_lastPreviewSeed = -1;
	this->b_applyHit = TRUE;
}


/*
 *  updatePreviewCallback: update the preview after a slider has been updated.
 */
void TFDialogCraters::updatePreviewCallback ()
{
	if (!d_cbUsePreview.get_active())
		return;

	float		cx, cy, nc, radius, height, craterCoverage;
	int		seed;
	bool		wrap;

	cx = p_adjCX->get_value ();
	cy = p_adjCY->get_value ();
        nc = p_adjNumCraters->get_value ();
        radius = p_adjRadius->get_value (); 
        height = p_adjHeight->get_value (); 
        craterCoverage = p_adjCraterCoverage->get_value (); 
	wrap = d_btnWrap.get_active ();

	if (wrap)
		nc = 1-(nc-1);

	if (d_btnGenSeed.get_active())
		{
		if (d_lastPreviewSeed == -1)
			{
			MathRandom      *mRand = new MathRandom ();

			seed = d_lastPreviewSeed = (int) (mRand->rnd()*G_MAXINT);
			sprintf (p_seedInitStr, "%d", seed);
			d_enSeed.set_text (p_seedInitStr);
			delete mRand;
			}
		else
			seed = d_lastPreviewSeed;
		}
	else
		{
		char *s = const_cast<char*>(d_enSeed.get_text().c_str());
		seed = d_lastPreviewSeed = atoi (s);
		}

	SanityCheck::bailout ((!p_HFPreview), "p_HFPreview==NULL", "TFDialogCraters::updatePreviewCallback");
	SanityCheck::bailout ((!p_HFOPreview), "p_HFOPreview==NULL", "TFDialogCraters::updatePreviewCallback");
	SanityCheck::bailout ((!p_HFDPreview), "p_HFOPreview==NULL", "TFDialogCraters::updatePreviewCallback");
	this->previewUpToDate ();
	p_HFPreview->restoreBackup ();
	if (p_adjNumCraters->get_value() == 1.0)
		p_HFOPreview->distributeCraters (nc, wrap, height, radius, craterCoverage, seed, cx, cy);
	else
		p_HFOPreview->distributeCraters (nc, wrap, height, radius, craterCoverage, seed);
	p_HFDPreview->setColormap (p_HFD->getColormap());
	p_HFDPreview->draw ();
	d_cx = (int)(cx*(float)p_drawArea->width()); 
	d_cy = (int)(cy*(float)p_drawArea->height()); 
	if (p_adjNumCraters->get_value() == 1.0)
		this->drawCrosshairs (d_cx, d_cy);
}


/*
 *  daButtonPressedCallback: update the preview p_drawArea and adjustment 
 * 	the appropriate widgets (done when the user clicks on the preview)
 */
int TFDialogCraters::daButtonPressedCallback (GdkEventButton *e)
{
	if (!d_cbUsePreview.get_active())
		return 1;

	if (p_adjNumCraters->get_value() != 1.0)
		return 1;

	int	w = this->p_drawArea->width(),
		h = this->p_drawArea->height();

	if (e->button == 1)
		{
		p_adjCX->set_value (e->x/w);
		p_adjCY->set_value (e->y/h);
		}
	else
	if (e->button == 3)
		{
		float	d = MathTrig::distance (p_adjCX->get_value()*w, 
				p_adjCY->get_value()*h, e->x, e->y);

		d/=((p_drawArea->width()+p_drawArea->height())/2);
		if (d > 1)
			d=1;
		p_adjRadius->set_value (d); 
		}
	updatePreviewCallback ();
	return 0;
}



/*
 *  adjNumCratersCallback: (de)activate when NumCrates slider==1 or when 
 * 	it was 1 and is now a different value
 */
void TFDialogCraters::adjNumCratersCallback ()
{
	if (p_adjNumCraters->get_value() == 1.0)
		{
		if (!p_lblCX->is_sensitive())
			{
			p_lblCX->set_sensitive (TRUE);
			p_lblCY->set_sensitive (TRUE);
			p_hsCX->set_sensitive (TRUE);
			p_hsCY->set_sensitive (TRUE);
			}
		}
	else
	if (p_lblCX->is_sensitive())
		{
		p_lblCX->set_sensitive (FALSE);
		p_lblCY->set_sensitive (FALSE);
		p_hsCX->set_sensitive (FALSE);
		p_hsCY->set_sensitive (FALSE);
		}
	updatePreviewCallback ();
}



/*
 *  (overloaded virtual) checkboxCallbackPreview: process the 'use preview' 
 * 	checkbox. This is a special case to only draw crosshairs when 
 * 	number of craters == 1
 */
void TFDialogCraters::checkboxCallbackPreview ()
{
	if (!d_cbUsePreview.get_active())
		{
		p_HFPreview->restoreBackup ();
		p_HFDPreview->draw ();
		}
	else
		{
		SanityCheck::bailout ((!p_HFDPreview), "HFDPreview==NULL", 
				"GuiDialogPreview::checkboxCallbackPreview");
		p_drawArea->set_sensitive (TRUE);	
		updatePreviewCallback ();
		p_HFDPreview->draw ();
		if ( (d_cx!=-1) && (d_cy!=-1) && p_adjNumCraters->get_value()==1)
			drawCrosshairs (d_cx, d_cy);
		}
}


