/***************************************************************************
                          rparameterdialog.cpp  -  description
                             -------------------
    begin                : Mon Sep 27 1999
    copyright            : (C) 1999 by Andreas Mustun
    email                : andrew@ribbonsoft.com
 ***************************************************************************/


/****************************************************************************
** RParameterDialog.cpp 1998/09/03 A. Mustun RibbonSoft
**
** Copyright (C) 1998 RibbonSoft.  All rights reserved.
**
*****************************************************************************/


#include <string.h>

#include <qapplication.h>
#include <qkeycode.h>
#include <qlayout.h>
#include <qstring.h>

#include "rconfig.h"
#include "rparameterdialog.h"
#include "rlabel.h"
#include "rlineedit.h"
#include "rlog.h"
#include "rprgdef.h"
#include "rpushbutton.h"
#include "rstring.h"

#define DEF_MAXENTRIES 6

// Constructor:
//
RParameterDialog::RParameterDialog(QWidget* _parent, 
                                   const char* _title, 
                                   QPixmap& _pixmap)
  :QDialog(_parent, _title, true, WStyle_NormalBorder)
{
  setCaption(_title);

  setFixedSize(DEF_PARAMDLG_WIDTH, DEF_PARAMDLG_HEIGHT);
  
  gl = new QGridLayout(this, DEF_MAXENTRIES+2, 4, 8, 0);
  for(int i=0; i<DEF_MAXENTRIES+2; ++i) {
    gl->setRowStretch(i, 1);
  }
  
  gl->setColStretch(0, 17);
  gl->setColStretch(1, 8);
  gl->setColStretch(2, 8);
  gl->setColStretch(3, 8);
  
  
  RLabel* pixmap = new RLabel(this);
  pixmap->setPixmap(_pixmap);
  gl->addMultiCellWidget(pixmap, 0, DEF_MAXENTRIES+1, 0, 0);

  bOk = new RPushButton(RMES(46), this);
  bOk->setAccel(Key_Return);
  gl->addWidget(bOk, DEF_MAXENTRIES+1, 2);
  connect(bOk, SIGNAL(clicked()), SLOT(accept()));
  
  bCancel = new RPushButton(RMES(47), this);
  bCancel->setAccel(Key_Escape);
  gl->addWidget(bCancel, DEF_MAXENTRIES+1, 3);
  connect(bCancel, SIGNAL(clicked()), SLOT(reject()));

  /*
  bHelp = new RPushButton(RMES(48), this);
  bHelp->setAccel(Key_F1);
  gl->addWidget(bHelp, DEF_MAXENTRIES+1, 3);
  */
  
  lLabel.setAutoDelete(true);
  eInput.setAutoDelete(true);
  
  insertPos=0;

}



// Destructor:
//
RParameterDialog::~RParameterDialog()
{

}



// Add an input with a char* as default value:
//
void 
RParameterDialog::addEntry(const char* _mes, const char* _val)
{
  RLabel* label = new RLabel(_mes, this);
  label->setAlignment(AlignRight|AlignVCenter);
  gl->addMultiCellWidget(label, insertPos+1, insertPos+1, 1, 2);
  lLabel.append(label);

  RLineEdit* input = new RLineEdit(this);
  input->setText(_val);
  gl->addWidget(input, insertPos+1, 3);
  eInput.append(input);
  if(insertPos<DEF_MAXENTRIES) ++insertPos;
}



// Add an input with an int as default value:
//
void 
RParameterDialog::addEntry(const char* _mes, int _val)
{
  char val[256];
  sprintf(val, "%d", _val);
  addEntry(_mes, val);
}



// Add an input with a float as default value:
//
void 
RParameterDialog::addEntry(const char* _mes, float _val)
{
  char val[256];
  strncpy(val, strFloatToString(_val).latin1(), 255);
  addEntry(_mes, val);
}



// Get the input in field _index as a string:
//
const char*
RParameterDialog::getStringInput(int _index)
{
  if(_index>=0 && _index<(int)eInput.count()) {
  
    RLOG("\nStringInput at ");
    RLOG(_index);
    RLOG(" is ");
    RLOG(eInput.at(_index)->text());
    
    return eInput.at(_index)->text();
  }
  else {
    return 0;
  }
}



// Get the input in field _index as an int:
//
int
RParameterDialog::getIntInput(int _index)
{
  QCString val=getStringInput(_index);
  
  if(!val.isEmpty()) {
  
    RLOG("\nIntInput at ");
    RLOG(_index);
    RLOG(" is ");
    RLOG(val.toInt());
    
    return val.toInt();
  }
  else {
    return 0;
  }
}



// Get the input in field _index as a float:
//
float
RParameterDialog::getFloatInput(int _index)
{
  QCString val=getStringInput(_index);
  
  if(!val.isEmpty()) {
    return val.toFloat();
  }
  else {
    return 0;
  }
}



// EOF3


