/***************************************************************************
                          rfontdialog.h  -  description
                             -------------------
    begin                : Mon Sep 27 1999
    copyright            : (C) 1999 by Andreas Mustun
    email                : andrew@ribbonsoft.com
 ***************************************************************************/

/****************************************************************************
** rfontdialog.h 1998/12/24 A. Mustun RibbonSoft
**
** Copyright (C) 1998 RibbonSoft.  All rights reserved.
**
*****************************************************************************/

#ifndef RFONTDIALOG_H
#define RFONTDIALOG_H

#include <qdialog.h>

#include "rgraphdef.h"

class RButtonGroup;
class RCheckBox;
class QFrame;
class QGridLayout;
class RGroupBox;
class RLabel;
class QRadioButton;
class RToolButton;

class RComboBox;
class RGraphic;
class RLineEdit;
class RMultiLineEdit;

class RFontDialog : public QDialog
{
  Q_OBJECT
public:
  RFontDialog(RGraphic* _graphic=0,
              QWidget* _parent=0,
              const char* _name=0);
  ~RFontDialog();

  bool setDataFromGraphic();

  QString getText() { return text; }
  void    setText(const char* _text);

private slots:
  void proportional(bool _on);
  void fixedWidth(bool _on);
  void fontChanged(int);
  void adjustValuesToTextHeight(const QString&);
  
  void clearText();
  void loadText();
  void saveText();
  
  void cutText();
  void copyText();
  void pasteText();

protected slots:
  void accept();

protected:
  void resizeEvent(QResizeEvent *_ev);
  void moveEvent(QMoveEvent *_ev);

private:
  RGraphic* graphic;

  QPushButton* bOk;
  QPushButton* bCancel;
  QPushButton* bHelp;

  RCheckBox*   cbProportional;
  RLabel*      lTextHeight;
  RLineEdit*   eTextHeight;
  RLabel*      lLetterSpacing;
  RLineEdit*   eLetterSpacing;
  RLabel*      lWordSpacing;
  RLineEdit*   eWordSpacing;
  RLabel*      lLineDistance;
  RLineEdit*   eLineDistance;
  RLabel*      lAngle;
  RLineEdit*   eAngle;
  RLabel*      lRadius;
  RLineEdit*   eRadius;
  RCheckBox*   cbFixedWidth;

  QRadioButton* rbAlignLeft;
  QRadioButton* rbAlignCenter;
  QRadioButton* rbAlignRight;

  QRadioButton* rbShapeStraight;
  QRadioButton* rbShapeRoundOut;
  QRadioButton* rbShapeRoundIn;

  RToolButton*  bNew;
  RToolButton*  bLoad;
  RToolButton*  bSave;
  QFrame*       fSep1;
  RToolButton*  bCut;
  RToolButton*  bCopy;
  RToolButton*  bPaste;
  RLabel*       lText;
  RMultiLineEdit* meText;

  RComboBox*    cbFont;

  QString       text;

};


#endif

// EOF

