/*
 * GTK See -- a image viewer based on GTK+
 * Copyright (C) 1998 Hotaru Lee <jkhotaru@mail.sti.com.cn> <hotaru@163.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>
#include "gtypes.h"
#include "common_tools.h"
#include "rc.h"
#include "options.h"
#include "gtkseemenu.h"

static GtkWidget *thumbnails_item, *small_icons_item, *details_item;

static GtkWidget*
#ifdef GTK_HAVE_FEATURES_1_1_0
create_menu(GtkMenuBar *menubar, guchar *label, GtkAccelGroup *accel)
#else
create_menu(GtkMenuBar *menubar, guchar *label, GtkAcceleratorTable *accel)
#endif
{
	GtkWidget *menu, *menu_item;

	menu = gtk_menu_new();

	if (accel != NULL)
	{
#ifdef GTK_HAVE_FEATURES_1_1_0
		gtk_menu_set_accel_group(GTK_MENU(menu), accel);
#else
		gtk_menu_set_accelerator_table(GTK_MENU(menu), accel);
#endif
	}
	
#ifdef GTK_HAVE_FEATURES_1_1_2
	menu_item = gtk_tearoff_menu_item_new();
	gtk_widget_show(menu_item);
	gtk_menu_append(GTK_MENU(menu), menu_item);
#endif

	menu_item = gtk_menu_item_new_with_label(label);
	gtk_widget_show(menu_item);
	gtk_menu_item_set_submenu(GTK_MENU_ITEM(menu_item), menu);
	gtk_menu_bar_append(menubar, menu_item);

	return menu;
}

static GtkWidget*
#ifdef GTK_HAVE_FEATURES_1_1_0
create_menu_item(GtkMenu *menu, guchar *label, GtkSignalFunc func, GtkAccelGroup *accel, guint key, guint mods)
#else
create_menu_item(GtkMenu *menu, guchar *label, GtkSignalFunc func, GtkAcceleratorTable *accel, gchar key, guint mods)
#endif
{
	GtkWidget *menu_item;

	if (label == NULL)
	{
		menu_item = gtk_menu_item_new();
	} else
	{
		menu_item = gtk_menu_item_new_with_label(label);
	}
	gtk_menu_append(menu, menu_item);
	if (func != NULL)
	{
		gtk_signal_connect(GTK_OBJECT(menu_item), "activate", func, NULL);
	}
	if (accel != NULL)
	{
#ifdef GTK_HAVE_FEATURES_1_1_0
		gtk_widget_add_accelerator(menu_item, "activate",
			accel, key, mods, GTK_ACCEL_VISIBLE);
#else
		gtk_widget_install_accelerator(menu_item, accel, "activate",
			key, mods);
#endif
	}
	gtk_widget_show(menu_item);
	return menu_item;
}

GtkWidget*
get_main_menu(GtkWidget *window)
{
	GtkWidget *menubar, *menu, *menu_item;
	GSList *group;

#ifdef GTK_HAVE_FEATURES_1_1_0
	GtkAccelGroup *accel;

	accel = gtk_accel_group_new();
	gtk_accel_group_attach(accel, GTK_OBJECT(window));
#else
	GtkAcceleratorTable *accel;

	accel = gtk_accelerator_table_new();
	gtk_window_add_accelerator_table(GTK_WINDOW(window), accel);
#endif

	menubar = gtk_menu_bar_new();
	gtk_widget_show(menubar);
	
	/* File menu */
	menu = create_menu(GTK_MENU_BAR(menubar), "File", accel);
	
	create_menu_item(GTK_MENU(menu), "View",
		GTK_SIGNAL_FUNC(menu_file_view),
		accel,
#ifdef GTK_HAVE_FEATURES_1_1_0
		GDK_Return,
#else
		'V',
#endif
		0);
	
	create_menu_item(GTK_MENU(menu), "Full-view",
		GTK_SIGNAL_FUNC(menu_file_full_view),
		accel,
#ifdef GTK_HAVE_FEATURES_1_1_0
		GDK_Return,
#else
		'V',
#endif
		GDK_SHIFT_MASK);

	create_menu_item(GTK_MENU(menu), NULL, NULL, NULL, 0, 0);

	create_menu_item(GTK_MENU(menu), "Quit",
		GTK_SIGNAL_FUNC(menu_file_quit),
		accel, GDK_X, GDK_MOD1_MASK);
	
	/* View menu */
	menu = create_menu(GTK_MENU_BAR(menubar), "View", accel);

	thumbnails_item = gtk_radio_menu_item_new_with_label(NULL, "Thumbnails");
	group = gtk_radio_menu_item_group(GTK_RADIO_MENU_ITEM(thumbnails_item));
	gtk_menu_append(GTK_MENU(menu), thumbnails_item);
#ifdef GTK_HAVE_FEATURES_1_1_0
	gtk_widget_add_accelerator(thumbnails_item, "activate",
		accel, GDK_F8, 0, GTK_ACCEL_VISIBLE);
#else
	gtk_widget_install_accelerator(thumbnails_item, accel, "activate",
		'8', 0);
#endif
	gtk_widget_show(thumbnails_item);
	
	small_icons_item = gtk_radio_menu_item_new_with_label(group, "Small icons");
	group = gtk_radio_menu_item_group(GTK_RADIO_MENU_ITEM(small_icons_item));
	gtk_menu_append(GTK_MENU(menu), small_icons_item);
#ifdef GTK_HAVE_FEATURES_1_1_0
	gtk_widget_add_accelerator(small_icons_item, "activate",
		accel, GDK_F9, 0, GTK_ACCEL_VISIBLE);
#else
	gtk_widget_install_accelerator(small_icons_item, accel, "activate",
		'9', 0);
#endif
	gtk_widget_show(small_icons_item);
	
	details_item = gtk_radio_menu_item_new_with_label(group, "Details");
	group = gtk_radio_menu_item_group(GTK_RADIO_MENU_ITEM(details_item));
	gtk_menu_append(GTK_MENU(menu), details_item);
#ifdef GTK_HAVE_FEATURES_1_1_0
	gtk_widget_add_accelerator(details_item, "activate",
		accel, GDK_F10, 0, GTK_ACCEL_VISIBLE);
#else
	gtk_widget_install_accelerator(details_item, accel, "activate",
		'0', 0);
#endif
	gtk_widget_show(details_item);
	
	menu_set_list_type(rc_get_int("image_list_type"));

	gtk_signal_connect(GTK_OBJECT(thumbnails_item), "toggled",
		GTK_SIGNAL_FUNC(menu_view_thumbnails), NULL);
	gtk_signal_connect(GTK_OBJECT(small_icons_item), "toggled",
		GTK_SIGNAL_FUNC(menu_view_small_icons), NULL);
	gtk_signal_connect(GTK_OBJECT(details_item), "toggled",
		GTK_SIGNAL_FUNC(menu_view_details), NULL);

	create_menu_item(GTK_MENU(menu), NULL, NULL, NULL, 0, 0);

	menu_item = gtk_check_menu_item_new_with_label("Show hidden files");
	gtk_check_menu_item_set_state(GTK_CHECK_MENU_ITEM(menu_item),
		rc_get_boolean("show_hidden"));
	gtk_menu_append(GTK_MENU(menu), menu_item);
	gtk_signal_connect(GTK_OBJECT(menu_item), "toggled",
		GTK_SIGNAL_FUNC(menu_view_show_hidden), NULL);
#ifdef GTK_HAVE_FEATURES_1_1_0
	gtk_widget_add_accelerator(menu_item, "activate",
		accel, GDK_H, GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE);
#else
	gtk_widget_install_accelerator(menu_item, accel, "activate",
		'H', GDK_CONTROL_MASK);
#endif
	gtk_widget_show(menu_item);
	
	menu_item = gtk_check_menu_item_new_with_label("Hide non-images");
	gtk_check_menu_item_set_state(GTK_CHECK_MENU_ITEM(menu_item),
		rc_get_boolean("hide_non_images"));
	gtk_menu_append(GTK_MENU(menu), menu_item);
	gtk_signal_connect(GTK_OBJECT(menu_item), "toggled",
		GTK_SIGNAL_FUNC(menu_view_hide), NULL);
#ifdef GTK_HAVE_FEATURES_1_1_0
	gtk_widget_add_accelerator(menu_item, "activate",
		accel, GDK_I, GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE);
#else
	gtk_widget_install_accelerator(menu_item, accel, "activate",
		'I', GDK_CONTROL_MASK);
#endif
	gtk_widget_show(menu_item);
	
	menu_item = gtk_check_menu_item_new_with_label("Fast preview");
	gtk_check_menu_item_set_state(GTK_CHECK_MENU_ITEM(menu_item),
		rc_get_boolean("fast_preview"));
	gtk_menu_append(GTK_MENU(menu), menu_item);
	gtk_signal_connect(GTK_OBJECT(menu_item), "toggled",
		GTK_SIGNAL_FUNC(menu_view_preview), NULL);
	gtk_widget_show(menu_item);
	
	create_menu_item(GTK_MENU(menu), NULL, NULL, NULL, 0, 0);

	create_menu_item(GTK_MENU(menu), "Refresh",
		GTK_SIGNAL_FUNC(menu_view_refresh),
		accel,
#ifdef GTK_HAVE_FEATURES_1_1_0
		GDK_F5,
#else
		'R',
#endif
		0);
	
	create_menu_item(GTK_MENU(menu), "Quick-refresh",
		GTK_SIGNAL_FUNC(menu_view_quick_refresh),
		accel,
#ifdef GTK_HAVE_FEATURES_1_1_0
		GDK_F5,
#else
		'R',
#endif
		GDK_SHIFT_MASK);
	
	menu_item = gtk_check_menu_item_new_with_label("Auto-refresh");
	gtk_menu_append(GTK_MENU(menu), menu_item);
	gtk_signal_connect(GTK_OBJECT(menu_item), "toggled",
		GTK_SIGNAL_FUNC(menu_view_auto_refresh), NULL);
	gtk_widget_show(menu_item);
	
	/* Tools menu */
	menu = create_menu(GTK_MENU_BAR(menubar), "Tools", accel);

	create_menu_item(GTK_MENU(menu), "Slide show",
		GTK_SIGNAL_FUNC(menu_tools_slide_show),
		accel, GDK_S, GDK_CONTROL_MASK);

	create_menu_item(GTK_MENU(menu), NULL, NULL, NULL, 0, 0);

	create_menu_item(GTK_MENU(menu), "Options...",
		GTK_SIGNAL_FUNC(options_show),
		NULL, 0, 0);

	/* Help menu */
	menu = create_menu(GTK_MENU_BAR(menubar), "Help", accel);
	
	create_menu_item(GTK_MENU(menu), "Legal",
		GTK_SIGNAL_FUNC(menu_help_legal),
		NULL, 0, 0);
	
	create_menu_item(GTK_MENU(menu), "Usage",
		GTK_SIGNAL_FUNC(menu_help_usage),
		NULL, 0, 0);
	
	create_menu_item(GTK_MENU(menu), "Known-bugs",
		GTK_SIGNAL_FUNC(menu_help_known_bugs),
		NULL, 0, 0);
	
	create_menu_item(GTK_MENU(menu), "Feedback",
		GTK_SIGNAL_FUNC(menu_help_feedback),
		NULL, 0, 0);
	
	create_menu_item(GTK_MENU(menu), NULL, NULL, NULL, 0, 0);

	create_menu_item(GTK_MENU(menu), "About",
		GTK_SIGNAL_FUNC(menu_help_about),
		NULL, 0, 0);
	
	return menubar;
}

void
menu_set_list_type(ImageListType type)
{
	switch (type)
	{
	  case IMAGE_LIST_THUMBNAILS:
		gtk_check_menu_item_set_state(GTK_CHECK_MENU_ITEM(thumbnails_item), TRUE);
		break;
	  case IMAGE_LIST_SMALL_ICONS:
		gtk_check_menu_item_set_state(GTK_CHECK_MENU_ITEM(small_icons_item), TRUE);
		break;
	  case IMAGE_LIST_DETAILS:
	  default:
		gtk_check_menu_item_set_state(GTK_CHECK_MENU_ITEM(details_item), TRUE);
		break;
	}
}

void
menu_help_legal(GtkWidget *widget, gpointer data)
{
	static guint legal_sizes[] =
	{
		FONT_SMALL,
		FONT_SMALL,
		FONT_SMALL,
		FONT_SMALL,
		FONT_SMALL,
		FONT_SMALL,
		FONT_SMALL,
		FONT_SMALL,
		FONT_SMALL,
		FONT_SMALL,
		FONT_SMALL,
		0
	};
	static guchar *legal_text[] =
	{
		"    GTK See is free software; you can redistribute it and/or modify",
		" it under the terms of the GNU General Public License as published by",
		" the Free Software Foundation; either version 2 of the License, or",
		" (at your option) any later version.\n\n",
		"    GTK See is distributed in the hope that it will be useful,",
		" but WITHOUT ANY WARRANTY; without even the implied warranty of",
		" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the",
		" GNU General Public License for more details.\n\n",
		"    You should have received a copy of the GNU General Public License",
		" along with this program; if not, write to the Free Software",
		" Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.\n",
		NULL
	};
	GtkWidget *dialog;
	
	dialog = info_dialog_new("Legal", legal_sizes, legal_text);
	gtk_widget_show(dialog);
}

void
menu_help_usage(GtkWidget *widget, gpointer data)
{
	static guint usage_sizes[] =
	{
		FONT_BIG,
		FONT_SMALL,
		FONT_SMALL,
		FONT_SMALL,
		FONT_SMALL,
		FONT_SMALL,
		FONT_SMALL,
		FONT_SMALL,
		FONT_SMALL,
		FONT_BIG,
		FONT_SMALL,
		FONT_SMALL,
		FONT_SMALL,
		FONT_SMALL,
		FONT_SMALL,
		FONT_SMALL,
		FONT_SMALL,
		FONT_SMALL,
		FONT_SMALL,
		FONT_BIG,
		FONT_SMALL,
		FONT_BIG,
		0
	};
	static guchar *usage_text[] = {
		"Command-line usage:\n",
		"    gtksee [-R[directory]] [-fis] [files...]\n",
		"      -R  --  Use current directory as root\n",
		"      -R<directory>  --  Use <directory> as root\n",
		"      -f  --  Enable full-screen mode\n",
		"      -i  --  Enable fit-screen mode\n",
		"      -s  --  Enable slide-show mode\n",
		"      files... --  Launch gtksee viewer\n",
		"      -h  --  Print help messages\n\n",
		"Keyboard shortcuts:\n",
		"    These keys are bound to viewer:\n",
		"    [Arrow-keys] Move large image\n",
		"    [PageUp] Show previous image\n",
		"    [PageDown] Show next image\n",
		"    [Home] Show the first image\n",
		"    [End] Show the last image\n",
		"    [Space] Press focused button(default: next)\n",
		"    [Escape] Return to the browser\n",
		"    In full-screen mode, viewer cannot receive any key events. Use pop-up menu instead.\n\n",
		"Mouse hints:\n",
		"    In view mode, double-click on the image to return to the browser.\n\n",
		"Have fun!\n",
		NULL
	};
	GtkWidget *dialog;
	
	dialog = info_dialog_new("Usage", usage_sizes, usage_text);
	gtk_widget_show(dialog);
}

void
menu_help_known_bugs(GtkWidget *widget, gpointer data)
{
	static guint known_bugs_sizes[] = {
		FONT_BIG,
		FONT_SMALL,
		0
	};
	static guchar *known_bugs_text[] = {
		"Keys do not work for full-screen mode:\n",
		"    In full-screen mode, the window is an override-redirect window. Usually, it can't receive any key events from the window manager. I still don't know how to resolve this with GDK/GTK+...\n\n",
		NULL
	};
	GtkWidget *dialog;
	
	dialog = info_dialog_new("Known-bugs", known_bugs_sizes, known_bugs_text);
	gtk_widget_show(dialog);
}

void
menu_help_feedback(GtkWidget *widget, gpointer data)
{
	static guint feedback_sizes[] =
	{
		FONT_BIG,
		FONT_SMALL,
		FONT_SMALL,
		FONT_SMALL,
		FONT_BIG,
		FONT_SMALL,
		FONT_SMALL,
		FONT_SMALL,
		FONT_SMALL,
		0
	};
	static guchar *feedback_text[] = {
		"Comments, suggestions and bug-reportings:\n",
		"    Please send them to my current primary e-mail address:\n",
		"    jkhotaru@mail.sti.com.cn\n\n",
		"    I'm collecting icon for gtksee. If you are interested in this job, make one and send it to me. Thanks. I'm not good at graphics design, sorry. I will distribute them together with the next release.\n\n",
		"Imageware:\n",
		"    I'm always collecting all kinds of images. If you *really* like this program, send your favorite picture(s) to my secondary e-mail address:\n",
		"    hotaru@163.net\n",
		"    Keep sending me things. :) And I'll keep on developing this program.\n",
		"    P.S. My favorite is Anime/Manga. :)\n",
		NULL
	};
	GtkWidget *dialog;
	
	dialog = info_dialog_new("Feedback", feedback_sizes, feedback_text);
	gtk_widget_show(dialog);
}
