/*-----------------------------------------------------------------
LOG
    GEM - Graphics Environment for Multimedia

    A camera object

    Copyright (c) 1997-1999 Mark Danks. mark@danks.org
    For information on usage and redistribution, and for a DISCLAIMER OF ALL
    WARRANTIES, see the file, "GEM.LICENSE.TERMS" in this distribution.

-----------------------------------------------------------------*/

#ifndef INCLUDE_CAMERA_H_
#define INCLUDE_CAMERA_H_

#include "Base/GemBase.h"

/*-----------------------------------------------------------------
-------------------------------------------------------------------
CLASS
    camera
    
    A camera object

DESCRIPTION

    Inlet for a list  - "rotatelist"
    Inlet for a list  - "translatelist"

    "rotatelist" - rotation vector
    "translatelist" - translation vector
    "reset" - reset the camera values
    "print" - print out the camera values
    
-----------------------------------------------------------------*/
class GEM_EXTERN camera : public GemBase
{
    CPPEXTERN_HEADER(camera, GemBase)

    public:

        //////////
        // Constructor
    	camera();
    	
    protected:
    	
    	//////////
    	// Destructor
    	virtual     	~camera();

    	//////////
    	// When rendering occurs
    	virtual void	render(GemState *state);

    	//////////
    	// Print out the camera values
    	void	    	printMess();
    	
    	//////////
    	// Reset the camera values
    	void	    	resetMess();
    	
    	//////////
    	// Does the actual job of reseting the camera values
    	void	    	resetValues();
    	
    	//////////
    	// The vector of rotation
    	void	    	rotVectorMess(float x, float y, float z);
    	
    	//////////
    	// The vector of translation
    	void	    	transVectorMess(float x, float y, float z);
    	
    	//////////
    	// Rotate vector
    	float	    	m_spin[3];
    	
    	//////////
    	// Translation vector
    	float	    	m_pos[3];
    	
    private:
    
    	//////////
    	// Static member functions
    	static void 	rotVectorMessCallback(void *data, t_floatarg x, t_floatarg y, t_floatarg z);
    	static void 	transVectorMessCallback(void *data, t_floatarg x, t_floatarg y, t_floatarg z);
    	static void 	resetMessCallback(void *data);
    	static void 	printMessCallback(void *data);
};

#endif	// for header file
