// copyright (c) 1997,1998 stephen f. white
// 
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.  If not, write to
// the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

import java.util.*;
import java.net.*;		// for URL stuff
import java.awt.*;
import java.applet.*;
import vrml.external.*;
import vrml.external.field.*;
import vrml.external.exception.InvalidVrmlException;

// import netscape.javascript.*;

public class EAISceneInterface extends Applet implements SceneInterface,
						         EventOutObserver
{
    String		status;
    Dispatcher		dispatcher;
    Browser		browser;

    // fields
    Node		vNet;

    // EventOut's
    EventOut            position;
    EventOut            orientation;

    EventInSFBool	isConnected;

    // rootNode EventIn's
    EventInMFNode	addChildren;
    EventInMFNode	removeChildren;
    EventInMFNode	children;

    // viewpoint EventIn's
    EventInSFVec3f	viewpointPosition;
    EventInSFRotation	viewpointOrientation;
    EventInSFBool	viewpointBind;

    public void init()
    {
	String		hostname = "";
	int		port;
	String[]	avatarNames, avatarURLs;
	Color		color;

	// Get color parameters.
	color = decodeColor(getParameter("BGCOLOR"));
	if (color != null) setBackground(color);

	color = decodeColor(getParameter("FGCOLOR"));
	if (color != null) setForeground(color);

	onStatus("locating VRML browser...");
	while (true) {
	    try { 
		browser = Browser.getBrowser(this);
	    } catch (Exception ignored) {}
	  if (browser != null) break;
	    try {
		Thread.sleep(1000);
	    } catch (InterruptedException e) {
		return;
	    }
	}
	onStatus("vnet v1.1b1 (c) 1998 stephen f. white, jeff sonstein");
	setLayout(new BorderLayout());

	Node rootNode = browser.getNode("ROOTNODE");
	addChildren = (EventInMFNode) rootNode.getEventIn("addChildren");
	removeChildren = (EventInMFNode) rootNode.getEventIn("removeChildren");
	children = (EventInMFNode) rootNode.getEventIn("children");

	Node viewpoint = browser.getNode("VIEWPOINT");
	viewpointPosition = (EventInSFVec3f) viewpoint.getEventIn("position");
	viewpointOrientation = (EventInSFRotation)
				viewpoint.getEventIn("orientation");
	viewpointBind = (EventInSFBool) viewpoint.getEventIn("set_bind");

	Node box = browser.getNode("BIGBOX");
	vNet = browser.getNode("VNET");

	position = box.getEventOut("position_changed");
	orientation = box.getEventOut("orientation_changed");

	avatarNames = ((EventOutMFString)
				vNet.getEventOut("avatarNames")).getValue();
	avatarURLs = ((EventOutMFString)
				vNet.getEventOut("avatarURLs")).getValue();
	isConnected = ((EventInSFBool) vNet.getEventIn("isConnected"));

	position.advise(this, position);
	orientation.advise(this, orientation);

        try {
	    hostname = new URL(browser.getWorldURL()).getHost();
        } catch (MalformedURLException e) {
        }
	port = ((EventOutSFInt32) vNet.getEventOut("port")).getValue();

	dispatcher = new Dispatcher(this);

	TalkerPanel talker = new TalkerPanel(dispatcher, hostname,
				  port, avatarNames, avatarURLs);
	add("Center", talker);
        dispatcher.setTalker(talker);
    }

    public void callback(EventOut value, double timeStamp, Object data)
    {
	if ((EventOut)data == position) {
	    float[]             pos = ((EventOutSFVec3f) value).getValue();
	    dispatcher.sendPosition(new VSFVec3f(pos));
	} else if ((EventOut)data == orientation) {
	    float[]             rot = ((EventOutSFRotation) value).getValue();
	    dispatcher.sendOrientation(new VSFRotation(rot));
	} else {
	    dispatcher.log("unknown callback:  " + value);
	}
    }

    public void onStatus(String str)
    {
	status = str;
	showStatus(status);
    }

    public void onError(String str)
    {
	onStatus(str);
    }

    public boolean mouseEnter(Event evt, int x, int y)
    {
	showStatus(status);
	return true;
    }

    public void addObject(VRMLObject obj)
    {
	addChildren.setValue(((EAIObject) obj).nodes);
    }

    public void removeObject(VRMLObject obj)
    {
	removeChildren.setValue(((EAIObject) obj).nodes);
    }

    public void removeAllObjects()
    {
	children.setValue(browser.createVrmlFromString("Group {}"));
    }

    public VRMLObject createObject(int vid, String url,
   				   VRMLObjectObserver observer)
    {
	return new EAIObject(vid, url, browser, observer);
    }

    public void setViewpointPosition(VSFVec3f position)
    {
	viewpointBind.setValue(false);
	viewpointPosition.setValue(position.getValue());
	viewpointBind.setValue(true);
    }

    public void setViewpointOrientation(VSFRotation orientation)
    {
	viewpointBind.setValue(false);
	viewpointOrientation.setValue(orientation.getValue());
	viewpointBind.setValue(true);
    }

    Color decodeColor(String str)
    {
	Color		color;

	if (str == null) return null;

	if (str.charAt(0) == '#') str = str.substring(1);

	try {
	    color = new Color(Integer.parseInt(str, 16));
	} catch (NumberFormatException e) {
	    color = null;
	}
	return color;
    }

    public void onConnect()
    {
	isConnected.setValue(true);
    }

    public void onDisconnect()
    {
	isConnected.setValue(false);
    }
}
