// copyright (c) 1997,1998 stephen f. white
// 
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.  If not, write to
// the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

import java.awt.*;
import java.awt.image.*;
import java.util.Observer;

class Icon extends Canvas {
    Image		image;
    Observer		observer;
    int			width;
    int			height;
    boolean		gotSize;

    // constructor where we know the size of the icon:
    Icon(Image image, int width, int height) {
	this.image = image;
	this.width = width;
	this.height = height;
	gotSize = true;
	resize(width, height);
    }

    // constructor where we don't know the size of the icon
    // instead, we wait to find out what it is and call the
    // "update" method of the observer when we do know
    // (so it can accomodate the new size)

    Icon(Image image, Observer observer) {
	this.image = image;
	this.observer = observer;
	gotSize = false;
	width = image.getWidth(this);
	height = image.getHeight(this);
    }

    public void paint(Graphics g) {
	if (image != null) {
	    g.drawImage(image, 0, 0, width, height, this);
	}
    }

    public boolean imageUpdate(Image  img, int  infoflags,
		int  x, int  y, int  width, int  height) {
	boolean again = true;
	if ((infoflags & ImageObserver.SOMEBITS) != 0) {
	    repaint();
	}
	if ((infoflags & ImageObserver.ALLBITS) != 0) {
	    repaint();
	    again = false;
	}
	if ((infoflags & ImageObserver.WIDTH) != 0) {
	    this.width = width;
	}
	if ((infoflags & ImageObserver.HEIGHT) != 0) {
	    this.height = height;
	}
	if (!gotSize && this.width != -1 && this.height != -1) {
	    gotSize = true;
	    resize(this.width, this.height);
	    if (observer != null) observer.update(null, null);
	}
	return again;
    }
}
