#include "swserv.h"


#define THIS_CMD_NAME           "create"


/*      
 *      Create an object.
 */
int CmdCreate(int condescriptor, char *arg)
{
        long con_object_num;
	xsw_object_struct *con_obj_ptr;

        long new_obj_num;
        xsw_object_struct *new_obj_ptr;

        char name[XSW_OBJ_NAME_MAX];
	char type[CS_DATA_MAX_LEN];
	int type_code;

        char name1[XSW_OBJ_NAME_MAX + 80];
        char name2[XSW_OBJ_NAME_MAX + 80];
        
        char stringa[XSW_OBJ_NAME_MAX + 512];
        char sndbuf[CS_DATA_MAX_LEN];
        char *strptr;


        /* Get con_object_num from connection (assumed valid) */
        con_object_num = connection[condescriptor]->object_num;
        if(DBIsObjectGarbage(con_object_num))
            return(-1);
        else
            con_obj_ptr = xsw_object[con_object_num];


        /* Print usage? */
        if((arg == NULL) ? 1 : (arg[0] == '\0'))
        {
	    sprintf(sndbuf,
		"Usage: `%s <name>=<type>'",
                THIS_CMD_NAME
	    );
            NetSendLiveMessage(condescriptor, sndbuf);

            return(-1);
        }


	/* Check for '=' character. */
	strptr = strchr(arg, '=');
	if(strptr == NULL)
        {
            sprintf(sndbuf,
                "Usage: `%s <name>=<type>'",
                THIS_CMD_NAME
            );
            NetSendLiveMessage(condescriptor, sndbuf);

            return(-1);
        }


        /* Check if object's permission allows create object. */
        if(con_obj_ptr->permission.uid > ACCESS_UID_CREATE)
        {
            sprintf(sndbuf,
                "%s: Requires access level %i: Permission denied.",
		THIS_CMD_NAME,
                ACCESS_UID_CREATE
            );
            NetSendLiveMessage(condescriptor, sndbuf);
            return(-1);
        }


	/* Get name. */
	strncpy(name, arg, XSW_OBJ_NAME_MAX);
	name[XSW_OBJ_NAME_MAX - 1] = '\0';

	strptr = strchr(name, '=');
	if(strptr != NULL)
	    *strptr = '\0';
	StringStripSpaces(name);


	/* Get type. */
	strptr = strchr(arg, '=');
	strncpy(
            type,
	    ((strptr == NULL) ? arg : strptr + 1),
	    CS_DATA_MAX_LEN
	);
	type[CS_DATA_MAX_LEN - 1] = '\0';
	StringStripSpaces(type);


        /* Sanitize name. */
        if(DBValidateObjectName(name)) 
        {
            sprintf(sndbuf,
                "%s: %s: Invalid name.",
		THIS_CMD_NAME,
                name
            );
            NetSendLiveMessage(condescriptor, sndbuf);

            return(-1);
        }


        /* Get type code. */
	if(strcasepfx(type, XSW_TYPE_NAME_STATIC))
	    type_code = XSW_OBJ_TYPE_STATIC;
	else if(strcasepfx(type, XSW_TYPE_NAME_DYNAMIC))
            type_code = XSW_OBJ_TYPE_DYNAMIC;
        else if(strcasepfx(type, XSW_TYPE_NAME_CONTROLLED))
            type_code = XSW_OBJ_TYPE_CONTROLLED;
        else if(strcasepfx(type, XSW_TYPE_NAME_PLAYER))
            type_code = XSW_OBJ_TYPE_PLAYER;
        else if(strcasepfx(type, XSW_TYPE_NAME_WEAPON))
            type_code = XSW_OBJ_TYPE_WEAPON;
        else if(strcasepfx(type, XSW_TYPE_NAME_STREAMWEAPON))
            type_code = XSW_OBJ_TYPE_STREAMWEAPON;
        else if(strcasepfx(type, XSW_TYPE_NAME_SPHEREWEAPON))
            type_code = XSW_OBJ_TYPE_SPHEREWEAPON;
        else if(strcasepfx(type, XSW_TYPE_NAME_HOME))
            type_code = XSW_OBJ_TYPE_HOME;
        else if(strcasepfx(type, XSW_TYPE_NAME_AREA))
            type_code = XSW_OBJ_TYPE_AREA;
        else if(strcasepfx(type, XSW_TYPE_NAME_ANIMATED))
            type_code = XSW_OBJ_TYPE_ANIMATED;
	else
	    type_code = XSW_OBJ_TYPE_GARBAGE;

        /* Making sure type code is valid. */
        if(type_code <= XSW_OBJ_TYPE_GARBAGE)
        {
            sprintf(sndbuf,
                "%s: Invalid object type code `%s'.",
		THIS_CMD_NAME,
                type
            );
            NetSendLiveMessage(condescriptor, sndbuf);
        
            return(-1);   
        }
        /* Cannot create players. */
        if(type_code == XSW_OBJ_TYPE_PLAYER)
        {
            sprintf(sndbuf,
                "%s: Must use `createplayer' to create a player object.",
		THIS_CMD_NAME
            );
            NetSendLiveMessage(condescriptor, sndbuf);

            return(-1);
        }


        /* Create new object. */
        new_obj_num = DBCreateObject(
            ISREF_DEFAULT,
            type_code,
            con_object_num,     /* Owner. */
            con_obj_ptr->x,
            con_obj_ptr->y,
            con_obj_ptr->z,
            con_obj_ptr->heading,
            con_obj_ptr->pitch,
            con_obj_ptr->bank
        );
        if(DBIsObjectGarbage(new_obj_num))
        {
            sprintf(sndbuf,
                "%s: DBCreateObject(): Unable to create object.",
                THIS_CMD_NAME
            );
            NetSendLiveMessage(condescriptor, sndbuf);

            return(-1);
        }
	else
	{
	    new_obj_ptr = xsw_object[new_obj_num];
	}


        /* Set some values for the new object. */
        strncpy(
	    new_obj_ptr->name,
	    name,
            XSW_OBJ_NAME_MAX
	);
        new_obj_ptr->name[XSW_OBJ_NAME_MAX - 1] = '\0';

        new_obj_ptr->sect_x = con_obj_ptr->sect_x;
        new_obj_ptr->sect_y = con_obj_ptr->sect_y;
        new_obj_ptr->sect_z = con_obj_ptr->sect_z;



        /* New player object has been created. */


        /* Send updates to all connections. */
        NetSendCreateObject(-1, new_obj_num);
        NetSendObjectName(-1, new_obj_num);
        NetSendObjectSect(-1, new_obj_num);


        /* Print and log. */
	strncpy(
	    name1,
	    DBGetFormalNameStr(new_obj_num),
	    XSW_OBJ_NAME_MAX + 80
	);
	name1[XSW_OBJ_NAME_MAX + 80 - 1] = '\0';
        strncpy(
            name2,
            DBGetFormalNameStr(con_object_num),
            XSW_OBJ_NAME_MAX + 80
        );
        name2[XSW_OBJ_NAME_MAX + 80 - 1] = '\0';


        sprintf(sndbuf,
            "Created new object: %s",
            name1
        );
        NetSendLiveMessage(condescriptor, sndbuf);

        sprintf(stringa,
            "%s: Created new object: %s",
            name2,
            name1
        );
        if(sysparm.log_events)
            LogAppendLineFormatted(fname.primary_log, stringa);


        return(0);
}
