/*
                        Joystick Wrapper

	Any program wanting to use the Linux Joystick Wrapper
	functions (as specified in this file) needs to #include
	this file and link to the library libjsw.

	An example program called jswtest should acompany
	the program package that this header file came in.

        For contact information, see:

        http://fox.mit.edu/xsw/contacts.htm

 */

#ifndef JSW_H
#define JSW_H

#include <time.h>
#include <sys/types.h>


/*
 *	OS Specific Definations:
 */
#ifdef __linux__
# include <linux/joystick.h>
# define JSDefaultDevice		"/dev/js0"
# define JSDefaultCaliberation		".joystick"
#endif

/* Assume defaults for device and caliberation file. */
#ifndef JSDefaultDevice
# define JSDefaultDevice		"/dev/js0"
#endif

#ifndef JSDefaultCaliberation
# define JSDefaultCaliberation		".joystick"
#endif



/*
 *	Default stick bounds (in raw units):
 */
#ifndef JSDefaultMin
# define JSDefaultMin		0
#endif

#ifndef JSDefaultMax
# define JSDefaultMax		1000
#endif

#ifndef JSDefaultCenter
# define JSDefaultCenter	500
#endif

#ifndef JSDefaultNullZone
# define JSDefaultNullZone	100
#endif



/*
 *	Error codes:
 */
#define JSSuccess	0
#define JSError		1
#define JSBadValue	2
#define JSNoAccess	3
#define JSNoBuffers	4


/*
 *	Event codes:
 */
#define JSNoEvent	0
#define JSGotEvent	1

/*
 *	Button state codes:
 */
#define JSButtonStateOff	0
#define JSButtonStateOn		1


/*
 *	Joystick data structures:
 */

/* Axis structure. */
typedef struct {

	/* All units in raw units. */
	int cur;		/* Current position. */
	int min, cen, max;	/* Bounds. */
	int nz;			/* Null zone, in raw units from cen. */

	char flip;		/* Flip values? */

	char is_hat;		/* Treat this axis as a hat? */

} js_axis_struct;

/* Button structure. */
typedef struct {

	unsigned char state;	/* One of JSButtonState*. */

} js_button_struct;

/* Joystick caliberation and current data structure. */
typedef struct {

	/* Public, read only. */
	char *name;

	js_axis_struct **axis;
	int total_axises;

	js_button_struct **button;
	int total_buttons;

	char *device_name;
	char *caliberation_file;

	time_t time;

	/* Private, do not access. */
	int fd;

} js_data_struct;


/* Private functions. */
#ifdef __linux__
extern int JSLoadCaliberationLinux(js_data_struct *jsd);
#endif

/* Public functions. */
extern int JSIsAxisAllocated(js_data_struct *jsd, int n);
extern int JSIsButtonAllocated(js_data_struct *jsd, int n);

extern double JSGetAxisCoeff(js_data_struct *jsd, int n);
extern double JSGetAxisCoeffNZ(js_data_struct *jsd, int n);

extern int JSInit(
	js_data_struct *jsd,
	int argc, char *argv[]
);
extern int JSUpdate(js_data_struct *jsd);
extern void JSClose(js_data_struct *jsd);


#endif	/* JSW_H */
