/* 
 *  Linux Letters and Numbers
 *  By Kirk Ismay, <captain@netidea.com> 
 * 
 *  Based on my daughters once favorite game, Larry's Letters and Numbers.
 *  This is a Linux replacement, as the original was written for Windows. 
 *  I have made several improvements too.*/

#include "lletters.h"

/* Set the font of a widget */
void
lln_set_widget_font (GtkWidget * widget)
{
  GtkStyle *style;

  gtk_widget_ensure_style (widget);
  style = gtk_style_copy (widget->style);

  style->font = gdk_font_load ("-*-utopia-*-r-*-*-60-400-*-*-*-*-*-*");

  gtk_widget_set_style (widget, style);
}

void
close_my_window (GtkWidget * widget, GtkWidget * window)
{
  gtk_widget_destroy (window);
}

int
close_window (GtkWidget * widget, GdkEvent * event, GtkWidget * window)
{
  gtk_widget_destroy (window);
  return TRUE;
}

void
lln_pack_image_in_box (GtkWidget * parent, GtkWidget * box, gchar * filename)
{/* Largely based upon contributions from Paul Keinzle. 01-Mar-99 */

  GtkWidget *pixmapwid;
  GdkPixmap *pixmap;
  GdkBitmap *mask;
  GtkStyle *style;
  GdkImlibImage *image;

  style = gtk_widget_get_style (parent);

  image = gdk_imlib_load_image(g_strconcat(lln_image_dir, filename, NULL));

  gdk_imlib_render(image, image->rgb_width, image->rgb_height);

  pixmap = gdk_imlib_move_image(image);
  mask = gdk_imlib_move_mask(image);

  pixmapwid = gtk_pixmap_new (pixmap, mask);

  gtk_box_pack_start (GTK_BOX (box), pixmapwid, FALSE, FALSE, 0);
}
GtkWidget*
lln_image_popup_new (char filename[], char title[], char label[])
{/* Largely based upon contributions from Paul Keinzle. 01-Mar-99 */

  GtkWidget *window;
  GtkWidget *button;
  GtkWidget *caption, *info ; 
  GtkWidget *main_box, *button_box, *img_box, *box_label;

  /* Create the popup window */
  window = gtk_window_new (GTK_WINDOW_DIALOG);
  gtk_window_set_title (GTK_WINDOW (window), title);
  gtk_window_position (GTK_WINDOW (window), GTK_WIN_POS_CENTER);
  gtk_container_border_width (GTK_CONTAINER (window), 10);

  gtk_signal_connect (GTK_OBJECT (window), "key_press_event",
		      GTK_SIGNAL_FUNC (get_keystroke), (gpointer) 1);
  gtk_signal_connect (GTK_OBJECT (window), "key_release_event",
		      GTK_SIGNAL_FUNC (get_keystroke), (gpointer) 1);
  gtk_signal_connect (GTK_OBJECT (window), "delete_event",
                      GTK_SIGNAL_FUNC (close_window), window);
  
  gtk_widget_realize (GTK_WIDGET (window));

  /* put a vertical container inside the window */
  main_box = gtk_vbox_new (FALSE, 0);
  button_box = gtk_vbox_new (FALSE, 0);
  gtk_container_add (GTK_CONTAINER (window), button_box);

  /* add a button (centered and clickable) */
  button = gtk_button_new ();
  gtk_signal_connect (GTK_OBJECT (button), "button_press_event",
  	      GTK_SIGNAL_FUNC (retransmit_press), window);
  gtk_signal_connect (GTK_OBJECT (button), "button_release_event",
  	      GTK_SIGNAL_FUNC (retransmit_release), window);
  gtk_signal_connect (GTK_OBJECT (button), "clicked",
		      GTK_SIGNAL_FUNC (close_my_window), window);

  gtk_box_pack_start (GTK_BOX (button_box), button, TRUE, TRUE, 0);
  
  /* get our image */  
  if (filename) {
    img_box = gtk_hbox_new (TRUE, 0);
    lln_pack_image_in_box (window, img_box, filename);
    gtk_box_pack_start (GTK_BOX (main_box), img_box, TRUE, TRUE, 0);
  } 

  /* finally add some text */
  if (label) {
    caption = gtk_label_new (label);
    lln_set_widget_font (caption);
    gtk_box_pack_start (GTK_BOX (main_box), caption, TRUE, TRUE, 0);
  }
   gtk_container_add (GTK_CONTAINER (button), main_box);   
  /* Brief Instructions */
  info = gtk_label_new (_("Press any key or click on the image\nto  go back to the main window.")); 
  gtk_box_pack_start (GTK_BOX (main_box), info, TRUE, TRUE, 0);

  /* Display it all */
  gtk_widget_show_all (window);

  return window;

}

void
lln_show_letter (GtkWidget * widget, gpointer * data)
{

  char title[255], caption[255], *filename;
  char letter = (char) ( (int) data);  /* Odd cast to prevent bogus warning */

/* Begin change JPV - 1999/03/06 */
  sprintf (title, _("The Letter %c"), letter);
/* End change JPV - 1999/03/06 */

  filename = lln_get_file (letter);
  if (filename) {

    sprintf (caption, "%c, %s", 
	     lln_get_1st_letter ((char *) filename),
	     lln_get_word ((char *) filename));
  } 
  else{

/* Begin change JPV - 1999/03/06 */
    sprintf(caption, _("No matching image\nfiles for %c!"), letter);
/* End change JPV - 1999/03/06 */

  }
  
  lln_image_popup_new (filename, title, caption);

  /* Clear the event cue.  Note that if your little one is still
   clicking the mouse, then the box doesn't get a chance to
   expose itself.  This is a feature, though admittedly it is
   only there because I didn't know how to force an exposure
   prior to sleeping a couple of seconds and emptying the
   event queue. */
  while (gdk_event_get()) ;

}

void
lln_show_number (GtkWidget * widget, gpointer * data)
{

  char title[255], *caption, *filename;
  int number = (int) data;

/* Begin change JPV - 1999/03/06 */
  sprintf (title, _("The Number %i"), number);
/* End change JPV - 1999/03/06 */

  filename = lln_get_file ((char) number + 48);
  if (filename) {
    caption = lln_get_number ((char *) filename);
  }
  else{

/* Begin change JPV - 1999/03/06 */
    sprintf(caption, _("No Matching image\nfiles for %i!"), number);
/* End change JPV - 1999/03/06 */

  }
  
  lln_image_popup_new (filename, title, caption);
  while (gdk_event_get()) ; // Clear event que.
}








