/*C*
 *
 * Hatman - The Game of Kings
 * Copyright (C) 1997 James Pharaoh & Timothy Fisken
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *C*/

#include "Point.h"
#include "Rect.h"
#include "../util/error.h"
#include "../util/util.h"
#include "../util/File.h"

bool Point::read(File& f)
{
 if(!f.read(x)) return false;
 if(!f.read(y)) return false;
 return true;
}

bool Point::write(File& f) const
{
 if(!f.write(x) || !f.write(y)) { setError("writing point"); return false; }
 return true;
}

Point& Point::clipTo(const Rect& r)
{
 if(x < r.left()) x = r.left();
 if(x > r.right()) x = r.right();
 if(y < r.top()) y = r.top();
 if(y > r.bottom()) y = r.bottom();
 return *this;
}
