#include "ball.h"
#include "tube.h"

Tube::Tube(Tube::Direction direction) : 
   _start(0), _end(0), _direction(direction)
{
}

void
Tube::ConnectLeft(Element* element)
{
   _start = element;
}

void
Tube::ConnectTop(Element* element)
{
   if (_direction == Tube::Right)
      _end = element;
   else
      _start = element;
}

void
Tube::ConnectRight(Element* element)
{
   _end = element;
}

void
Tube::ConnectBottom(Element* element)
{
   if (_direction == Tube::Right)
      _start = element;
   else
      _end = element;
}

Element* 
Tube::GetStart()
{
   return _start;
}

Element* 
Tube::GetEnd()
{
   return _end;
}

void 
Tube::ToggleDirection()
{
   _direction = (_direction == Tube::Right) ? Tube::Left : Tube::Right;
}

void 
Tube::MoveBall(Ball* ball)
{
   switch (ball->GetDirection()) {
   case Ball::MovingRight:
      if (_direction == Tube::Right) {
	 ball->SetDirection(Ball::MovingUp);
	 _end->PutBall(ball);
      } else {
	 ball->SetDirection(Ball::MovingDown);
	 _end->PutBall(ball);
      }
      break;
   case Ball::MovingDown:
      if (_direction == Tube::Right) {
	 ball->SetDirection(Ball::MovingLeft);
	 _start->PutBall(ball);
      } else {
	 ball->SetDirection(Ball::MovingRight);
	 _end->PutBall(ball);
      }
      break;
   case Ball::MovingLeft:
      if (_direction == Tube::Right) {
	 ball->SetDirection(Ball::MovingDown);
	 _start->PutBall(ball);
      } else {
	 ball->SetDirection(Ball::MovingUp);
	 _start->PutBall(ball);
      }
      break;
   case Ball::MovingUp:
      if (_direction == Tube::Right) {
	 ball->SetDirection(Ball::MovingRight);
	 _end->PutBall(ball);
      } else {
	 ball->SetDirection(Ball::MovingLeft);
	 _start->PutBall(ball);
      }
      break;
   default:
      break;
   }
}



