/* 
 * Copyright (C) 1999 JP Rosevear
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#include "gnome_chess.h"

GnomeChessPrefs *prefs;

static struct prefsdlg {
	GtkWidget *dlg;
	GtkWidget *movelist_notation_rb1;
	GtkWidget *movelist_notation_rb2;
	GtkWidget *sound_beeponmove_cbx;
} prefsdlg;

static void gnomechess_prefs_dialog_changed_cb(GtkWidget *widget, gpointer data);
static void gnomechess_prefs_dialog_apply_cb(GtkWidget *widget, gint page, gpointer data);
static void gnomechess_prefs_dialog_destroy_cb(void);

void gnomechess_prefs_init() {
	gboolean beeponmove = TRUE;
	gint notation = 0;

	prefs = malloc(sizeof(GnomeChessPrefs));
	prefsdlg.dlg = NULL;

	prefs->movelist_notation = 
		gnome_config_private_get_int_with_default("/gnome-chess/movelist/notation", &notation);
	prefs->sound_beeponmove = 
		gnome_config_private_get_bool_with_default("/gnome-chess/sound/beeponmove", &beeponmove);
}

void gnomechess_prefs_dialog() {
	GSList *rblist;
	GtkWidget *label, *vbox, *hbox, *frame, *rb1, *rb2, *checkbox;

	if (prefsdlg.dlg) {
		gtk_widget_show(prefsdlg.dlg);
		return;
	}

	prefsdlg.dlg = gnome_property_box_new();
	gtk_window_set_title(GTK_WINDOW(prefsdlg.dlg), _("Preferences"));

	/* Miscellaneous Page */
	vbox = gtk_vbox_new(FALSE, 0);
	gtk_widget_show(vbox);

	/* Movelist Notation Section */
	frame = gtk_frame_new(_("Movelist Notation"));
	gtk_widget_show(frame);
	gtk_container_add(GTK_CONTAINER(vbox), frame);

	hbox = gtk_hbox_new(FALSE,0);
	gtk_widget_show(hbox);
	gtk_container_add(GTK_CONTAINER(frame), hbox);

	rblist = NULL;
	rb1 = gtk_radio_button_new_with_label(NULL, _("Standard Algebraic Notation"));
	rblist = gtk_radio_button_group(GTK_RADIO_BUTTON(rb1));
	gtk_widget_show(rb1);
	gtk_container_add(GTK_CONTAINER(hbox), rb1);
	prefsdlg.movelist_notation_rb1 = rb1;

	rb2 = gtk_radio_button_new_with_label(rblist, _("Coordinate Notation"));
	gtk_widget_show(rb2);
	gtk_container_add(GTK_CONTAINER(hbox), rb2);
	prefsdlg.movelist_notation_rb2 = rb2;
	if (prefs->movelist_notation == 1)
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(rb2), TRUE);

	gtk_signal_connect (GTK_OBJECT (rb1), "toggled",
		      GTK_SIGNAL_FUNC (gnomechess_prefs_dialog_changed_cb), NULL);
	gtk_signal_connect (GTK_OBJECT (rb2), "toggled",
		      GTK_SIGNAL_FUNC (gnomechess_prefs_dialog_changed_cb), NULL);
	/* Notation Section  End */


	/* Sound Section */
	frame = gtk_frame_new(_("Sound"));
	gtk_widget_show(frame);
	gtk_container_add(GTK_CONTAINER(vbox), frame);

	checkbox = gtk_check_button_new_with_label(_("Beep On Move"));
	gtk_widget_show(checkbox);
	gtk_container_add(GTK_CONTAINER(frame), checkbox);
	prefsdlg.sound_beeponmove_cbx = checkbox;
	if (prefs->sound_beeponmove)
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(checkbox), TRUE);

	gtk_signal_connect (GTK_OBJECT (checkbox), "toggled",
		      GTK_SIGNAL_FUNC (gnomechess_prefs_dialog_changed_cb), NULL);
	/* Sound Section  End */

	label = gtk_label_new(_("Miscellaneous"));
	gtk_widget_show(label);
	gnome_property_box_append_page (GNOME_PROPERTY_BOX(prefsdlg.dlg),vbox, label);

	/* Call backs for the dialog itself */
	gtk_signal_connect (GTK_OBJECT (prefsdlg.dlg), "apply",
                              GTK_SIGNAL_FUNC(gnomechess_prefs_dialog_apply_cb), NULL);
	gtk_signal_connect (GTK_OBJECT (prefsdlg.dlg), "destroy",
                              GTK_SIGNAL_FUNC(gnomechess_prefs_dialog_destroy_cb), NULL);

	gtk_widget_show(prefsdlg.dlg);
}

static void gnomechess_prefs_dialog_write() {
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(prefsdlg.movelist_notation_rb1))) {
		gnome_config_private_set_int("/gnome-chess/movelist/notation", 0);
		prefs->movelist_notation = 0;
	} else {
		gnome_config_private_set_int("/gnome-chess/movelist/notation", 1);
		prefs->movelist_notation = 1;
	}

	prefs->sound_beeponmove = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(prefsdlg.sound_beeponmove_cbx));
	gnome_config_private_set_bool("/gnome-chess/sound/beeponmove", prefs->sound_beeponmove);

	gnome_config_sync();
}

static void gnomechess_prefs_dialog_changed_cb(GtkWidget *widget, gpointer data) {
	gnome_property_box_changed (GNOME_PROPERTY_BOX(prefsdlg.dlg));
}

static void gnomechess_prefs_dialog_apply_cb(GtkWidget *widget, gint page, gpointer data) {

	if (page != -1)
		return;

	gnomechess_prefs_dialog_write();
}

static void gnomechess_prefs_dialog_destroy_cb () {

	gtk_object_destroy(GTK_OBJECT(prefsdlg.dlg));
	prefsdlg.dlg = NULL;
}
