/*
  sdf.C

  Standard Downloading Functions
  General Implementation.

  Uros Platise (c) 1997
*/

#include <string.h>
#include <stdlib.h>
#include "Error.h"
#include "sdf.h"

TAout::TAout (char* aoutFileName, char *mode) {
  char *filtP = strchr (aoutFileName, '%');
  filter [0] = 0; /* remove */
  if (filtP!=NULL) {
    strcpy (filter, filtP+1);
    *filtP=0; /* terminate and get fileName */
  }
  if ((fp=fopen (aoutFileName, mode))==NULL) {
    throw Error_C (); 
  }
  startofFile = true; endofFile = false; anySegWr=false;
  strcpy (fileName, aoutFileName);
}

TAout::~TAout () {
  if (anySegWr==true) { fprintf (fp, "[end]\n"); }
  fclose (fp);
}

int TAout::readData (TDataQuery* dataP) {
  char buf [256];
  if (endofFile==true) { return 0; }
  /* check for correct a.out format */
  if (startofFile==true) {
    /* check for [code] statement */
    while (fgets (buf, 255, fp)!=NULL) {
      if (strncmp ("[code]", buf, 6)==0) { 
	startofFile = false;
	break; 
      }
    }
  }
  if (startofFile==true) {
    throw Error_Device ("File is not standard Micro Asm Output File",fileName);}
  /* read segment name */
  if (fgets (buf, 255, fp)==NULL) {
    throw Error_Device ("Unexpected end of file",fileName); }
  if (strncmp ("[end]", buf, 5)==0) {
    endofFile=true;
    return 0;
  }
  if (buf [0] != '@') {
    throw Error_Device ("Bad file format",fileName); }
  char *rp = strrchr (buf, ','); *rp = 0; /* make two strings from one */
  strcpy (dataP->segName, &buf [1]);
  dataP->offset = strtol(rp+1, (char**)NULL, 16);
  dataP->size = 0;
  /* read segment */
  while (fgets (buf, 255, fp)!=NULL) {
    if (buf [0] == '@' || buf [0] == '[') { break; }
    /* convert hex strings into numbers */
    char *p = buf; char convBuf [3] = {0,0,0};
    while (*p!='\n' && *p!=0 && *p!='\r') {
      convBuf [0] = *p++;
      convBuf [1] = *p++;
      dataP->buf [dataP->size++] = strtol (convBuf, (char**)NULL, 16);
    }
  }
  if (strncmp ("[end]", buf, 5)==0) { endofFile=true; }
  if (buf [0] == '@') { fseek (fp, -strlen (buf), SEEK_CUR); }
  /* filter selected segments */
  dataP->keepOut=false;
  if (filter [0] != 0) {
    if (strstr(filter,dataP->segName)==NULL) { dataP->keepOut=true; }
  }
  return 1;
}

bool TAout::segRequest (char* segName) {
  if (filter [0] != 0) {
    if (strstr (filter,segName)==NULL) { return false; }
  }
  return true;
}

void TAout::writeData (TDataQuery* dataP) {
  anySegWr=true;
  if (startofFile==true) {
    fprintf (fp, "[code]\n");
    startofFile=false;
  }
  fprintf (fp, "@%s,%x\n", dataP->segName, dataP->offset);
  bool newLine=false;
  for (unsigned int fi=0; fi<dataP->size; fi++) {
    fprintf (fp, "%.2x", (unsigned char)dataP->buf [fi]);
    newLine = false;
    if (((fi+1)%16)==0) { fprintf (fp, "\n"); newLine = true; }
  }
  if (newLine==false) { fprintf (fp, "\n"); }
}
