/*
  Main.C

  Micro In-System Programmer
  Uros Platise (C) 1997
*/

#include <stdio.h>

/* dummy AVR terminal - for non-standard programmators */
#include "termAvr.h"
#include "cmdAvr.h"

/* ATMEL STANDARD PROGRAMMATOR */
#include "AtmelTerm.h"
#include "AtmelCMD.h"

const char* help =
"Syntax: uisp device mode [chip_number] optional parameters\n"
"Where:\n"
"  device         Is a serial port as /dev/ttySx, x is a port number.\n"
"                 If --DPTAvr or --DPCAvr is specified the `device' is a\n"
"                 parallel port address in hex {278,378,3bc}.\n"
"                 If device==0 then the port 0x378 (lp0) is selected.\n"
"\n"
"  mode           The following modes are supported:\n"
"\n    Standard Atmel Avr programmer modes:\n"
"      --AtmelTAvr  to enter AVR terminal mode\n"
"      --AtmelCAvr  to enter AVR command line mode\n"
"    Non-standard parallel programmer modes:\n"
"      --DPTAvr     to enter Dummy Parallel AVR Terminal mode\n"
"      --DPCAvr     to enter Dummy Parallel AVR Command line mode\n"
"\n"
"Thanks to Alexey Lapshin and Sergey Larin who submitted the\n"
"parallel driver (PSPI.C) for very very low cost programmer.\n\n"
"Parameter chip_number is a number or a name returned by --AtmelTAvr or\n"
"--AtmelCAvr mode. This parameter does not really specify the target.\n"
"Nevertheless, just try to find the working one.\n";


/*
** Start-UP
*/
int main(int argc, char* argv[])
{
  printf ("Micro In-System Programmer Version 0.1.6,"
	  " Uros Platise\n");
  if (argc<3) {
    printf ("%s", help);
    exit (1);
  }  
  /* open RS232 port */
  TDev* dev = new TRS232 (); /* open SERIAL device */      
  try {
    if (strcmp (argv [2], "--DPTAvr") != 0
	&& strcmp (argv [2], "--DPCAvr") != 0)
      {
	/* open SERIAL device */
	dev->Open (argv[1]);
      }
    else
      {
	int ppbase=0;
	if (sscanf (argv[1], "%x", &ppbase)!=1){
          fprintf(stderr, "Invalid port address: %s\n", argv[1]); exit(1);
        } else 
        if (ppbase){
          parport_base = ppbase;
        }
      }    
    TPartDB Part("Not specified");

    /* Enter one of the uisp mode */

    if (strcmp (argv[2],"--AtmelTAvr")==0){
      TAtmelTerm termAvr(dev, &Part, argv[3]);
      termAvr.Run();
    }
    else if (strcmp(argv[2],"--AtmelCAvr")==0){
      TAtmelCMD cmdAvr(dev, &Part, argv[3]); argv+=3;
      cmdAvr.Do(argc-3,argv);
    }
    else if (strcmp(argv[2],"--DPTAvr")==0){
      TtermAvr termAvr(dev, &Part); 
      termAvr.Run();
    }
    else if (strcmp(argv[2],"--DPCAvr")==0){
      TcmdAvr cmdAvr(dev, &Part); argv+=2;
      cmdAvr.Do(argc-2,argv);
    }
    else{printf("Invalid mode.\n");}
  } 
  catch(Error_C){perror("Error");} 
  catch(Error_Device& errDev){errDev.print();}
  catch(TPartDB::UnknownPart){printf("Unknown part.\n");}

  delete dev;
  return 0;
}

