#include "VectorBase.hh"
#include "standard.hh"

VectorBase::VectorBase(void) { 
  numElems = 0;
  bounds = ArrayInfo();
}

VectorBase::VectorBase(int lBound, ArrayDirn_t dirn, int rBound):
  bounds(lBound, dirn, rBound) {
    numElems = abs(rBound - lBound) + 1;
}

VectorBase::VectorBase(VectorBase& b): numElems(b.numElems), bounds(b.bounds){}

VectorBase::~VectorBase() { }

VHDLType& 
VectorBase::operator=(const VHDLType&) {
  cerr << "VectorBase::operator=() called" << endl;
  abort();
  return *this;		// Just to keep CC quiet.
}

VHDLType& 
VectorBase::assignVal(const VHDLType& val) {
  ASSERT(val.get_kind() == VECTOR_BASE);

  // This happens when a multi-diemsional array (dimension > 2) is
  // instantiated as an aggregate.
  setRange(ObjectBase::VARIABLE, val.get_bounds(), 1);

  for(register int i = 0; i < numElems; i++) {
    get_element(i).assignVal(val.get_element(i));
  }
  return *this;
}

VectorBase& 
VectorBase::operator = (const VectorBase& vb) {
  *((VHDLType *) this) = (const VHDLType &) vb;
  return *this;
}

void
VectorBase::setResolutionFunctionId(int) {
  cerr << "VectorBase::setResolutionFunctionId(int) called" << endl;
  abort();
}

void
VectorBase::setTypeConversionFunctionId(int) {
  cerr << "VectorBase::setTypeConversionFunctionId(int) called" << endl;
  abort();
}

void
VectorBase::setParentCompositeType(VHDLType* ptr) {
  for(register int i=0; (i < this->numElems); i++) {
    this->get_element(i).setParentCompositeType(ptr);
  }
}

void
VectorBase::updateEffVal(const VHDLType* ptr) {
  ASSERT(ptr->get_kind() == VECTOR_BASE);
  for(register int i=0; (i < this->numElems); i++) {
    this->get_element(i).updateEffVal(&((VectorBase*)ptr)->get_element(i));
  }
}

void
VectorBase::setCompositeResolvedSignal(bool val) {
  ASSERT(this->getKind() == ObjectBase::SIGNAL);
  for(register int i=0; (i < this->numElems); i++) {
    this->get_element(i).setCompositeResolvedSignal(val);
  }
}

//The TYPE's resolve is called only for composite resolved signals
//This resolve goes down to first sub-element of the VHDLType and
//calls the sub-elements resolve, but which actually does the resolution
//for the whole composite type
VHDLType*
VectorBase::resolve(VHDLKernelBase* processPtr) {
  ASSERT(this->getKind() == ObjectBase::SIGNAL);
  if(this->numElems >0) {
    return this->get_element(0).resolve(processPtr);
  }
  else {
    return NULL;
  }
}

int 
VectorBase::left() const {
  return bounds.left();
}

int 
VectorBase::right() const {
  return bounds.right();
}

ArrayDirn_t 
VectorBase::dirn() const {
  return bounds.dirn();
}

int 
VectorBase::length() const { 
  return bounds.length();
}

// Note: The method "get_kind()" MUST NOT be overloaded by a derived type.
// This is to ensure that the type is recognized correctly.
Type 
VectorBase::get_kind() const {
  return VECTOR_BASE;
}

void 
VectorBase::print(ostream& os) const { 
  os << "VectorBase(" << bounds << ")"; 
}

int 
VectorBase::get_number_of_elements() const {
  return numElems;
}

VHDLType& 
VectorBase::get_element(const int) const {
  cerr << "ERROR: VectorBase::get_element(int) called" << endl;
  abort();
  return *(VectorBase *)this;	// Just to keep CC quiet.
}

ArrayInfo*
VectorBase::get_bounds() const {
  return (ArrayInfo *)&bounds;
}

void
VectorBase::setRange(ObjectBase::ObjectType, ArrayInfo*, int, const TypeInfo& ) {
  cerr << "ERROR: VectorBase::setRange called" << endl;
  abort();
}

void 
VectorBase::setRange(ObjectBase::ObjectType, VectorBase*) {
  cerr << "ERROR: VectorBase::setRange called" << endl;
  abort();
}

ObjectBase* 
VectorBase::getObject() const {
  // This function should NEVER be called.  Hence the abort.  Included
  // here just to get this compiled.-- SK
  abort();
  return NULL;
}


ObjectBase::ObjectType 
VectorBase::getKind() const {
  if(numElems > 0) {
    return get_element(0).getKind();
  }
  else {
    cerr << "Warning Don't know the type of the objec" << endl;
    cerr << "I am assuming VARIABLE" << endl;
    return ObjectBase::VARIABLE;
  }
}

VectorBase*
VectorBase::getNewArray(const ArrayInfo&, const ArrayInfo&) const {
  cerr << "VectorBase::getNewArray() called!!" << endl;
  return NULL;
}

int
VectorBase::savantwrite(SavantlineType &) const{
  cerr << "VectorBase::savantwrite() called!!" << endl;
  
  return 0;
}

int
VectorBase::savantread(SavantlineType &) {
  cerr << "VectorBase::savantread() called!!" << endl;
  
  return 0;
}

EnumerationType
savantEqual(const VectorBase &lhs, const VectorBase &rhs)
{
  int counter;
  int max_index = lhs.get_number_of_elements();
  
  for(counter = 0; (counter < max_index); counter++) {
    if (savantEqual(lhs.get_element(counter), rhs.get_element(counter)) == ENUMERATION_FALSE) {
      return ENUMERATION_FALSE;
    }
  }

  return ENUMERATION_TRUE;
}

EnumerationType
savantNotEqual(const VectorBase &lhs, const VectorBase &rhs)
{
  if (savantEqual(lhs, rhs) == ENUMERATION_FALSE) {
    return ENUMERATION_TRUE;
  }

  return ENUMERATION_FALSE;
}


SignalBase*
VectorBase::locateSig(int sigId) {
  SignalBase* ptr = NULL;
  for(register int i = 0; i < numElems; i++) {
    ptr = get_element(i).locateSig(sigId);
    if( ptr != NULL) {
      return ptr;
    }
  }
  return NULL;
}

SignalBase*
VectorBase::findSigInBlock(int sigId, int srcId) {
  SignalBase* driver_ptr = NULL;
  int index;

  for(index = 0; index < numElems; index++){
    driver_ptr = get_element(index).findSigInBlock(sigId, srcId);
    if ( driver_ptr != NULL ){
      return driver_ptr;
    }
  }
  return (SignalBase *)NULL;
}
