#include "Types.hh"
#include "AccessType.hh"
#include "standard.hh"

Block AccessType::accessedObjectList;

class VHDLKernelBase;

int savantdeallocate(VHDLKernelBase*, AccessType& ptr) {
  ptr.deallocate();
  return NORMAL_RETURN;
}

AccessType::AccessType(bool alias, const AccessType& actual) 
  :VHDLType(alias) {
    setPointer(actual.getPointer());
}

void
AccessType::addValueToListForDeletion() {
  if (getPointer() != NULL)
    accessedObjectList.addElement(getPointer());
  setPointer((VHDLType*)0);
}

VHDLType& 
AccessType::all() {
  cerr << "ERROR: AccessType::all() called " << endl;
  abort();
  return (*this);
}

ObjectBase::ObjectType
AccessType::getKind() const {
  return ObjectBase::VARIABLE;
}

VHDLType&
AccessType::operator = (const VHDLType& val) {
  ASSERT(val.get_kind() == ACCESS_TYPE);
  // This commented code is the correct way to go about copying
  // but it needs a little more change - TV 11/9/97
//   if (((const AccessType&)val).getPointer() != NULL) {
//     if (getPointer() == NULL) {
//       VHDLType *dest = (((const AccessType&)val).getPointer())->clone();
//       setPointer(dest);
//     }
//     else {
//       assignVariable(*(getPointer()), *(((const AccessType&)val).getPointer()), NULL, NULL);
//     }
//   }
//   else {
//     setPointer(NULL);
//   }
  return *this;
}

bool
AccessType::operator==(const VHDLType& val) const {
  ASSERT(val.get_kind() == ACCESS_TYPE);

  return (*getPointer() == *((AccessType &) val).getPointer());
}

void
AccessType::deallocate() {
  if(getPointer() != NULL) {
    delete getPointer();
    resetPointer();
  }
}

void
AccessType::setPointer(VHDLType*) {
  cerr << "ERROR: AccessType::setPointer() called " << endl;
}
  
VHDLType*
AccessType::getPointer() const {
  cerr << "ERROR: AccessType::getPointer() called " << endl;    
  return NULL;
}

void
AccessType::resetPointer() {
  cerr << "ERROR: AccessType::resetPointer() called " << endl;    
}

Type
AccessType::get_kind() const {
  return ACCESS_TYPE;
}

void
AccessType::print(ostream& ) const {
  cerr << "ERROR: AccessType::Print() called " << endl;    
}

ObjectBase*
AccessType::getObject() const {
  cerr << "ERROR: AccessType::getObject() called " << endl;    
  return NULL;
}

VHDLType* 
AccessType::clone() const {
  cerr << "ERROR: AccessType::clone() called " << endl;    
  return NULL;
}

EnumerationType
savantEqual(const AccessType& lhs, const AccessType& rhs) {
  if(lhs.getPointer() != rhs.getPointer()){
    return SAVANT_BOOLEAN_FALSE;
  }
  else{
    return SAVANT_BOOLEAN_TRUE;
  }
}

EnumerationType 
savantNotEqual(const AccessType& lhs, const AccessType& rhs) {
  if(lhs.getPointer() != rhs.getPointer()) {
    return SAVANT_BOOLEAN_TRUE;
  } else {
    return SAVANT_BOOLEAN_FALSE;
  }
}

