#include "iterator.hh"
#include "list_object.hh"
#include "list.hh"

#ifndef ASSERT
#ifdef DEVELOPER_ASSERTIONS
#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#define ASSERT( x ) assert( x )
#else
#define ASSERT( x )
#endif
#endif

iterator::iterator( list *new_my_list ){
  my_list = new_my_list;
  my_list->register_iterator( this );
  current_position = my_list->get_head();
  removing_element = NULL;
}


iterator::~iterator( ){
  my_list->remove_iterator( this );
}


list_object *
iterator::go_to_position( unsigned int position ){
  go_to_head();
  unsigned int i;
  for( i = 0; i < position; i++ ){
    move_forward();
    if( current_position == my_list->get_tail() ){
      return NULL;
    }
  }
  return get_current();
}


list_object *
iterator::go_to_and_remove( list_object *to_remove ){
  go_to_object( to_remove );
  return remove_current();
}



list_object *
iterator::remove_current(){
  list_object *removing = current_position;
  ASSERT( current_position != NULL );

  list_object *previous = removing->get_previous();
  list_object *next = removing->get_next();

  removing_element = removing;

  my_list->removing_element( removing );

  backward();
  if( previous != NULL ){
    previous->set_next( next );
  }
  
  if( next != NULL ){
    next->set_previous( previous );
  }  
  removing_element = NULL;

  return removing;
}

void 
iterator::append_to_current( list_object *to_append ){
  // If current_object != NULL, which we're assuming is true,
  // then next must not be NULL - this is a circular list after
  // all.
  ASSERT( current_position != NULL );
  ASSERT( current_position->get_next() != NULL );

  if( current_position == my_list->get_tail() ){
    my_list->append( to_append );
  }
  else{
    list_object *next = current_position->get_next();
    
    next->set_previous( to_append );
    to_append->set_next( next );
    to_append->set_previous( current_position );
    current_position->set_next( to_append );
    my_list->new_element();
  }
}

void 
iterator::get_off_of( list_object *being_removed ){
  if( current_position == being_removed ){
    if( removing_element != being_removed ){
      // Then we aren't the one removing this - we need to get off of it!
      backward();
    }
    // else - we started this mess - we'll get off of this element when
    // we're done!
  }
  // else we don't care
}
