#ifndef ARG_PARSER_CC
#define ARG_PARSER_CC
// Copyright (c) 1995-1999 The University of Cincinnati.
// All rights reserved. 

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Dale E. Martin      dmartin@ececs.uc.edu
//          Timothy J. McBrayer tmcbraye@ececs.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: arg_parser.cc,v 1.4 1999/07/23 21:08:24 dmartin Exp $
// 
//---------------------------------------------------------------------------
#include "arg_parser.hh"
#include "dl_list.hh"

void 
arg_parser::get_arg_array(arg_record ptr[]) {

  array_of_arg_records = ptr;
  int i = 0;
  
  for (;;) {
    if (array_of_arg_records[i].arg_text == NULL) {
      break;
    } else {
      i++;
      if (i > 100) {
	// If you got into this conditional, you probably forgot
	// to put "arg_parser::last_arg" in your array.  If not,
	// increase the number above and recompile
	cerr << "More than 100 arguments?\n";
	exit(-1);
      }
    }
  }
  num_args = i;
}


void 
arg_parser::check_args(int &argc, char *argv[], bool caxoe) {
  // complain_and_exit_on_error defaults to true...

  int i,j;
  
  // This loop cycles through the arguments.
  for (i = 1; i < argc ; i++) {
    // This loop compares the arguments passed in with those we're
    // checking them against
    bool matched_one = false;
    for (j = 0; j < num_args; j++) {
      // the first check is necessary because argc can change during
      // execution...
      switch (array_of_arg_records[j].type) {
      case BOOLEAN:{
	
	if (i < argc && strcmp(argv[i], array_of_arg_records[j].arg_text) == 0) {
	  // They matched - let's read in the data
	  matched_one = true;
	  // Argc is passed by reference!
	  remove_arg(i, argc, argv);
	  *(bool*)(array_of_arg_records[j].data) = true;
	}
	break;
      }
      case INTEGER:{
	if (i < argc && strcmp(argv[i], array_of_arg_records[j].arg_text) == 0) {
	  matched_one = true;
	  remove_arg( i, argc, argv );
	  *(int*)(array_of_arg_records[j].data) = atoi(argv[i]);
	  remove_arg( i, argc, argv );
	}
	break;
      }
      case STRING:{
	// Argc is passed by reference!	      
	if (i < argc && strcmp(argv[i], array_of_arg_records[j].arg_text) == 0) {
	  // They matched - let's read in the data
	  matched_one = true;
	  remove_arg(i, argc, argv);
	  *(char**)(array_of_arg_records[j].data) = argv[i];
	  remove_arg(i, argc, argv);
	}
	break;
      }
      case STRING_LIST:{
	char *substring = NULL;
	if (i < argc && strcmp(argv[i], array_of_arg_records[j].arg_text) == 0){
	  remove_arg(i, argc, argv);
	  substring = argv[i];
	}
	else{
	  unsigned int character;
	  bool one_did_not_match = false;
	  for( character = 0; 
	       character < strlen( array_of_arg_records[j].arg_text ); 
	       character++ ){
	    if( array_of_arg_records[j].arg_text[character] != argv[i][character] ){
	      one_did_not_match = true;
	    }
	  }	  
	  if( one_did_not_match == false ){
	    substring = argv[i] + (strlen( array_of_arg_records[j].arg_text )*sizeof(char));
	  }
	}
	if( substring != NULL ){
	  matched_one = true;
	  ((dl_list<char> *)(array_of_arg_records[j].data))->append(substring);
	  remove_arg(i, argc, argv);
	}
	break;
      }
      default:
	cerr << "Invalid arg type in arg array!\n";
	exit(-1);
      }
      
      if( matched_one == true ){
	// we need to reprocess all of the args, to be safe...
	j = 0;
	i = 0;
	matched_one = false;
      }
    } // for j
  } // for i
  
  check_remaining( argc, argv, caxoe );
}


void 
arg_parser::remove_arg( int arg_to_remove, int &argc, char **argv ){
  // let's shift the rest of the arguments around...
  int i;
  for( i = arg_to_remove; i < argc - 1; i++ ){
    argv[i] = argv[i+1];
  }
  argv[i] = NULL;
  
  argc--;
}

void 
arg_parser::print_usage( char *binary_name ){
  if( help_func != 0 ){
    (*help_func)();
  }

  if( binary_name != 0 ){
    cerr << binary_name << " - valid arguments:\n";
  }
  else{
    cerr << "Valid arguments:\n";
  }

  cout << *this;  
}

void 
arg_parser::check_remaining(int argc, char **argv, 
			    bool complain_and_exit_on_error ){
  int i;
  
  for(i = 0; i < argc; i++){
    
    if( strcmp(argv[i], "-help") == 0 ){
      print_usage( 0 );
            
      exit( 0 );
    }
    
    if( argv[i][0] == '-' ){
      // Then someone passed in an illegal argument!
      if(  complain_and_exit_on_error == true) {
	cerr << "Invalid argument \"" << argv[i] << "\"\n";
	cerr << "Valid arguments: \n";
	cerr << *this << endl;
	exit( -1 );
      }
    }
  }
}
#endif
