#ifndef IIRSCRAM_SIGNAL_INTERFACE_DECLARATION_HH
#define IIRSCRAM_SIGNAL_INTERFACE_DECLARATION_HH
// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_SignalInterfaceDeclaration.hh,v 1.3 1999/06/30 11:33:45 tmcbraye Exp $
// 
//---------------------------------------------------------------------------
#include "IIRBase_SignalInterfaceDeclaration.hh"

class IIR_DesigantorList;
class IIR_List;
class IIR_SignalInterfaceDeclaration;

class IIRScram_SignalInterfaceDeclaration : public IIRBase_SignalInterfaceDeclaration {
// @BeginAutoDocExternalProseDescription
// @EndAutoDocExternalProseDescription

public:
  void _publish_vhdl_decl(ostream &);
  IIR_SignalKind _get_signal_kind();
  IIR_Boolean _is_signal(){ return TRUE; }


  IIR_Boolean _have_added_driver() {
    return _driver_addition_flag;
  }

  void _set_driver_addition_flag(IIR_Boolean val) {
    _driver_addition_flag = val;
  }

  void _publish_cc_elaborate();
  declaration_type _get_type();
  void _publish_cc_sigdest();
  void _publish_cc_decl();
  void _publish_cc_init();
  void _publish_cc_data();
  void _publish_cc();
  void _publish_cc_wait_data();
  void _publish_cc_state_object_init();
  void _publish_cc_type_name();  
  void _publish_cc_object_type();
  void _set_passed_through_out_port(IIR_Boolean) {};
  
  IIR *_clone();

  void _type_check( IIRScram_InterfaceDeclaration::_InterfaceListType );

  IIR_SignalInterfaceDeclaration *_my_clone;
protected:
  IIRScram_SignalInterfaceDeclaration();
  virtual ~IIRScram_SignalInterfaceDeclaration() = 0;
    
private:
  IIR_Boolean _driver_addition_flag;
};
#endif










