#ifndef IIRSCRAM_SEQUENTIAL_STATEMENT_HH
#define IIRSCRAM_SEQUENTIAL_STATEMENT_HH

// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ececs.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_SequentialStatement.hh,v 1.2 1999/03/09 20:56:31 dmartin Exp $
// 
//---------------------------------------------------------------------------

#include "IIRBase_SequentialStatement.hh"

template <class type> class dl_list;
class IIRScram_WaitStatement;
class IIR_SequentialStatementList;
class IIR_TypeDefinition;
class IIR_SubprogramDeclaration;
class IIR_Name;
class IIR_List;
class IIR_SequentialStatement;
class IIR_ProcedureCallStatement;

class IIRScram_SequentialStatement : public IIRBase_SequentialStatement {

// @BeginAutoDocExternalProseDescription
// @EndAutoDocExternalProseDescription

public:
  void _publish_cc_next_label();
  void _publish_cc_exit_label();
  virtual void _publish_cc_decl_for_loop_iterator();

  virtual void _build_wait_list(dl_list<IIRScram_WaitStatement> *);
  virtual void _build_procedure_call_stmt_list(dl_list<IIR_ProcedureCallStatement> *);
  // This method tells us if this statement has it's own list of statements
  virtual IIR_Boolean _has_statement_list();

  // This virtual method has the derived class check it's list of statements
  // for return statements and type check them.  (Return statements are
  // special in that the context they need to be type checked in is that
  // of the declaration - not of the statement itself.)  To do the actual
  // cheking, the derived class calls into the second version of the method
  // defined on the next line...
  virtual IIR_Boolean _type_check_return_statements(set<IIR_TypeDefinition> *,
					    IIR_SubprogramDeclaration * );
      
  // Not virtual on purpose!  This is to reuse code instead of copying
  // essentially the same code all of the place.  The only difference in
  // how the derived classes type check their return statements is what
  // the name of their list of statements is.  Therefore, we pass the
  // list in...
  static IIR_Boolean _type_check_return_statements( set<IIR_TypeDefinition> *,
					    IIR_SequentialStatementList *,
					    IIR_SubprogramDeclaration * );

  virtual IIR_Boolean _is_sequential_statement(){
    return TRUE;
  }

  void _clone(IIR_SequentialStatement*);
  IIR *_clone();

protected:
  IIRScram_SequentialStatement() {};
  virtual ~IIRScram_SequentialStatement() = 0;
    
private:
};

#endif
