#ifndef IIRSCRAM_REVERSE_RANGE_ATTRIBUTE_HH
#define IIRSCRAM_REVERSE_RANGE_ATTRIBUTE_HH

// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_ReverseRangeAttribute.hh,v 1.2 1999/03/09 20:56:16 dmartin Exp $
// 
//---------------------------------------------------------------------------

#include "IIRBase_ReverseRangeAttribute.hh"

class IIR_ScalarTypeDefinition;

class IIRScram_ReverseRangeAttribute : public IIRBase_ReverseRangeAttribute {

// @BeginAutoDocExternalProseDescription
// @EndAutoDocExternalProseDescription

public:
  void _publish_vhdl(ostream &);
  void _publish_vhdl_range(ostream &);

  void _publish_cc_range();

  IIR_TextLiteral *_build_attribute_name();
  IIR_TypeDefinition *_get_subtype();
  IIR_Declaration *_get_implicit_declaration( char *, IIR_TypeDefinition * );

   IIR_Boolean _has_suffix(){ return TRUE; }
  void _set_suffix( IIR *new_suffix ){ set_suffix( new_suffix ); }

  IIR* _get_suffix();

  IIR_Boolean _is_range_attribute(){ return TRUE; }

protected:
  void _resolve_suffix_special();

  IIRScram_ReverseRangeAttribute(){
    _my_rval = NULL;
  }

  virtual ~IIRScram_ReverseRangeAttribute() = 0;
    
private:
  IIR_TypeDefinition *_get_prefix_rval();
  IIR_ScalarTypeDefinition *_my_rval;

};
#endif
