// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Radharamanan Radhakrishnan  ramanan@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_RecordTypeDefinition.cc,v 1.3 1999/07/23 21:08:10 dmartin Exp $
// 
//---------------------------------------------------------------------------
#include "IIR_RecordTypeDefinition.hh"
#include "IIR_ElementDeclaration.hh"
#include "IIR_FunctionDeclaration.hh"
#include "IIR_ScalarTypeDefinition.hh"
#include "symbol_table.hh"
#include "resolution_func.hh"
#include "error_func.hh"

IIRScram_RecordTypeDefinition::IIRScram_RecordTypeDefinition(){
}

IIRScram_RecordTypeDefinition::~IIRScram_RecordTypeDefinition(){
}


void 
IIRScram_RecordTypeDefinition::_publish_vhdl_decl(ostream &_vhdl_out) {
  _vhdl_out << "\nrecord\n ";
  element_declarations._publish_vhdl(_vhdl_out);
  _vhdl_out << "\nend record";
}

void 
IIRScram_RecordTypeDefinition::_publish_vhdl_subtype_decl(ostream &_vhdl_out) {
  if(_get_resolution_function() != NULL) {
    _get_resolution_function()->_publish_vhdl(_vhdl_out);
    _vhdl_out << " ";
  }
  
  // The base type can be NULL if I have:
  // type foo is record
  //               first_element : string;
  //             end record;
  //

  // subtype bar is foo;

  // (if you don't believe the base type is NULL in this case, read page 53,
  // the paragraph at the top of the page.

  if( get_base_type() != NULL ){
    get_base_type()->_publish_vhdl(_vhdl_out);
  }
  else{
    ASSERT( _get_declaration() != NULL );
    _get_declaration()->_publish_vhdl(_vhdl_out);
  }
}

void 
IIRScram_RecordTypeDefinition::_publish_cc_decl_type_attributes() {
}

void 
IIRScram_RecordTypeDefinition::_publish_cc_event_constructor_with_aggregates() {
  strstream classStream;

  _cc_out << "(ObjectBase::ObjectType object, int noofElmntAssns, ...) :" << endl;

  IIR_ElementDeclaration* fields;
  fields = element_declarations.first();
  while(fields != NULL) {
    fields->_get_declarator()->_publish_cc();
    _cc_out << "(object";

    if ((fields->get_subtype()->_is_array_type() == TRUE) &&
	(fields->get_subtype()->_is_anonymous() == TRUE)) {
      _cc_out << ", ";
      fields->get_subtype()->_publish_cc_range();
    }
    
    _cc_out << ")";
    
    fields = element_declarations.successor(fields);
    if(fields != NULL) {
      _cc_out << ",\n";
    }
  }
  _cc_out <<" {\n";
  _cc_out << " numberOfFields = ";
  _cc_out << element_declarations.num_elements() << ";\n";
  _publish_cc_constructor_aggregate_init();
  _cc_out << "}\n";
}

void
IIRScram_RecordTypeDefinition::_publish_cc_event_operator_equalto()
{
  _cc_out << "  VHDLType& ";
  _cc_out << "operator=(const VHDLType& arg1) {\n";

  _publish_cc();
  _cc_out << "_event" << "* ptr = (";
  _publish_cc();
  _cc_out << "_event "
	  << " *) &arg1;\n";

  IIR_ElementDeclaration* fields;
  fields = element_declarations.first();
  while(fields != NULL) {
    _cc_out << "this->";
    fields->_get_declarator()->_publish_cc();
    _cc_out << " = ";
    _cc_out << "ptr->";
    fields->_get_declarator()->_publish_cc();    
    _cc_out << ";\n";
    fields = element_declarations.successor(fields);
  }
  _cc_out << "  return *this;" << endl;
  _cc_out << "}\n\n";

  _publish_cc_type_name();
  _cc_out << "_event& operator=(const ";
  _publish_cc_type_name();
  _cc_out << "_event& src)  {\n"
	  << "  return (";
  _publish_cc_type_name();
  _cc_out << "_event &) operator=((const VHDLType &) src);\n"
	  << "}\n\n";
}

void
IIRScram_RecordTypeDefinition::_publish_cc_lastevent_operator_equalto()
{
  _cc_out << "  VHDLType& ";
  _cc_out << "operator=(const VHDLType& arg1) {\n";

  _publish_cc();
  _cc_out << "_lastevent" << "* ptr = (";
  _publish_cc();
  _cc_out << "_lastevent "
	  << " *) &arg1;\n";

  IIR_ElementDeclaration* fields;
  fields = element_declarations.first();
  while(fields != NULL) {
    _cc_out << "this->";
    fields->_get_declarator()->_publish_cc();
    _cc_out << " = ";
    _cc_out << "ptr->";
    fields->_get_declarator()->_publish_cc();    
    _cc_out << ";\n";
    fields = element_declarations.successor(fields);
  }
  _cc_out << "  return *this;" << endl;
  _cc_out << "}\n\n";

  _publish_cc_type_name();
  _cc_out << "_lastevent& operator=(const ";
  _publish_cc_type_name();
  _cc_out << "_lastevent& src)  {\n"
	  << "  return (";
  _publish_cc_type_name();
  _cc_out << "_lastevent &) operator=((const VHDLType &) src);\n"
	  << "}\n\n";
}

void
IIRScram_RecordTypeDefinition::_publish_cc_class_event_get_field()
{
  _cc_out << "  VHDLType& ";
  _cc_out << "get_field(int fieldnumber) const {\n";
  _cc_out << "  switch(fieldnumber) {\n";

  IIR_ElementDeclaration* fields;
  int fieldnumber = 1;
  fields = element_declarations.first();
  while(fields != NULL) {
    _cc_out << "  case " << fieldnumber << ":\n";
    _cc_out << "    return *((VHDLType *) &";
    fields->_get_declarator()->_publish_cc();
    _cc_out << ");\n";
    _cc_out << "    break;\n";
    fields = element_declarations.successor(fields);
    fieldnumber++;
  }
  _cc_out << "  default:\n";
  _cc_out << "    cerr << \"ERROR!!!Illegal reference to record fields\";\n";
  _cc_out << "    abort();\n";
  _cc_out << "    return *((VHDLType *) &";  
  fields = element_declarations.first();
  fields->_get_declarator()->_publish_cc();
  _cc_out << ");\n";
  _cc_out << "  }\n";
  _cc_out << "}\n";
}

void
IIRScram_RecordTypeDefinition::_publish_cc_class_event() {
  IIR_ElementDeclaration* fields;
  
  _cc_out << "#ifndef ";
  _publish_cc();
  _cc_out << "_event_HH" << endl
	  << "#define ";
  _publish_cc();
  _cc_out << "_event_HH" << endl << endl;

  _cc_out << "#include \"RecordType.hh\"" << endl
	  << "#include \"standard.hh\"" << endl
	  << "#include \"";
  _publish_cc();
  _cc_out << ".hh\"" << endl;

  _cc_out << "class ";
  _publish_cc();
  _cc_out << "_event : public RecordType {\npublic:\n";
  
  fields = element_declarations.first();
  while(fields != NULL) {
    _cc_out << "  ";
    if ((fields->get_subtype()->_is_array_type()) || (fields->get_subtype()->_is_record_type())) {
      fields->get_subtype()->_publish_cc_type_name();
      _cc_out << "_event ";
      fields->_get_declarator()->_publish_cc();
    }
    else {
      _cc_out << "EnumerationType";
      _cc_out << " ";
      fields->_get_declarator()->_publish_cc();
    }
    _cc_out << ";\n";
    fields = element_declarations.successor(fields);
  }

  _publish_cc_event_constructor_with_no_arguments();
  _publish_cc_class_event_get_field();

  _publish_cc();
  _cc_out << "_event";
  _publish_cc_event_constructor_with_aggregates();

  _publish_cc_event_operator_equalto();
  
  _cc_out << "~Savant" << *(_get_declaration()->_get_declarator());
  _cc_out << "Type_event() {}\n";
  
  _cc_out << "};\n\n";
  _cc_out << "#endif" << endl;

}

void
IIRScram_RecordTypeDefinition::_publish_cc_class_last_event() {
  IIR_ElementDeclaration* fields;

  _cc_out << "#ifndef ";
  _publish_cc();
  _cc_out << "_lastevent_HH" << endl
	  << "#define ";
  _publish_cc();
  _cc_out << "_lastevent_HH" << endl << endl;
  
  _cc_out << "#include \"RecordType.hh\"" << endl
	  << "#include \"standard.hh\"" << endl
	  << "#include \"";
  _publish_cc();
  _cc_out << ".hh\"" << endl;
  
  _cc_out << "class ";
  _publish_cc();
  _cc_out << "_lastevent : public RecordType {\npublic:\n";
  fields = element_declarations.first();
  while(fields != NULL) {
    _cc_out << "  ";
    if ((fields->get_subtype()->_is_array_type()) || (fields->get_subtype()->_is_record_type())) {
      fields->get_subtype()->_publish_cc_type_name();
      _cc_out << "_lastevent ";
      fields->_get_declarator()->_publish_cc();
    }
    else {
      _cc_out << "EnumerationType";
      _cc_out << " ";
      fields->_get_declarator()->_publish_cc();
    }
    _cc_out << ";\n";
    fields = element_declarations.successor(fields);
  }

  _publish_cc_last_event_constructor_with_no_arguments();
  _publish_cc_class_event_get_field();

  _publish_cc();
  _cc_out << "_lastevent";
  _publish_cc_event_constructor_with_aggregates();
  
  _publish_cc_lastevent_operator_equalto();

  _cc_out << "~Savant" << *(_get_declaration()->_get_declarator());
  _cc_out << "Type_lastevent() {};\n";
   
  _cc_out << "};\n\n";
  _cc_out << "#endif" << endl;
}

IIR_TypeDefinition * 
IIRScram_RecordTypeDefinition::_get_element_subtype( int index ){
  IIR_TypeDefinition *retval = NULL;

  ASSERT( index <= element_declarations.num_elements() );

  IIR_ElementDeclaration *element_decl;
  
  element_decl = element_declarations.get_nth_element( index );
  retval = element_decl->get_subtype();

  return retval;
}


set<IIR_Declaration> *
IIRScram_RecordTypeDefinition::_find_declarations( IIR_Name *to_find ){
  return element_declarations._find_declarations( to_find );
}

void
IIRScram_RecordTypeDefinition::_publish_cc_necessary_decl_in_state() {

  // The value of _current_publish_name should be set to the variable's
  // name that is being published. The control drops here usually from
  // IIRScram_EventAttribute
  
  _publish_cc();
  _cc_out << "_event ";

  _cc_out << _current_publish_name;
  _cc_out << "_event;\n";

  _publish_cc();
  _cc_out << "_last_event ";
  _cc_out << _current_publish_name;
  _cc_out << "_last_event;\n";
}

void
IIRScram_RecordTypeDefinition::_publish_cc_init_fields_for_signals() {
}


void 
IIRScram_RecordTypeDefinition::_publish_cc_kernel_type() {
  _cc_out << "RecordType";
}

void 
IIRScram_RecordTypeDefinition::_publish_cc_constructor_args() {
  //I have nothing to do here
}

void 
IIRScram_RecordTypeDefinition::_publish_cc_decl_constructors() {

  //Declarations for the constructor
  _publish_cc_type_name();
  _cc_out << "();\n";
  
  _publish_cc_type_name();
  _cc_out << "(ObjectBase::ObjectType, const TypeInfo&"
	  << " = TypeInfo::NULL_TYPE_INFO);\n";
  
  _publish_cc_type_name();
  _cc_out << "(ObjectBase::ObjectType, ";
  _publish_cc_type_name();
  _cc_out << "&);\n";

  if(_is_subtype_decl() == TRUE) {
    _publish_cc_type_name();
    _cc_out << "(ObjectBase::ObjectType, ";
    _publish_cc_parent_type_name();
    _cc_out << "&);\n";
  }

  _publish_cc_type_name();
  _cc_out << "(ObjectBase::ObjectType, ";
  _cc_out << " int noofElmntAssns, ...);" << endl;

  _publish_cc_type_name();
  _cc_out << "(bool, ObjectBase::ObjectType, RecordType &);" << endl;
}


void 
IIRScram_RecordTypeDefinition::_publish_cc_decl_destructors() {
  //declaration for the destructor
  _cc_out << "virtual ~";
  _publish_cc_type_name();
  _cc_out << "();\n";
}

void 
IIRScram_RecordTypeDefinition::_publish_cc_decl_operator_equalto() {
  // Publish the declaration of operator =
  _cc_out << "virtual VHDLType& operator=(const VHDLType&);" << endl;
  _cc_out << "virtual ";
  _publish_cc_type_name();
  _cc_out << "& operator=(const ";
  _publish_cc_type_name();
  _cc_out << " &);" << endl;
}


void 
IIRScram_RecordTypeDefinition::_publish_cc_data_members() {

  //publish the declaration for get_field()
  _cc_out << "virtual VHDLType& get_field(int) const;\n";

  //Publish the record's members
  _publish_cc_record_fields();
}

void 
IIRScram_RecordTypeDefinition::_publish_cc_decl_cc() {
  _publish_cc_constructor_with_arguments();
  _publish_cc_constructor_with_no_arguments();  
  _publish_cc_constructor_with_aggregates();
  _publish_cc_constructor_for_alias_init();
  _publish_cc_destructor();
  _publish_cc_operator_equalto();

  if (_is_subtype_decl() == FALSE) {
    _publish_cc_get_field();
  }

  //  _publish_cc_decl_relational_operators();
  _publish_cc_decl_operators();
}

void 
IIRScram_RecordTypeDefinition::_publish_cc_constructor_with_no_arguments() {

  char *className = NULL;
  strstream classStream;

  classStream << "Savant" << *(_get_declaration()->_get_declarator());
  classStream << "Type" << ends;

  className = classStream.str();

  _cc_out << className << "::" << className << "() : ";
  if (_is_subtype_decl() == FALSE) {
    _cc_out << "RecordType";
  }
  else {
    get_base_type()->_publish_cc_type_name();
  }
  _cc_out << "() {}\n\n";
  
  _cc_out << className << "::" << className;
  _cc_out << "(ObjectBase::ObjectType objType, const TypeInfo &) "
	  << endl << "  :";
  
  if (_is_subtype_decl() == FALSE) {
    IIR_ElementDeclaration* fields;
    fields = element_declarations.first();
    while(fields != NULL) {
      fields->_get_declarator()->_publish_cc();
      _cc_out << "(objType";
      if (fields->_get_subtype()->_is_kernel_type() == FALSE &&
	  fields->_get_subtype()->_is_anonymous() == FALSE &&
	  fields->_get_subtype()->_is_scalar_type() == TRUE){
	fields->_get_subtype()->_publish_cc_object_type_info();
      }
      if ((fields->get_subtype()->_is_array_type() == TRUE) &&
	  (fields->get_subtype()->_is_anonymous() == TRUE)) {
	_cc_out << ", ";
	fields->get_subtype()->_publish_cc_range();
      }
      
      _cc_out << ")";
      
      fields = element_declarations.successor(fields);
      if(fields != NULL) {
	_cc_out << ",\n";
      }
    }
    _cc_out <<" {\n";
    _cc_out << " numberOfFields = ";
    _cc_out << element_declarations.num_elements() << ";\n";
    
    _cc_out << "}\n";
  }
  else {
    get_base_type()->_publish_cc_type_name();
    _cc_out << "(objType) \n{\n";
    _publish_cc_set_resolution_function();
    _cc_out << "}\n";
  }
  delete [] className;
}

void 
IIRScram_RecordTypeDefinition::_publish_cc_constructor_with_arguments() {

  char *className = NULL;
  strstream classStream;

  classStream << "Savant" << *(_get_declaration()->_get_declarator());
  classStream << "Type" << ends;

  className = classStream.str();
  _cc_out << className << "::" << className;
  _cc_out << "(ObjectBase::ObjectType objType, " << className << "& arg1)" << endl << "  :";

  if (_is_subtype_decl() == FALSE) {
    IIR_ElementDeclaration* fields;
    fields = element_declarations.first();
    while(fields != NULL) {
      fields->_get_declarator()->_publish_cc();
      _cc_out << "(objType";
      if (fields->_get_subtype()->_is_kernel_type() == FALSE &&
	  fields->_get_subtype()->_is_anonymous() == FALSE &&
	  fields->_get_subtype()->_is_scalar_type() == TRUE){
	fields->_get_subtype()->_publish_cc_object_type_info();
      }
      if ((fields->get_subtype()->_is_array_type() == TRUE) &&
	  (fields->get_subtype()->_is_anonymous() == TRUE)) {
	_cc_out << ", ";
	fields->get_subtype()->_publish_cc_range();
      }
      
      _cc_out << ")";
      
      fields = element_declarations.successor(fields);
      if(fields != NULL) {
	_cc_out << ",\n";
      }
    }

    _cc_out <<" {\n";
    _cc_out << " numberOfFields = ";
    _cc_out << element_declarations.num_elements() << ";\n";
    _cc_out << " this->operator=(arg1);\n";
    _cc_out << "}\n";
  }
  else {
    get_base_type()->_publish_cc_type_name();
    _cc_out << "(objType, arg1) \n{\n";
    _publish_cc_set_resolution_function();
    _cc_out << "}\n";
  }

  if(_is_subtype_decl() == TRUE) {
    _cc_out << className << "::" << className;
    _cc_out << "(ObjectBase::ObjectType objType, ";
    _publish_cc_parent_type_name();
    _cc_out << "& val) : ";
    _publish_cc_parent_type_name();
    _cc_out << "(objType) {" << endl;
    _cc_out << " *this = (";
    _publish_cc_type_name();
    _cc_out << " &)val;" << endl;
    _cc_out << "}" << endl;
  }

  delete [] className;
}

void 
IIRScram_RecordTypeDefinition::_publish_cc_constructor_with_aggregates() {
  strstream classStream;

  _publish_cc_type_name();
  _cc_out << "::";
  _publish_cc_type_name();
  _cc_out << "(ObjectBase::ObjectType objType, int noofElmntAssns, ...) " << endl << "  :";

  if (_is_subtype_decl() == FALSE) {
    IIR_ElementDeclaration* fields = NULL;
    fields = element_declarations.first();
    while(fields != NULL) {
      fields->_get_declarator()->_publish_cc();
      _cc_out << "(objType";
      if (fields->_get_subtype()->_is_kernel_type() == FALSE &&
	  fields->_get_subtype()->_is_anonymous() == FALSE &&
	  fields->_get_subtype()->_is_scalar_type() == TRUE){
	fields->_get_subtype()->_publish_cc_object_type_info();
      }
      if ((fields->get_subtype()->_is_array_type() == TRUE) &&
	  (fields->get_subtype()->_is_anonymous() == TRUE)) {
	_cc_out << ", ";
	fields->get_subtype()->_publish_cc_range();
      }
      
      _cc_out << ")";
      
      fields = element_declarations.successor(fields);
      if(fields != NULL) {
	_cc_out << ",\n";
      }
    }
  }
  else {
    get_base_type()->_publish_cc_type_name();
    _cc_out << "(objType)\n";
  }
  _cc_out <<" {\n";
  if (_is_subtype_decl() == FALSE){
    _cc_out << " numberOfFields = ";
    _cc_out << element_declarations.num_elements() << ";\n";
  }
  _publish_cc_constructor_aggregate_init();
  _publish_cc_set_resolution_function();
  _cc_out << "}\n";

}

void 
IIRScram_RecordTypeDefinition::_publish_cc_constructor_aggregate_init() {
    
  _cc_out <<"  va_list ap; " << endl;
  _cc_out << "  ElementAssociation* elmtptr; " << endl;
  _cc_out << "  ElementAssociation* othersAssociation; " << endl;
  _cc_out << "  ElementAssociation** elmtAssocArray; " << endl;
  _cc_out << "  char* charptr = NULL; " << endl;
  _cc_out << "  int i=0; " << endl;
  _cc_out << "  int j=0; " << endl;
  _cc_out << " " << endl;
  _cc_out << "  charptr = new char[numberOfFields+1]; " << endl;
  _cc_out << "  elmtAssocArray = (ElementAssociation**) new char[noofElmntAssns * " << endl;
  _cc_out << "						  sizeof(ElementAssociation*)]; " << endl;
  _cc_out << "  for (i=1; i <= numberOfFields; i++) { " << endl;
  _cc_out << "    charptr[i] = 'U'; " << endl;
  _cc_out << "  } " << endl;
  _cc_out << " " << endl;
  _cc_out << "  va_start(ap, noofElmntAssns); " << endl;
  _cc_out << "  for(i =0; i < noofElmntAssns; i++) { " << endl;
  _cc_out << "    elmtAssocArray[i] = va_arg(ap, ElementAssociation*); " << endl;
  _cc_out << "  } " << endl;
  _cc_out << "  va_end(ap); " << endl;
  _cc_out << "     " << endl;
  _cc_out << "  for(i =0; i < noofElmntAssns; i++) { " << endl;
  _cc_out << "    elmtptr = elmtAssocArray[i]; " << endl;
  _cc_out << "    if(elmtptr->choice == Others) { " << endl;
  _cc_out << "      othersAssociation = elmtptr; " << endl;
  _cc_out << "      break; " << endl;
  _cc_out << "    } " << endl;
  _cc_out << "    else { " << endl;
  _cc_out << "      if(elmtptr->choice.left() == elmtptr->choice.right()) { " << endl;
  _cc_out << "	this->get_field(elmtptr->choice.left()).assignVal(*elmtptr->value); " << endl;
  _cc_out << "	charptr[elmtptr->choice.left()] = 'I'; " << endl;
  _cc_out << " " << endl;
  _cc_out << "      } " << endl;
  _cc_out << "      else { " << endl;
  _cc_out << "	if(elmtptr->choice.dirn() == to) { " << endl;
  _cc_out << "	  for(j=elmtptr->choice.left(); j <= elmtptr->choice.right(); j++) { " << endl;
  _cc_out << "	    this->get_field(j).assignVal(*elmtptr->value); " << endl;
  _cc_out << "	    charptr[j] = 'I'; " << endl;
  _cc_out << "	  } " << endl;
  _cc_out << "	} " << endl;
  _cc_out << "	else { " << endl;
  _cc_out << "	  for(j=elmtptr->choice.left(); j >= elmtptr->choice.right(); j--) { " << endl;
  _cc_out << "	    this->get_field(j).assignVal(*elmtptr->value);	   " << endl;
  _cc_out << "	    charptr[j] = 'I'; " << endl;
  _cc_out << "	  } " << endl;
  _cc_out << "	} " << endl;
  _cc_out << "      } " << endl;
  _cc_out << "    } " << endl;
  _cc_out << "  } " << endl;
  _cc_out << " " << endl;
  _cc_out << "  for(i=1; i <= numberOfFields ; i++) { " << endl;
  _cc_out << "    if(charptr[i] == 'U') { " << endl;
  _cc_out << "      this->get_field(i).assignVal(*othersAssociation->value); " << endl;
  _cc_out << "    } " << endl;
  _cc_out << "  } " << endl;
  _cc_out << " " << endl;
  _cc_out << "  for(i =0; i < noofElmntAssns; i++) { " << endl;
  _cc_out << "    delete  elmtAssocArray[i]->value; " << endl;
  _cc_out << "    delete  elmtAssocArray[i]; " << endl;
  _cc_out << "  } " << endl;
  _cc_out << " " << endl;
  _cc_out << "  if(elmtAssocArray != NULL) { " << endl;
  _cc_out << "    delete [] elmtAssocArray; " << endl;
  _cc_out << "  } " << endl;
  _cc_out << "  delete [] charptr; " << endl;
}

void 
IIRScram_RecordTypeDefinition::_publish_cc_destructor() {

  char *className = NULL;
  strstream classStream;

  classStream << "Savant" << *(_get_declaration()->_get_declarator());
  classStream << "Type" << ends;

  className = classStream.str();
  _cc_out << className << "::~" << className << "() {}\n";
  delete [] className;
}

void
IIRScram_RecordTypeDefinition::_publish_cc_operator_equalto() {

  char *className;
  strstream classStream;

  classStream << "Savant" << *(_get_declaration()->_get_declarator());
  classStream << "Type" << ends;

  className = classStream.str();
 
  _cc_out << "  VHDLType& " << className;
  _cc_out << "::operator=(const VHDLType& arg1) {\n";
  _cc_out << className << "* ptr = (";
  _cc_out << className << " *) &arg1;\n";

  IIR_ElementDeclaration* fields;
  fields = element_declarations.first();
  while(fields != NULL) {
    _cc_out << "this->";
    fields->_get_declarator()->_publish_cc();
    _cc_out << " = ";
    _cc_out << "ptr->";
    fields->_get_declarator()->_publish_cc();    
    _cc_out << ";\n";
    fields = element_declarations.successor(fields);
  }
  _cc_out << "  return *this;" << endl;
  _cc_out << "}\n\n";

  _cc_out << className << "&\n";
  _publish_cc_type_name();
  _cc_out << "::operator=(const " << className << "& src)  {\n"
	  << "  return (" << className << " &) operator=((const VHDLType &)"
	  << " src);\n"
	  << "}\n\n";
  
  delete [] className;
}

void 
IIRScram_RecordTypeDefinition::_publish_cc_get_field() {

  char *className = NULL;
  strstream classStream;

  classStream << "Savant" << *(_get_declaration()->_get_declarator());
  classStream << "Type" << ends;

  className = classStream.str();
  _cc_out << "  VHDLType& " << className;
  _cc_out << "::get_field(int fieldnumber) const {\n";
  _cc_out << "  switch(fieldnumber) {\n";

  IIR_ElementDeclaration* fields;
  int fieldnumber = 1;
  fields = element_declarations.first();
  while(fields != NULL) {
    _cc_out << "  case " << fieldnumber << ":\n";
    _cc_out << "    return *((VHDLType *) &";
    fields->_get_declarator()->_publish_cc();
    _cc_out << ");\n";
    _cc_out << "    break;\n";
    fields = element_declarations.successor(fields);
    fieldnumber++;
  }
  _cc_out << "  default:\n";
  _cc_out << "    cerr << \"ERROR!!!Illegal reference to record fields\";\n";
  _cc_out << "    abort();\n";
  _cc_out << "    return *((VHDLType *) &";  
  fields = element_declarations.first();
  fields->_get_declarator()->_publish_cc();
  _cc_out << ");\n";
  _cc_out << "  }\n";
  _cc_out << "}\n";
  delete [] className;
}

IIR_Boolean
IIRScram_RecordTypeDefinition::_has_access_type() {
  IIR_ElementDeclaration* fields;
  fields = element_declarations.first();
  while(fields != NULL) {
    if(fields->get_subtype()->_has_access_type() == TRUE) {
      return TRUE;;
    }
    fields = element_declarations.successor(fields);
  }
  return FALSE;
}

void
IIRScram_RecordTypeDefinition::_publish_cc_headers() {

  IIR_ElementDeclaration* fields;
  fields = element_declarations.first();
  while(fields != NULL) {
    _cc_out << "#include \"";
    fields->_publish_cc_type_name();
    _cc_out << ".hh\"\n";
    fields = element_declarations.successor(fields);
  }

  if(_has_access_type() == FALSE) {
    _cc_out << "#include \"";
    _publish_cc();
    _cc_out << "_event.hh\"\n";
    
    _cc_out << "#include \"";
    _publish_cc();
    _cc_out << "_lastevent.hh\"" << endl << endl;
  }
  else {
    _cc_out << "#include \"RecordType.hh\"" << endl;
  }
  //Publishing the extern type info for scalar fields
  fields = element_declarations.first();
  while(fields != NULL) {
    if (fields->_get_subtype()->_is_scalar_type() == TRUE) {
      fields->_get_subtype()->_publish_cc_extern_type_info();
    }
    
    fields = element_declarations.successor(fields);
  }
}


void 
IIRScram_RecordTypeDefinition::_publish_cc_record_fields() {

  IIR_ElementDeclaration* fields;
  fields = element_declarations.first();
  while(fields != NULL) {
    fields->_publish_cc_type_name();
    _cc_out << " ";
    fields->_get_declarator()->_publish_cc();
    _cc_out << ";\n";
    fields = element_declarations.successor(fields);
  }
}

void 
IIRScram_RecordTypeDefinition::_publish_cc_init_signal() {


  char nameBuf[128];
  char anothernameBuf[128];
  char suffixnameBuf[128];
  ostrstream tmpname(nameBuf, 128, ios::out);
  ostrstream tmpanothername(anothernameBuf, 128, ios::out);
  ostrstream tmpsuffixname(suffixnameBuf, 128, ios::out);
  
  char* tmpPtr1 = _current_publish_name;
  char* tmpPtr2 = _current_another_name;
  char* tmpPtr3 = _current_suffix_name;
  IIR_ElementDeclaration* element_decls;
  
  _cc_out << "{\n";//begin dummy block for scoping
  element_decls = element_declarations.first();

  int field_index = 1;
  while(element_decls != NULL) {

    _current_another_name = tmpPtr2;
    _current_publish_name = tmpPtr1;
    _current_suffix_name  = tmpPtr3;
    
    _cc_out << "{\n"; // begin dummy block for scoping
    
    tmpanothername << _current_another_name << "."
		   << *(element_decls->_get_declarator()) << ends;
    tmpname << _current_publish_name << "."
	    << *(element_decls->_get_declarator()) << ends;
    
    _current_publish_name = nameBuf;
    _current_another_name = anothernameBuf;
    
    if (element_decls->get_subtype()->_is_record_type())  {
      char *temp_current_publish_name = _current_publish_name;
      char *temp_current_another_name = _current_another_name;
      char *temp_current_suffix_name  = _current_suffix_name;
      
      ostrstream tmpname;
      ostrstream tmpanothername;
      ostrstream tmpsuffixname;
      
      tmpname << _current_publish_name << ends;
      tmpanothername << _current_another_name << ends;
      if (_current_suffix_name != NULL) {
	tmpsuffixname << _current_suffix_name << "."
		      << *(element_decls->_get_declarator()) << ends;
      }
      else {
	tmpsuffixname << "." << *(element_decls->_get_declarator()) << ends;
      }
      
      _current_publish_name = tmpname.str();
      _current_another_name = tmpanothername.str();
      _current_suffix_name  = tmpsuffixname.str();
      
      element_decls->get_subtype()->_publish_cc_init_signal();

      _current_publish_name = temp_current_publish_name;
      _current_another_name = temp_current_another_name;
      _current_suffix_name  = temp_current_suffix_name;
    }
    else {
      if (_current_suffix_name != NULL) {
	tmpsuffixname << _current_suffix_name
		      << "." << *(element_decls->_get_declarator()) << ends;
      }
      else {
	tmpsuffixname << "." << *(element_decls->_get_declarator()) << ends;
      }

      _current_suffix_name  = suffixnameBuf;
	  
      element_decls->get_subtype()->_publish_cc_init_signal();
    }
    
    _cc_out << "}\n"; // code block for dummy scoping
    
    tmpname.seekp(0);
    tmpanothername.seekp(0);
    tmpsuffixname.seekp(0);
    
    field_index++;
    element_decls = element_declarations.successor(element_decls);
  }

  _cc_out << "};\n";//end dummy block
  _current_publish_name = tmpPtr1;
  _current_another_name = tmpPtr2;
  _current_suffix_name  = tmpPtr3;
}

void 
IIRScram_RecordTypeDefinition::_publish_cc_composite_init() {

  ostrstream tmpname;

  char* tmpPtr1 = _current_publish_name;

  IIR_ElementDeclaration* element_decls;
  _cc_out << "{\n";//begin dummy block for scoping
  element_decls = element_declarations.first();

  int field_index = 1;
  while(element_decls != NULL) {

    //     tmpname << tmpPtr1 << ".get_field(";
    tmpname << tmpPtr1 << "." << *(element_decls->_get_declarator()) << ends;
    
    // tmpname  << field_index << ")" << ends;

    _current_publish_name = tmpname.str();

    // Need this check to adjust _current_publish_name when
    // recursively publishing fields

    if (element_decls->get_subtype()->get_kind() == IIR_RECORD_TYPE_DEFINITION) {
      ostrstream tempname;
      
      tempname << "(*((";
      if (element_decls->get_subtype()->_is_scalar_type() == FALSE) {
	tempname << "Savant"
		 << *(element_decls->get_subtype()->_get_declarator())
		 << "Type";
      }
      else {
	tempname << "ScalarType";
      }
      
      tempname << " *) &" << _current_publish_name
	       << "))" << ends;
      
      _current_publish_name = tempname.str();
      
      element_decls->get_subtype()->_publish_cc_composite_init();
      
      _current_publish_name = tmpname.str();
    }
    else {
      element_decls->get_subtype()->_publish_cc_composite_init();
    }
    
    tmpname.seekp(0);

    field_index++;
    element_decls = element_declarations.successor(element_decls);
  }

  _cc_out << "};\n";//end dummy block
  _current_publish_name = tmpPtr1;
}

void
IIRScram_RecordTypeDefinition::_publish_cc_decl_operators() {
  if(_is_subtype_decl() == FALSE) {
    _publish_cc_decl_relational_operators();
  }
}

void
IIRScram_RecordTypeDefinition::_publish_cc_equality_operator() {
  _cc_out << "EnumerationType" << endl;
  _cc_out << "savantEqual(const ";
  _publish_cc();
  _cc_out << "& lhs, const ";
  _publish_cc();
  _cc_out << "& rhs)  {" << endl;

  _cc_out << "  if (lhs.get_number_of_elements() != "
	  << "rhs.get_number_of_elements())  {" << endl;
  _cc_out << "    return SAVANT_BOOLEAN_FALSE;" << endl;
  _cc_out << "  }" << endl << endl;

  IIR_ElementDeclaration *fields;
  fields = element_declarations.first();
  while(fields != NULL) {
    _cc_out << "  if (SAVANT_BOOLEAN_FALSE == savantEqual(lhs.";
    fields->_get_declarator()->_publish_cc();
    _cc_out << ", rhs.";
    fields->_get_declarator()->_publish_cc();
    _cc_out << "))  {" << endl;
    _cc_out << "    return SAVANT_BOOLEAN_FALSE;" << endl;
    _cc_out << "  }" << endl << endl;
    
    fields = element_declarations.successor(fields);
  }

  _cc_out << "  return SAVANT_BOOLEAN_TRUE;" << endl;
  _cc_out << "}" << endl << endl;
}

void
IIRScram_RecordTypeDefinition::_publish_cc_inequality_operator() {
  _cc_out << "EnumerationType" << endl;
  _cc_out << "savantNotEqual(const ";
  _publish_cc();
  _cc_out << "& lhs, const ";
  _publish_cc();
  _cc_out << "& rhs)  {" << endl;

  _cc_out << "  return savantNot(savantEqual(lhs, rhs));" << endl;
  _cc_out << "}" << endl << endl;
}

void 
IIRScram_RecordTypeDefinition::_publish_cc_event_constructor_with_no_arguments() {

  char *className = NULL;
  strstream classStream;

  classStream << "Savant" << *(_get_declaration()->_get_declarator());
  classStream << "Type_event" << ends;

  className = classStream.str();

  _cc_out << className << "() : RecordType () {}\n\n";
  
  _cc_out << className;
  _cc_out << "(ObjectBase::ObjectType object, "
	  << "const TypeInfo& = TypeInfo::NULL_TYPE_INFO):";
  
  IIR_ElementDeclaration* fields;
  fields = element_declarations.first();
  while(fields != NULL) {
    fields->_get_declarator()->_publish_cc();
    _cc_out << "(object";
    
    if ((fields->get_subtype()->_is_array_type() == TRUE) &&
	(fields->get_subtype()->_is_anonymous() == TRUE)) {
      _cc_out << ", ";
      fields->get_subtype()->_publish_cc_range();
    }
    
    _cc_out << ")";
    
    fields = element_declarations.successor(fields);
    if(fields != NULL) {
      _cc_out << ",\n";
    }
  }
  
  _cc_out <<" {";
  _cc_out << "}\n\n";
  delete [] className;
}

void 
IIRScram_RecordTypeDefinition::_publish_cc_last_event_constructor_with_no_arguments() {

  char *className = NULL;
  strstream classStream;

  classStream << "Savant" << *(_get_declaration()->_get_declarator());
  classStream << "Type_lastevent" << ends;
  
  className = classStream.str();
  
  _cc_out << className;
  _cc_out << "(ObjectBase::ObjectType object = ObjectBase::VARIABLE, "
	  << "const TypeInfo& = TypeInfo::NULL_TYPE_INFO):";

  IIR_ElementDeclaration* fields;
  fields = element_declarations.first();
  while(fields != NULL) {
    fields->_get_declarator()->_publish_cc();
    _cc_out << "(object";

    if ((fields->get_subtype()->_is_array_type() == TRUE) &&
	(fields->get_subtype()->_is_anonymous() == TRUE)) {
      _cc_out << ", ";
      fields->get_subtype()->_publish_cc_range();
    }
    
    _cc_out << ")";
	
    fields = element_declarations.successor(fields);
    if(fields != NULL) {
      _cc_out << ",\n";
    }
  }
  _cc_out <<" {";
  _cc_out << "}\n\n";
  delete [] className;
}

void
IIRScram_RecordTypeDefinition::_publish_cc_constructor_for_alias_init() {
  IIR_ElementDeclaration* fields = NULL;
    
  _publish_cc_type_name();
  _cc_out << "::";
  _publish_cc_type_name();
  _cc_out << "( bool alias, ObjectBase::ObjectType objType, "
	  << "RecordType &actual) : " << endl;

  if (_is_subtype_decl() == FALSE) {
    fields = element_declarations.first();

    while(fields != NULL) {
      if (fields->_get_subtype()->_is_scalar_type()) {
	fields->_get_declarator()->_publish_cc();
	_cc_out << "(alias, ((";
	_publish_cc_type_name();
	_cc_out << " &) actual).";
	fields->_get_declarator()->_publish_cc();
	_cc_out << ")" << endl;
      }
      else if (fields->_get_subtype()->_is_record_type()) {
	fields->_get_declarator()->_publish_cc();
	_cc_out << "(alias, objType, ((";
	_publish_cc_type_name();
	_cc_out << " &) actual).";
	fields->_get_declarator()->_publish_cc();
	_cc_out << ")" << endl;
      }
      else if (fields->_get_subtype()->_is_iir_array_type_definition()) {
	fields->_get_declarator()->_publish_cc();
	_cc_out << "(alias, objType ";
	if (fields->_get_subtype()->_get_num_indexes() == 1) {
	  _cc_out << ", ";
	  fields->_get_subtype()->_get_index_subtype()->_publish_cc_range();
	}
	
	_cc_out << ", (( ";
	_publish_cc_type_name();
	_cc_out << " &) actual).";
	fields->_get_declarator()->_publish_cc();

	if (fields->_get_subtype()->_get_num_indexes() == 1) {
	  _cc_out << ", nullInfo" << endl;
	}
	
	_cc_out << ")";
      }
      else if (fields->_get_subtype()->_is_access_type()) {
	fields->_get_declarator()->_publish_cc();
	_cc_out << "(alias, ((const ";
	_publish_cc_type_name();
	_cc_out << " &) actual).";
	fields->_get_declarator()->_publish_cc();
	_cc_out << ")" << endl;
      }
      else {
	cerr << "IIRScram_RecordTypeDefinition::"
	     << "_publish_cc_constructor_for_alias_init() : Error - Unknown type"
	     << endl;
      }

      fields = element_declarations.successor(fields);
      if(fields != NULL) {
	_cc_out << ",\n";
      }
    }
  }  
  else {
    get_base_type()->_publish_cc_type_name();
    _cc_out << "(alias, objType, actual)" << endl;
  }

  _cc_out <<" {";
  _cc_out << "}\n\n";
}

void
IIRScram_RecordTypeDefinition::_publish_cc_universal_type(){
  _cc_out << "RecordType";
}

IIR_ScalarTypeDefinition*
IIRScram_RecordTypeDefinition::_get_index_subtype(){
  return NULL;
}

ostream &
IIRScram_RecordTypeDefinition::_print( ostream &os ){
  os << "record ";

  IIR_ElementDeclaration *current_decl = element_declarations.first();

  if( current_decl != NULL ){
    os << *current_decl << " : " << *current_decl->_get_subtype()->_get_declarator();
    
    current_decl = element_declarations.successor( current_decl );
    while( current_decl != NULL ){
      os << ", " << *current_decl << " : " << *current_decl->_get_subtype()->_get_declarator();
      current_decl = element_declarations.successor( current_decl );
    }
  }

  os << " end record";

  return os;
}

IIR_TypeDefinition *
IIRScram_RecordTypeDefinition::_construct_new_subtype( IIR_Name *resolution_function,
						       IIR_ScalarTypeDefinition *new_constraint ){

  IIR_TypeDefinition *retval;

  retval = _construct_new_subtype_resolution_function_only( resolution_function, new_constraint );
  
  return retval;
}

IIR_TypeDefinition *
IIRScram_RecordTypeDefinition::_get_new_subtype(){
  IIR_TypeDefinition *retval = new IIR_RecordTypeDefinition();
  copy_location( this, retval );
  return retval;
}

void 
IIRScram_RecordTypeDefinition::_clone( IIR_RecordTypeDefinition *copy_into ){
  ASSERT( copy_into->_is_iir_record_type_definition() == TRUE );
  
  copy_into->_set_declaration( _get_declaration() );
  copy_into->_set_type_mark( _get_type_mark() );
  copy_into->set_resolution_function( get_resolution_function() );
  // This copies the elements over.
  copy_into->element_declarations = element_declarations;
  // This should take care of anything else:
  IIR_TypeDefinition::_clone( copy_into );
}

IIR *
IIRScram_RecordTypeDefinition::_clone(){
  IIR_RecordTypeDefinition *retval;
  IIR_TypeDefinition *temp = _get_new_subtype();

  ASSERT( temp->_is_iir_record_type_definition() == TRUE );
  retval = (IIR_RecordTypeDefinition *)temp;

  _clone( retval );

  ASSERT( retval->element_declarations.num_elements() == element_declarations.num_elements() );
  ASSERT( retval->get_kind() == get_kind() );

  return retval;
}

void 
IIRScram_RecordTypeDefinition::_make_interface_visible( symbol_table *sym_tab ){
  sym_tab->make_visible( &element_declarations );
}

IIR_Boolean 
IIRScram_RecordTypeDefinition::_is_locally_static(){
  IIR_Boolean retval = TRUE;

  IIR_ElementDeclaration *current_decl = element_declarations.first();
  while( current_decl != NULL ){
    ASSERT( current_decl->get_subtype() != NULL );
    if( current_decl->get_subtype()->_is_locally_static() == FALSE ){
      retval = FALSE;
      break;
    }
    current_decl = element_declarations.successor( current_decl );
  }

  return retval;
}

IIR_Boolean 
IIRScram_RecordTypeDefinition::_is_globally_static(){
  IIR_Boolean retval = TRUE;

  IIR_ElementDeclaration *current_decl = element_declarations.first();
  while( current_decl != NULL ){
    ASSERT( current_decl->get_subtype() != NULL );
    if( current_decl->get_subtype()->_is_globally_static() == FALSE ){
      retval = FALSE;
      break;
    }
    current_decl = element_declarations.successor( current_decl );
  }

  return retval;
}


void 
IIRScram_RecordTypeDefinition::_come_into_scope( symbol_table *sym_tab, 
						 IIR_TypeDeclaration *td ){
  sym_tab->get_in_scope_record_types()->add( (IIR_RecordTypeDefinition *)this );
  IIR_TypeDefinition::_come_into_scope( sym_tab, td );
}

void 
IIRScram_RecordTypeDefinition::_come_out_of_scope( symbol_table *sym_tab ){
  sym_tab->get_in_scope_record_types()->remove( (IIR_RecordTypeDefinition *)this );
}
