// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_RangeAttribute.cc,v 1.4 1999/10/07 14:05:06 dmartin Exp $
// 
//---------------------------------------------------------------------------
#include "IIRScram_RangeAttribute.hh"
#include "IIR_AscendingAttribute.hh"
#include "IIR_LeftAttribute.hh"
#include "IIR_Identifier.hh"
#include "IIR_RightAttribute.hh"
#include "IIR_TypeDeclaration.hh"
#include "IIR_IntegerLiteral.hh"
#include "error_func.hh"
#include "set.hh"

IIRScram_RangeAttribute::~IIRScram_RangeAttribute() {}

void 
IIRScram_RangeAttribute::_publish_vhdl(ostream &_vhdl_out) {
  ASSERT(get_prefix() != NULL);
  get_prefix()->_publish_vhdl(_vhdl_out);
  _vhdl_out << "'RANGE ";
  if (get_suffix() != NULL) {
    _vhdl_out << "(";
    get_suffix()->_publish_vhdl(_vhdl_out);
    _vhdl_out << ")";
  }
}

void
IIRScram_RangeAttribute::_publish_vhdl_range(ostream &_vhdl_out) {
  _publish_vhdl(_vhdl_out);
}

void 
IIRScram_RangeAttribute::_publish_cc_range() {
  ASSERT(get_prefix() != NULL);

  IIR_LeftAttribute *left_attr = new IIR_LeftAttribute();
  copy_location( this, left_attr );
  left_attr->set_prefix(get_prefix());
  left_attr->set_suffix(get_suffix());
  
  IIR_AscendingAttribute *ascending_attr = new IIR_AscendingAttribute();
  copy_location( this, ascending_attr );
  ascending_attr->set_prefix(get_prefix());
  ascending_attr->set_suffix(get_suffix());

  IIR_RightAttribute *right_attr = new IIR_RightAttribute();
  copy_location( this, right_attr );
  right_attr->set_prefix(get_prefix());
  right_attr->set_suffix(get_suffix());

  left_attr->_publish_cc_value();
  _cc_out << ", ((";
  ascending_attr->_publish_cc();
  _cc_out << " == SAVANT_BOOLEAN_TRUE)? to : downto), ";
  right_attr->_publish_cc_value();

  delete left_attr;
  delete ascending_attr;
  delete right_attr;
  ASSERT(get_prefix() != NULL);
}


IIR_TextLiteral *
IIRScram_RangeAttribute::_build_attribute_name() {
  char *name = "range";
  return IIR_Identifier::get( name, strlen(name) );
}


IIR_TypeDefinition *
IIRScram_RangeAttribute::_get_subtype(){
  IIR_TypeDefinition *retval = NULL;

  IIR_TypeDefinition *prefix_rval = _get_prefix_subtype();
  if( get_suffix() == NULL ){
    retval = (IIR_TypeDefinition*)prefix_rval->_get_index_subtype();
  }
  else{
    IIR_IntegerLiteral *static_val = get_suffix()->_get_integer_static_value();
    if( static_val != NULL ){
      int val = static_val->_get_value();
      if( val > prefix_rval->_get_num_indexes() ){
	ostrstream err;
	err << "'range( " << val << " ) not allowed for " 
	    << prefix_rval->_get_num_indexes() << " dimensional array." << ends;
	report_error( this, err );
      }
      else{
	IIR_TypeDefinition *current_array_type = prefix_rval;
	int i;
	for( i = 1; i < val; i++ ){
	  current_array_type = current_array_type->_get_element_subtype();
	  ASSERT( current_array_type->_is_array_type() == TRUE );
	}
	retval = (IIR_TypeDefinition*)current_array_type->_get_index_subtype();
      }
      delete static_val;
    }
  }
  
  return retval;
}

IIR_Declaration *
IIRScram_RangeAttribute::_get_implicit_declaration( char *decl_name,
						    IIR_TypeDefinition *decl_type ){
  // Similar code is in IIRScram_ReverseRangeAttribute 
  IIR_TypeDefinition *prefix_rval = _get_prefix_rval();
  return _build_type_declaration( decl_name, prefix_rval );
}

IIR_TypeDefinition *
IIRScram_RangeAttribute::_get_prefix_rval(){
  return _get_prefix_rval_range_attributes();
}

void 
IIRScram_RangeAttribute::_resolve_suffix_special(){
  _resolve_suffix_local_static_int();
}
