// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajsek@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_PhysicalTypeDefinition.cc,v 1.4 1999/08/02 12:50:06 dmartin Exp $
// 
//---------------------------------------------------------------------------
#include "IIR_PhysicalSubtypeDefinition.hh"
#include "IIR_EnumerationLiteral.hh"
#include "IIR_PhysicalLiteral.hh"
#include "IIR_PhysicalUnit.hh"
#include "IIR_Identifier.hh"
#include "IIR_TypeDeclaration.hh"
#include "StandardPackage.hh"
#include "IIR_IntegerSubtypeDefinition.hh"
#include "IIR_FloatingSubtypeDefinition.hh"

IIRScram_PhysicalTypeDefinition::~IIRScram_PhysicalTypeDefinition() {}

void 
IIRScram_PhysicalTypeDefinition::_publish_vhdl_type_decl(ostream &_vhdl_out) {
  _vhdl_out << " range ";
  get_left()->_publish_vhdl(_vhdl_out);

  ASSERT(get_direction()->get_kind() == IIR_ENUMERATION_LITERAL);

  if( _is_ascending_range() == TRUE ){
    _vhdl_out << " to ";
  }
  else{
    _vhdl_out << " downto ";
  }

  get_right()->_publish_vhdl(_vhdl_out);
  _vhdl_out << "\n";
  _vhdl_out << "  units\n    ";
  get_primary_unit()->get_declarator()->_publish_vhdl(_vhdl_out);
  _vhdl_out << ";\n";
  units._publish_vhdl(_vhdl_out);
  _vhdl_out << "  end units";
}


bool
IIRScram_PhysicalTypeDefinition::_is_time() {
  int i = IIR_Identifier::_cmp((IIR_Identifier*)(_get_declaration()->get_declarator()), "time");
  return (i == 0);
}

void 
IIRScram_PhysicalTypeDefinition::_publish_cc_elaborate() {
//   if (_is_time()) {
//     _cc_out << "PhysicalType";
//   }
//   else {
//     _cc_out << "Savant";
//     _get_declaration()->_get_declarator()->_publish_cc_elaborate();
//     _cc_out << "Type";
//   }

  _cc_out << "PhysicalType";
}

void
IIRScram_PhysicalTypeDefinition::_publish_cc_left() {
  if (_is_scalar_type() == TRUE)  {
    _publish_cc_kernel_type();
  }
  else {
    _publish_cc_type_name();
  }
  _cc_out << "(ObjectBase::VARIABLE, ";
  _cc_out << "(";
  if(_is_time() == TRUE) {
    _cc_out << "0";
  } else {
    _publish_cc_universal_type();
    _cc_out << "(";
    get_left()->_publish_cc_value();
    _cc_out << ")";
  }
  if(_is_subtype_decl() == FALSE) {
    _cc_out << " * ";		// All physical literals are LONG's
    ASSERT(get_primary_unit() != NULL);
    get_primary_unit()->_publish_cc_value();
  }
  
  _cc_out << ")";
  _publish_cc_object_type_info();
  _cc_out << ")";
}

void
IIRScram_PhysicalTypeDefinition::_publish_cc_right() {
  _publish_cc_type_name();
  _cc_out << "(ObjectBase::VARIABLE, ";
  _cc_out << "(";
  if(_is_time() == TRUE) {
    _publish_cc_universal_type();
    _cc_out << "::MAX";
  } else {
    _publish_cc_universal_type();
    _cc_out << "(";
    get_right()->_publish_cc_value();
    _cc_out << ")";
  }
  if(_is_subtype_decl() == FALSE) {
    _cc_out << " * ";		// All physical literals are LONG's
    ASSERT(get_primary_unit() != NULL);
    get_primary_unit()->_publish_cc_value();
  }
  _cc_out << "), ";
  _publish_cc_object_type_info();
  _cc_out << ")";
}

void
IIRScram_PhysicalTypeDefinition::_publish_cc_universal_type() {
  _cc_out << "UniversalLongLongInteger";
}
  
void 
IIRScram_PhysicalTypeDefinition::_publish_cc_kernel_type() {
  _cc_out << "PhysicalType";
}

void 
IIRScram_PhysicalTypeDefinition::_publish_cc_data_members() {
  // Publish the imageMap array
  int unit_counter=0;
  _cc_out << "  static UniversalLongLongInteger ";
  get_primary_unit()->_publish_cc_name();
  _cc_out << ";" << endl;
  _cc_out << "  static LONG sInfo[];" << endl;
  _cc_out << "  static char* uInfo[];" << endl;
 
  //Publish the function getFactor(char*)
  _cc_out << "static UniversalLongLongInteger getFactor(char* ptr) {" << endl;
  _cc_out << "if (strcmp(ptr, \"";
  get_primary_unit()->_publish_cc_name();
  _cc_out << "\") == 0) {" << endl;
  _cc_out << "return ";
  get_primary_unit()->_publish_cc_name();
  _cc_out << ";" << endl << "}" << endl;
  
  unit_counter = 0;
  IIR_PhysicalUnit* node = units.first();
  while(node != NULL) {
    unit_counter++;
    _cc_out << "if (strcmp(ptr, \"";
    node->_publish_cc_name();
    _cc_out << "\") == 0) {" << endl;
    _cc_out << "return ";
    _publish_cc_type_name();
    _cc_out << "_info.scaleInfo[" << unit_counter << "] * ";
    get_primary_unit()->_publish_cc_name();
    _cc_out << ";" << endl << "}" << endl;
    node = units.successor(node);
  }
  _cc_out << "return 0;" << endl;
  _cc_out << "}" << endl;
}

void 
IIRScram_PhysicalTypeDefinition::_publish_cc_decl_cc() {
  char *className;
  int unit_counter=0;
  strstream classStream;
  IIR_PhysicalUnit *node;

  classStream << "Savant" << ((IIR_TypeDeclaration *) _get_declaration())->_get_declarator()->_convert_to_c_string() <<"Type" << ends;

  className = classStream.str();

  _cc_out << "#include \"" << className << ".hh\"" << endl;
  _cc_out << endl;
  if(_is_subtype_decl() == FALSE) {
    node = get_primary_unit();
    _cc_out << "UniversalLongLongInteger " << className << "::";
    node->_publish_cc_name();
    _cc_out << " = 1;" << endl;
    //Publishing UnitInfo
    IIR_PhysicalUnit* nodetemp = units.first();
    while(nodetemp != NULL){
      nodetemp = units.successor(nodetemp);
      unit_counter++;
    }
    _cc_out << "char *" << className << "::uInfo[" 
	    << unit_counter + 1 << "] = {\"";
    get_primary_unit()->_publish_cc_name();
    _cc_out << "\"";
     nodetemp = units.first();
     while(nodetemp != NULL){
       _cc_out << ", ";
       _cc_out << "\"";
       nodetemp->_publish_cc_name();
       _cc_out << "\"";
       nodetemp = units.successor(nodetemp);
     }
     _cc_out << "};" << endl;
     //Publishing ScaleInfo
     _cc_out << "LONG " << className << "::sInfo[" 
	     << unit_counter + 1<< "] = { 1";
    for (node = units.first(); node != NULL; node = units.successor(node)){
      _cc_out << ", ";
      nodetemp = node;
      ((IIR_PhysicalLiteral *) nodetemp->get_multiplier())->get_abstract_literal()->_publish_cc_value();
      while(((IIR_PhysicalLiteral *) nodetemp->get_multiplier())->get_unit_name() != get_primary_unit()){
	_cc_out << " * ";
	nodetemp = ((IIR_PhysicalLiteral *)nodetemp->get_multiplier())->get_unit_name();
      ((IIR_PhysicalLiteral *) nodetemp->get_multiplier())->get_abstract_literal()->_publish_cc_value();
      }
    }
    _cc_out << "};" << endl;
  }

  //The attributes have been pushed to the kernel
  //  _publish_cc_define_type_attributes();

  //   _publish_cc_decl_relational_operators();
  //   _publish_cc_decl_operators();
}


void 
IIRScram_PhysicalTypeDefinition::_publish_cc_attribute_image() {

  _cc_out << "const SavantstringType ";
  _cc_out << "\n";
  _publish_cc_type_name();
  _cc_out << "::IMAGE(const ";
  _publish_cc_base_type_name();
  _cc_out << "& x";
  _cc_out << ") {\n";
  if(_is_subtype_decl() == TRUE) {
    _cc_out << "return ";
    _publish_cc_base_type_name();
    _cc_out << "::IMAGE(x);" << endl;
  }
  else {
    _cc_out << "UniversalLongLongInteger value;\n";
    _cc_out <<" value = x.getObject()->readVal();\n";
    _cc_out << "strstream string;\n";
    _cc_out << "string << value << \" ";
    get_primary_unit()->_publish_cc_name();
    _cc_out << "\" << ends;\n";
    _cc_out << "char* ptr = string.str();\n";
    _cc_out << "SavantstringType image(ObjectBase::VARIABLE,0,to,strlen(ptr) - 1,ptr);\n";
    _cc_out << "return image;\n";
  }
  _cc_out << "}\n";
}

void 
IIRScram_PhysicalTypeDefinition::_publish_cc_attribute_value() {
  _cc_out << "const ";
  _publish_cc_base_type_name();
  _cc_out << "\n";
  _publish_cc_type_name();
  _cc_out << "::VALUE(const SavantstringType& x) {\n";
  if(_is_subtype_decl() == TRUE) {
    _cc_out << "return ";
    _publish_cc_base_type_name();
    _cc_out << "(ObjectBase::VARIABLE, ";
    _publish_cc_base_type_name();
    _cc_out << "::VALUE(x).getVHDLData());" << endl;
  }
  else {
    _cc_out << "int length = x.get_number_of_elements();" << endl 
	    << "strstream value;" << endl 
	    << "char* ptr;" << endl 
	    << "for(int i=0; i < length; i++) {" << endl 
	    << "x.get_element(i).print(value);" << endl 
	    << "}" << endl 
	    << "value << ends;" << endl 
	    << "ptr = value.str();" << endl 
	    << "LONG val = str_to_long_long(strtok(ptr,\" \"));" 
	    << endl 
	    << "val = val * ";
    _publish_cc_type_name();
    _cc_out << "::getFactor(strtok(NULL, \" \"));" << endl;
    _publish_cc_base_type_name();
    _cc_out << " retval(ObjectBase::VARIABLE, val);"
	    << "return retval;" << endl;
  }
  _cc_out << "}" << endl;
}

void
IIRScram_PhysicalTypeDefinition::_publish_cc_multiply_operator_prototype() {
  // Physical type * Integer type
  _cc_out << "extern ";
  _publish_cc_type_name();
  _cc_out << endl
	  << "savantMultiply(const ";
  _publish_cc_type_name();
  _cc_out << "& lhs, const SavantintegerType& rhs);" << endl;

  // Integer type * Physical type
  _cc_out << "extern ";
  _publish_cc_type_name();
  _cc_out << endl
	  << "savantMultiply(const SavantintegerType& lhs, const ";
  _publish_cc_type_name();
  _cc_out << "& rhs);" << endl;

  // Physical type * Real type
  _cc_out << "extern ";
  _publish_cc_type_name();
  _cc_out << endl
	  << "savantMultiply(const ";
  _publish_cc_type_name();
  _cc_out << "& lhs, const SavantrealType& rhs);" << endl;

  // Real type * Physical type
  _cc_out << "extern ";
  _publish_cc_type_name();
  _cc_out << endl
	  << "savantMultiply(const SavantrealType& lhs, const ";
  _publish_cc_type_name();
  _cc_out << "& rhs);" << endl;
}

void 
IIRScram_PhysicalTypeDefinition::_publish_cc_multiply_operator() {
  // Physical type * Integer type
  _publish_cc_type_name();
  _cc_out << endl
	  << " savantMultiply(const ";
  _publish_cc_type_name();
  _cc_out << "& lhs, const SavantintegerType& rhs)  {" << endl;
  _publish_cc_type_name();
  _cc_out << " retval(ObjectBase::VARIABLE);" << endl;
  _publish_cc_universal_type(); 
  _cc_out << " tmp = savantMultiply((const ";
  _publish_cc_universal_type();
  _cc_out << "&) lhs.getVHDLData(), "
	  << "(const UniversalInteger&) rhs.getVHDLData());" << endl
	  << "retval.getObject()->updateVal(tmp);" << endl
	  << "return retval;" << endl
	  << "}" << endl;

  // Integer type * Physical type
  _publish_cc_type_name();
  _cc_out << endl
	  << " savantMultiply(const SavantintegerType& lhs, const ";
  _publish_cc_type_name();
  _cc_out << "& rhs)  {" << endl
	  << "  return savantMultiply(rhs, lhs);" << endl
	  << "}" << endl;

  // Physical type * Real type
  _publish_cc_type_name();
  _cc_out << endl
	  << " savantMultiply(const ";
  _publish_cc_type_name();
  _cc_out << "& lhs, const SavantrealType& rhs)  {" << endl;
  _publish_cc_type_name();
  _cc_out << " retval(ObjectBase::VARIABLE);" << endl;
  _publish_cc_universal_type(); 
  _cc_out << " tmp = savantMultiply((const ";
  _publish_cc_universal_type();
  _cc_out << "&) lhs.getVHDLData(), "
	  << "(const UniversalReal&) rhs.getVHDLData());" << endl
	  << "retval.getObject()->updateVal(tmp);" << endl
	  << "return retval;" << endl
	  << "}" << endl;

  // Real type * Physical type
  _publish_cc_type_name();
  _cc_out << endl
	  << " savantMultiply(const SavantrealType& lhs, ";
  _publish_cc_type_name();
  _cc_out << "& rhs)  {" << endl
	  << "  return savantMultiply(rhs, lhs);" << endl
	  << "}" << endl;
}

void
IIRScram_PhysicalTypeDefinition::_publish_cc_divide_operator_prototype() {
  // Physical type / Integer type
  _cc_out << "extern ";
  _publish_cc_type_name();
  _cc_out << " savantDivide(const ";
  _publish_cc_type_name();
  _cc_out << "& lhs, const SavantintegerType& rhs);" << endl;

  // Physical type / Real type
  _cc_out << "extern ";
  _publish_cc_type_name();
  _cc_out << " savantDivide(const ";
  _publish_cc_type_name();
  _cc_out << "& lhs, const SavantrealType& rhs);" << endl;

  // Physical type / Physical type
  _cc_out << "extern SavantintegerType savantDivide(const ";
  _publish_cc_type_name();
  _cc_out << "& lhs, const ";
  _publish_cc_type_name();
  _cc_out << "& rhs);" << endl;
}

void 
IIRScram_PhysicalTypeDefinition::_publish_cc_divide_operator() {
  // Physical type / Integer type
  _publish_cc_type_name();
  _cc_out << endl
	  << "savantDivide(const ";
  _publish_cc_type_name();
  _cc_out << "& lhs, const SavantintegerType& rhs) {" << endl;
  _publish_cc_type_name();
  _cc_out << " retval(ObjectBase::VARIABLE);" << endl;
  _publish_cc_universal_type(); 
  _cc_out << " tmp = savantDivide((";
  _publish_cc_universal_type();
  _cc_out << "&) lhs.getVHDLData(), "
	  << "(const UniversalInteger&) rhs.getVHDLData());" << endl
	  << "retval.getObject()->updateVal(tmp);" << endl
	  << "return retval;" << endl
	  << "}" << endl;

  // Physical type / Real type
  _publish_cc_type_name();
  _cc_out << endl
	  << "savantDivide(const ";
  _publish_cc_type_name();
  _cc_out << "& lhs, const SavantrealType& rhs) {" << endl;
  _publish_cc_type_name();
  _cc_out << " retval(ObjectBase::VARIABLE);" << endl;
  _publish_cc_universal_type(); 
  _cc_out << " tmp = savantDivide((";
  _publish_cc_universal_type();
  _cc_out << "&) lhs.getVHDLData(), "
	  << "(const UniversalReal&) rhs.getVHDLData());" << endl
	  << "retval.getObject()->updateVal(tmp);" << endl
	  << "return retval;" << endl
	  << "}" << endl;

  // Physical type / Physical type
  _cc_out << "SavantintegerType " << endl
	  << "savantDivide(const ";
  _publish_cc_type_name();
  _cc_out << "& lhs, const ";
  _publish_cc_type_name();
  _cc_out << "& rhs) {" << endl
	  << "SavantintegerType retval(ObjectBase::VARIABLE);" << endl;
  _cc_out << "UniversalInteger tmp = savantDivide((";
  _publish_cc_universal_type();
  _cc_out << "&) lhs.getVHDLData(), (";
  _publish_cc_universal_type();
  _cc_out << "&) rhs.getVHDLData());" << endl
	  << "retval.getObject()->updateVal(tmp);" << endl
	  << "return retval;" << endl
	  << "}" << endl;
}

void 
IIRScram_PhysicalTypeDefinition::_publish_cc_type_info() {
  int unit_counter = 0;
  IIR_PhysicalUnit *node;
  //Publishing unit info
  IIR_PhysicalUnit* nodetemp = units.first();
  while(nodetemp != NULL){
    nodetemp = units.successor(nodetemp);
    unit_counter++;
  }

  nodetemp = units.first();
  _cc_out << "static char *";
  _publish_cc();
  _cc_out << "_uInfo[" << unit_counter + 1 << "] = {\"";
  get_primary_unit()->_publish_cc_name();
  _cc_out << "\"";
  while(nodetemp != NULL){
    _cc_out << ", ";
    _cc_out << "\"";
    nodetemp->_publish_cc_name();
    _cc_out << "\"";
    nodetemp = units.successor(nodetemp);
  }
  _cc_out << "};" <<  endl;


  //Publishing ScaleInfo
  _cc_out << "LONG ";
  _publish_cc();
  _cc_out << "_sInfo[" << unit_counter + 1<< "] = { 1";
  for (node = units.first(); node != NULL; node = units.successor(node)){
    _cc_out << ", ";
    nodetemp = node;
    ((IIR_PhysicalLiteral *) nodetemp->get_multiplier())->get_abstract_literal()->_publish_cc_universal_value();
    while(((IIR_PhysicalLiteral *) nodetemp->get_multiplier())->get_unit_name() != get_primary_unit()){
      _cc_out << " * ";
      nodetemp = ((IIR_PhysicalLiteral *)nodetemp->get_multiplier())->get_unit_name();
      ((IIR_PhysicalLiteral *) nodetemp->get_multiplier())->get_abstract_literal()->_publish_cc_universal_value();
    }
  }
  _cc_out << "};" << endl;

  //Publishing physical type_info
  _cc_out << "phyInfo ";
  _publish_cc();
  _cc_out << "_info(";
  _cc_out << unit_counter + 1 << ", (long)";
  get_left()->_publish_cc_value();
  _cc_out   << ", ";     
  if (get_direction()->_is_ascending_range() == TRUE){
    _cc_out << "to";
  }
  else {
    _cc_out << "downto";
  }
  _cc_out << ", (long)";
  get_right()->_publish_cc_value();
  _cc_out << ", ";     
  _publish_cc();
  _cc_out << "_sInfo";
  _cc_out << ", ";     
  _publish_cc();
  _cc_out << "_uInfo);";
  _cc_out << endl;
} 

void 
IIRScram_PhysicalTypeDefinition::_publish_cc_extern_type_info() {
  _cc_out << "extern phyInfo ";
  _publish_cc();
  _cc_out << "_info;" << endl;
}

void 
IIRScram_PhysicalTypeDefinition::_publish_cc_type_string(){
  _cc_out << "PhysicalType";
}


IIR_TypeDefinition *
IIRScram_PhysicalTypeDefinition::_get_new_subtype(){
  IIR_TypeDefinition *retval = new IIR_PhysicalSubtypeDefinition();
  copy_location( this, retval );
  return retval;
}

IIR *
IIRScram_PhysicalTypeDefinition::_clone(){
  IIR_PhysicalTypeDefinition *retval = new IIR_PhysicalTypeDefinition();
  _clone( retval );
  return retval;
}

void 
IIRScram_PhysicalTypeDefinition::_clone( IIR_PhysicalTypeDefinition *copy_into ){
  copy_into->set_primary_unit( get_primary_unit() );
  copy_into->units = units;
  
  IIRScram_ScalarTypeDefinition::_clone( copy_into );
}

void 
IIRScram_PhysicalTypeDefinition::_build_implicit_operators( set<IIR_Declaration> *add_to ){
  IIR_ScalarTypeDefinition::_build_implicit_operators( add_to );

  IIR_TypeDefinition *integer_type = StandardPackage::integer_type;
  IIR_TypeDefinition *real_type =  StandardPackage::real_type;

  IIR_TypeDefinition::_build_implicit_operator( "\"*\"",
						add_to,
						this,
						this,
						integer_type );

  IIR_TypeDefinition::_build_implicit_operator( "\"*\"",
						add_to,
						this,
						this,
						real_type );

  IIR_TypeDefinition::_build_implicit_operator( "\"*\"",
						add_to,
						this,
						integer_type,
						this );

  IIR_TypeDefinition::_build_implicit_operator( "\"*\"",
						add_to,
						this,
					        real_type,
						this );

  IIR_TypeDefinition::_build_implicit_operator( "\"/\"",
						add_to,
						this,
						this,
					        integer_type );

  IIR_TypeDefinition::_build_implicit_operator( "\"/\"",
						add_to,
						this,
						this,
						real_type );

  IIR_TypeDefinition::_build_implicit_operator( "\"/\"",
						add_to,
						StandardPackage::savant_universal_integer,
						this,
					        this );
}
