
// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_PhysicalSubtypeDefinition.cc,v 1.2 1999/03/09 20:55:51 dmartin Exp $
// 
//---------------------------------------------------------------------------
#include "IIR_PhysicalSubtypeDefinition.hh"
#include "IIR_PhysicalUnit.hh"
#include "IIR_PhysicalLiteral.hh"
#include "IIR_FunctionDeclaration.hh"

IIRScram_PhysicalSubtypeDefinition::~IIRScram_PhysicalSubtypeDefinition(){}

void 
IIRScram_PhysicalSubtypeDefinition::_publish_vhdl_decl(ostream &_vhdl_out){
  // We have to do this because IIR_PhysicalTypeDefinition (our parent)
  // has overloaded this method, but we want one lower than that.
  IIR_ScalarTypeDefinition::_publish_vhdl_decl( _vhdl_out );
}

IIR_Boolean
IIRScram_PhysicalSubtypeDefinition::_is_subtype(){
  return TRUE;
}


void 
IIRScram_PhysicalSubtypeDefinition::_publish_cc_type_info(){
  int unit_counter = 0;
  IIR_PhysicalUnit *node;

  if (_is_anonymous() == FALSE) {
    //Publishing unit info
    IIR_PhysicalUnit* nodetemp = units.first();
    while(nodetemp != NULL){
      nodetemp = units.successor(nodetemp);
      unit_counter++;
    }
    
    nodetemp = units.first(); 
    _cc_out << "static char *";
    _publish_cc();
    _cc_out << "_uInfo[" << unit_counter + 1 << "] = {\"";
    
    if (get_primary_unit() != NULL) {
      get_primary_unit()->_publish_cc_name();
    }
    else {
      // Get the primary unit from the parent class and use it.
      ASSERT ( _get_base_type() != NULL );
      ASSERT ( _get_base_type()->_is_iir_physical_type_definition() == TRUE );
      IIR_PhysicalTypeDefinition *baseType = (IIR_PhysicalTypeDefinition *)
	_get_base_type();
      ASSERT ( baseType->get_primary_unit() != NULL );
      baseType->get_primary_unit()->_publish_cc_name();
    }
    
    _cc_out << "\"";
    while(nodetemp != NULL){
      _cc_out << ", ";
      _cc_out << "\"";
      nodetemp->_publish_cc_name();
      _cc_out << "\"";
      nodetemp = units.successor(nodetemp);
    }
    _cc_out << "};" << endl;
    
     //Publishing ScaleInfo
    _cc_out << "LONG ";
    _publish_cc();
    _cc_out << "_sInfo[" << unit_counter + 1<< "] = { 1";
    for (node = units.first(); node != NULL; node = units.successor(node)){
      _cc_out << ", ";
      nodetemp = node;
      
      ASSERT (nodetemp->get_multiplier() != NULL);
      ASSERT (nodetemp->get_multiplier()->get_kind() == IIR_PHYSICAL_LITERAL);
      
      IIR_PhysicalLiteral *tempLit = (IIR_PhysicalLiteral *)
	node->get_multiplier();

      _cc_out << "longlongint(";
      
      if (tempLit->get_abstract_literal() != NULL)  {
	tempLit->_publish_cc_universal_value();
      }
      else {
	_cc_out << " 1 ";
      }

      _cc_out << ")";
      
      // nodetemp->get_multiplier()->_publish_cc_universal_value();
    }
    _cc_out << "};" <<  endl;

    //Publishing the physical type_info
    _cc_out << "phyInfo ";
    _publish_cc();
    _cc_out << "_info(";
    _cc_out << unit_counter + 1 << ", (long)";
    get_left()->_publish_cc_value();
    _cc_out   << ", ";     
    if (get_direction()->_is_ascending_range() == TRUE){
      _cc_out << "to";
    }
    else {
      _cc_out << "downto";
    }
    _cc_out << ", (long) ";     
    get_right()->_publish_cc_value();
    _cc_out << ", ";     
    _publish_cc();
    _cc_out << "_sInfo";
    _cc_out << ", ";     
    _publish_cc();
    _cc_out << "_uInfo);";
    _cc_out << endl;
  }
}

void 
IIRScram_PhysicalSubtypeDefinition::_publish_cc_extern_type_info(){
  _cc_out << "extern phyInfo ";
  if (_is_anonymous() == FALSE) {
    _publish_cc();
  }
  else {
    ASSERT (_get_base_type() != NULL);
    _get_base_type()->_publish_cc();
  }
  
  _cc_out << "_info;" << endl;
}

IIR *
IIRScram_PhysicalSubtypeDefinition::_clone(){
  IIR_PhysicalSubtypeDefinition *retval = new IIR_PhysicalSubtypeDefinition();
  _clone( retval );
  return retval;
}

void 
IIRScram_PhysicalSubtypeDefinition::_clone( IIR_PhysicalSubtypeDefinition *copy_into ){
  copy_into->set_resolution_function( get_resolution_function() );

  IIRScram_ScalarTypeDefinition::_clone( copy_into );
}







