// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_NegationOperator.cc,v 1.2 1999/03/09 20:55:36 dmartin Exp $
// 
//---------------------------------------------------------------------------

#include "IIRScram_NegationOperator.hh"

IIRScram_NegationOperator::~IIRScram_NegationOperator() {}

void 
IIRScram_NegationOperator::_publish_vhdl_operator(ostream &_vhdl_out) {
  ASSERT(get_operand()->_is_resolved() == TRUE);
  _vhdl_out << "-";
}


void 
IIRScram_NegationOperator::_publish_cc() {
  ASSERT(get_operand()->_is_resolved() == TRUE);

  _cc_out << "savantUnaryMinus(";
  get_operand()->_publish_cc();
  _cc_out << ")";
  
}


void 
IIRScram_NegationOperator::_publish_cc_universal_value() {
  switch (get_operand()->get_kind()) {
  case  IIR_INTEGER_LITERAL:
  case  IIR_INTEGER_LITERAL32:
  case  IIR_INTEGER_LITERAL64:
    _cc_out << "-1 * (int) ";
    get_operand()->_publish_cc_universal_value();
    break;
  case  IIR_FLOATING_POINT_LITERAL:
  case  IIR_FLOATING_POINT_LITERAL32:
  case  IIR_FLOATING_POINT_LITERAL64:
    _cc_out << "-1.0 * ";
    get_operand()->_publish_cc_universal_value();
    break;
  default:
    _cc_out << "-";
    get_operand()->_publish_cc();
    break;
  }
}

void 
IIRScram_NegationOperator::_publish_cc_wait_data() {
  _cc_out << "-1 * ";
  get_operand()->_publish_cc_wait_data();
}

IIRScram::OperatorPrecedenceLevel
IIRScram_NegationOperator::_get_operator_precedence(){
  return IIRScram::SIGN_OPERATOR;
}
