#ifndef IIRSCRAM_NAME_HH
#define IIRSCRAM_NAME_HH

// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ececs.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_Name.hh,v 1.3 1999/08/26 13:47:07 dmartin Exp $
// 
//---------------------------------------------------------------------------

#include "IIRBase_Name.hh"
#include "savant.hh"

// template <class type> class set;
class IIR_Declaration;
class IIR_DesignatorList;
class IIR_TextLiteral;
class IIR_Name;
template <class type> class set;

class IIRScram_Name : public IIRBase_Name {
// @BeginAutoDocExternalProseDescription
// @EndAutoDocExternalProseDescription

public:
  virtual ~IIRScram_Name() = 0;

  void _publish_vhdl(ostream &);
  IIR_Boolean _is_name();
  IIR_Boolean _is_iir_name(){ return TRUE; }

  IIR_Boolean _is_object(); 
  IIR_Boolean _is_signal();
  IIR_Boolean _is_variable();
  IIR_Boolean _is_array_type();
  IIR_Boolean _is_static_expression();
  IIR_Boolean _is_longest_static_prefix();
  IIR_Boolean _is_composite_resolved_signal();
  virtual IIR_Boolean _is_by_all(){ return FALSE; }

  virtual IIR_TypeDefinition *_get_subtype();
  virtual void _set_subtype( IIR_TypeDefinition * );

  virtual IIR_TypeDefinition *_get_name_type();
  void _publish_cc_addChild();
  void _publish_cc_binding_name(ostream& outstream = _cc_out);
  void _publish_cc_type_name();

  virtual ostream &_print( ostream & os );
  virtual set<IIR_Declaration> *_symbol_lookup();
  virtual set<IIR_Declaration> *_symbol_lookup( IIR_Declaration * );
  virtual set<IIR_Declaration> *_symbol_lookup( set<IIR_Declaration> * );
  virtual set<IIR_Declaration> *_symbol_lookup( IIR_Boolean (IIR::*constraint_function)() );

  IIR_TextLiteral *_get_string();
  virtual char *_convert_to_library_name();

  virtual void _get_list_of_input_signals(set<IIR_Declaration>* list);  
  void _build_sensitivity_list(IIR_DesignatorList* sensitivity_list);
  void _get_signal_source_info(set<IIR_Declaration>* siginfo);

  IIR_SignalKind _get_signal_kind();

  set<IIR_TypeDefinition> *
  _get_rval_set(IIR_Boolean (IIR::*constraint_function)() = 0){ 
    return IIR::_get_rval_set( constraint_function );
  }

  set<IIR_TypeDefinition> *_get_rval_set( set<IIR_TypeDefinition> *search_in,
					  IIR_Boolean (IIR::*constraint_function)() = 0 );
  set<IIR_TypeDefinition> *_get_rval_set( set<IIR_Declaration> *search_in,
					  IIR_Boolean (IIR::*constraint_function)() = 0 );

  virtual IIR *_get_suffix() { return NULL; }

  virtual void _set_suffix(IIR *suffix);

  // This method returns the prefix as an IIR_Identifier...  (this SHOULD 
  // always be possible...)
  virtual IIR_TextLiteral *_get_prefix_string();
  IIR_TextLiteral *_get_declarator();

  void _clone(IIR_Name*);

  virtual void _build_lib( IIR_LibraryUnit * );

protected:
  IIRScram_Name() {}
    
private:
};
#endif
